/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.Arrays;
import net.imglib2.blocks.Extension;
import net.imglib2.blocks.ExtensionImpl;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.NativeType;

class PrimitiveBlocksUtils {
    PrimitiveBlocksUtils() {
    }

    static <T extends NativeType<T>> Object extractOobValue(T type, Extension extension) {
        if (extension.type() == Extension.Type.CONSTANT) {
            NativeType oobValue = (NativeType)((ExtensionImpl.ConstantExtension)extension).getValue();
            NativeImg img = new ArrayImgFactory<T>(type).create(new long[]{1L});
            ((NativeType)img.firstElement()).set(oobValue);
            return ((ArrayDataAccess)((ArrayImg)img).update(null)).getCurrentStorageArray();
        }
        return null;
    }

    static MixedTransform invPermutationInversion(MixedTransform transform) {
        int n = transform.numTargetDimensions();
        int[] component = new int[n];
        boolean[] invert = new boolean[n];
        boolean[] zero = new boolean[n];
        transform.getComponentMapping(component);
        transform.getComponentInversion(invert);
        transform.getComponentZero(zero);
        int m = transform.numSourceDimensions();
        int[] invComponent = new int[m];
        boolean[] invInvert = new boolean[m];
        boolean[] invZero = new boolean[m];
        Arrays.fill(invZero, true);
        for (int i = 0; i < n; ++i) {
            if (transform.getComponentZero(i)) continue;
            int j = component[i];
            invComponent[j] = i;
            invInvert[j] = invert[i];
            invZero[j] = false;
        }
        MixedTransform invTransform = new MixedTransform(n, m);
        invTransform.setComponentMapping(invComponent);
        invTransform.setComponentInversion(invInvert);
        invTransform.setComponentZero(invZero);
        return invTransform;
    }

    static MixedTransform[] split(MixedTransform transform) {
        int n = transform.numTargetDimensions();
        int[] component = new int[n];
        boolean[] invert = new boolean[n];
        boolean[] zero = new boolean[n];
        long[] translation = new long[n];
        transform.getComponentMapping(component);
        transform.getComponentInversion(invert);
        transform.getComponentZero(zero);
        transform.getTranslation(translation);
        int m = transform.numSourceDimensions();
        int[] splitComponent = new int[m];
        boolean[] splitInvert = new boolean[m];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (zero[i]) continue;
            splitComponent[j] = component[i];
            splitInvert[j] = invert[i];
            component[i] = j++;
        }
        MixedTransform permuteInvert = new MixedTransform(m, m);
        permuteInvert.setComponentMapping(splitComponent);
        permuteInvert.setComponentInversion(splitInvert);
        MixedTransform remainder = new MixedTransform(m, n);
        remainder.setComponentMapping(component);
        remainder.setComponentZero(zero);
        remainder.setTranslation(translation);
        return new MixedTransform[]{permuteInvert, remainder};
    }
}

