/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.InputMap;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.InputTriggerDescription;

public class InputTriggerDescriptionsBuilder {
    private final InputTriggerConfig config;

    public InputTriggerDescriptionsBuilder() {
        this(new InputTriggerConfig());
    }

    public InputTriggerDescriptionsBuilder(InputTriggerConfig config) {
        this.config = config;
    }

    public List<InputTriggerDescription> getDescriptions() {
        ArrayList<InputTriggerDescription> descs = new ArrayList<InputTriggerDescription>();
        for (Set<InputTriggerConfig.Input> inputs : this.config.actionToInputsMap.values()) {
            for (InputTriggerConfig.Input input : inputs) {
                boolean found = false;
                for (InputTriggerDescription desc : descs) {
                    if (!input.behaviour.equals(desc.getAction()) || !input.contexts.equals(new HashSet<String>(Arrays.asList(desc.getContexts())))) continue;
                    desc.addTrigger(input.trigger.toString());
                    found = true;
                    break;
                }
                if (found) continue;
                descs.add(input.getDescription());
            }
        }
        return descs;
    }

    public Set<String> getContexts() {
        LinkedHashSet<String> contexts = new LinkedHashSet<String>();
        for (Map.Entry<String, Set<InputTriggerConfig.Input>> entry : this.config.actionToInputsMap.entrySet()) {
            for (InputTriggerConfig.Input input : entry.getValue()) {
                contexts.addAll(input.contexts);
            }
        }
        return contexts;
    }

    public Set<String> getBehaviourNames() {
        return new LinkedHashSet<String>(this.config.actionToInputsMap.keySet());
    }

    public void addMap(InputTriggerMap map, String context) {
        this.config.addMap(map, context);
    }

    public void addMap(InputMap map, String context) {
        this.config.addMap(map, context);
    }
}

