/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.ModelChangeListener;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.features.FeatureFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class Model {
    private static final boolean DEBUG = false;
    private final FeatureModel featureModel;
    private final TrackModel trackModel;
    protected SpotCollection spots = new SpotCollection();
    private int updateLevel = 0;
    private final HashSet<Spot> spotsAdded = new HashSet();
    private final HashSet<Spot> spotsRemoved = new HashSet();
    private final HashSet<Spot> spotsMoved = new HashSet();
    private final HashSet<Spot> spotsUpdated = new HashSet();
    private final HashSet<Integer> eventCache = new HashSet();
    private Logger logger = Logger.DEFAULT_LOGGER;
    private String spaceUnits = "pixels";
    private String timeUnits = "frames";
    Set<ModelChangeListener> modelChangeListeners = new LinkedHashSet<ModelChangeListener>();

    public Model() {
        this.featureModel = this.createFeatureModel();
        this.trackModel = this.createTrackModel();
    }

    protected TrackModel createTrackModel() {
        return new TrackModel();
    }

    protected FeatureModel createFeatureModel() {
        return new FeatureModel(this);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('\n');
        if (null == this.spots || this.spots.keySet().size() == 0) {
            str.append("No spots.\n");
        } else {
            str.append("Contains " + this.spots.getNSpots(false) + " spots in total.\n");
        }
        if (this.spots.getNSpots(true) == 0) {
            str.append("No filtered spots.\n");
        } else {
            str.append("Contains " + this.spots.getNSpots(true) + " filtered spots.\n");
        }
        str.append('\n');
        if (this.trackModel.nTracks(false) == 0) {
            str.append("No tracks.\n");
        } else {
            str.append("Contains " + this.trackModel.nTracks(false) + " tracks in total.\n");
        }
        if (this.trackModel.nTracks(true) == 0) {
            str.append("No filtered tracks.\n");
        } else {
            str.append("Contains " + this.trackModel.nTracks(true) + " filtered tracks.\n");
        }
        str.append('\n');
        str.append("Physical units:\n  space units: " + this.spaceUnits + "\n  time units: " + this.timeUnits + "\n");
        str.append('\n');
        str.append(this.featureModel.toString());
        return str.toString();
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public boolean removeModelChangeListener(ModelChangeListener listener) {
        return this.modelChangeListeners.remove(listener);
    }

    public Set<ModelChangeListener> getModelChangeListener() {
        return this.modelChangeListeners;
    }

    public void setPhysicalUnits(String spaceUnits, String timeUnits) {
        this.spaceUnits = spaceUnits;
        this.timeUnits = timeUnits;
    }

    public String getSpaceUnits() {
        return this.spaceUnits;
    }

    public String getTimeUnits() {
        return this.timeUnits;
    }

    public synchronized void beginUpdate() {
        ++this.updateLevel;
    }

    public synchronized void endUpdate() {
        --this.updateLevel;
        if (this.updateLevel == 0) {
            this.flushUpdate();
        }
    }

    public void clearTracks(boolean doNotify) {
        this.trackModel.clear();
        if (doNotify) {
            ModelChangeEvent event = new ModelChangeEvent(this, 6);
            for (ModelChangeListener listener : this.modelChangeListeners) {
                listener.modelChanged(event);
            }
        }
    }

    public TrackModel getTrackModel() {
        return this.trackModel;
    }

    public void setTracks(SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph, boolean doNotify) {
        this.trackModel.setGraph(graph);
        if (doNotify) {
            ModelChangeEvent event = new ModelChangeEvent(this, 6);
            for (ModelChangeListener listener : this.modelChangeListeners) {
                listener.modelChanged(event);
            }
        }
    }

    public SpotCollection getSpots() {
        return this.spots;
    }

    public void clearSpots(boolean doNotify) {
        this.spots.clear();
        if (doNotify) {
            ModelChangeEvent event = new ModelChangeEvent(this, 4);
            for (ModelChangeListener listener : this.modelChangeListeners) {
                listener.modelChanged(event);
            }
        }
    }

    public void setSpots(SpotCollection spots, boolean doNotify) {
        this.spots = spots;
        if (doNotify) {
            ModelChangeEvent event = new ModelChangeEvent(this, 4);
            for (ModelChangeListener listener : this.modelChangeListeners) {
                listener.modelChanged(event);
            }
        }
    }

    public void filterSpots(Collection<FeatureFilter> spotFilters, boolean doNotify) {
        this.spots.filter(spotFilters);
        if (doNotify) {
            ModelChangeEvent event = new ModelChangeEvent(this, 5);
            for (ModelChangeListener listener : this.modelChangeListeners) {
                listener.modelChanged(event);
            }
        }
    }

    public void notifyFeaturesComputed() {
        ModelChangeEvent event = new ModelChangeEvent(this, 9);
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listener.modelChanged(event);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    public synchronized Spot moveSpotFrom(Spot spotToMove, Integer fromFrame, Integer toFrame) {
        boolean ok = this.spots.remove(spotToMove, fromFrame);
        if (!ok) {
            return null;
        }
        this.spots.add(spotToMove, toFrame);
        this.trackModel.edgesModified.addAll(this.trackModel.edgesOf(spotToMove));
        this.spotsMoved.add(spotToMove);
        return spotToMove;
    }

    public synchronized Spot addSpotTo(Spot spotToAdd, Integer toFrame) {
        this.spots.add(spotToAdd, toFrame);
        this.spotsAdded.add(spotToAdd);
        this.trackModel.addSpot(spotToAdd);
        return spotToAdd;
    }

    public synchronized Spot removeSpot(Spot spotToRemove) {
        int fromFrame = spotToRemove.getFeature("FRAME").intValue();
        if (this.spots.remove(spotToRemove, fromFrame)) {
            this.spotsRemoved.add(spotToRemove);
            this.trackModel.removeSpot(spotToRemove);
            return spotToRemove;
        }
        return null;
    }

    public synchronized void updateFeatures(Spot spotToUpdate) {
        this.spotsUpdated.add(spotToUpdate);
        Set<DefaultWeightedEdge> touchingEdges = this.trackModel.edgesOf(spotToUpdate);
        if (null != touchingEdges) {
            this.trackModel.edgesModified.addAll(touchingEdges);
        }
    }

    public synchronized DefaultWeightedEdge addEdge(Spot source, Spot target, double weight) {
        return this.trackModel.addEdge(source, target, weight);
    }

    public synchronized DefaultWeightedEdge removeEdge(Spot source, Spot target) {
        return this.trackModel.removeEdge(source, target);
    }

    public synchronized boolean removeEdge(DefaultWeightedEdge edge) {
        return this.trackModel.removeEdge(edge);
    }

    public synchronized void setEdgeWeight(DefaultWeightedEdge edge, double weight) {
        this.trackModel.setEdgeWeight(edge, weight);
    }

    public synchronized boolean setTrackVisibility(Integer trackID, boolean visible) {
        boolean modified;
        boolean oldvis = this.trackModel.setVisibility(trackID, visible);
        boolean bl = modified = oldvis != visible;
        if (modified) {
            this.eventCache.add(7);
        }
        return oldvis;
    }

    public Model copy() {
        Model copy = new Model();
        copy.setPhysicalUnits(this.spaceUnits, this.timeUnits);
        SpotCollection spots2 = SpotCollection.fromCollection(this.spots.iterable(true));
        copy.setSpots(spots2, false);
        SimpleWeightedGraph graphCopy = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        Graphs.addGraph((Graph)graphCopy, this.trackModel.graph);
        copy.getTrackModel().from((SimpleWeightedGraph<Spot, DefaultWeightedEdge>)graphCopy, new HashMap<Integer, Set<Spot>>(this.trackModel.connectedVertexSets), new HashMap<Integer, Set<DefaultWeightedEdge>>(this.trackModel.connectedEdgeSets), new HashMap<Integer, Boolean>(this.trackModel.visibility), new HashMap<Integer, String>(this.trackModel.names));
        FeatureModel fm2 = copy.getFeatureModel();
        fm2.declareSpotFeatures(this.featureModel.getSpotFeatures(), this.featureModel.getSpotFeatureNames(), this.featureModel.getSpotFeatureShortNames(), this.featureModel.getSpotFeatureDimensions(), this.featureModel.getSpotFeatureIsInt());
        fm2.declareEdgeFeatures(this.featureModel.getEdgeFeatures(), this.featureModel.getEdgeFeatureNames(), this.featureModel.getEdgeFeatureShortNames(), this.featureModel.getEdgeFeatureDimensions(), this.featureModel.getEdgeFeatureIsInt());
        fm2.declareTrackFeatures(this.featureModel.getTrackFeatures(), this.featureModel.getTrackFeatureNames(), this.featureModel.getTrackFeatureShortNames(), this.featureModel.getTrackFeatureDimensions(), this.featureModel.getTrackFeatureIsInt());
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUpdate() {
        int nEdgesToSignal = this.trackModel.edgesAdded.size() + this.trackModel.edgesRemoved.size() + this.trackModel.edgesModified.size();
        HashSet<Integer> tracksToUpdate = new HashSet<Integer>(this.trackModel.tracksUpdated);
        for (DefaultWeightedEdge modifiedEdge : this.trackModel.edgesModified) {
            tracksToUpdate.add(this.trackModel.trackIDOf(modifiedEdge));
        }
        int nSpotsToUpdate = this.spotsAdded.size() + this.spotsMoved.size() + this.spotsUpdated.size();
        if (nSpotsToUpdate > 0) {
            HashSet<Spot> spotsToUpdate = new HashSet<Spot>(nSpotsToUpdate);
            spotsToUpdate.addAll(this.spotsAdded);
            spotsToUpdate.addAll(this.spotsMoved);
            spotsToUpdate.addAll(this.spotsUpdated);
        }
        ModelChangeEvent event = new ModelChangeEvent(this, 8);
        int nSpotsToSignal = nSpotsToUpdate + this.spotsRemoved.size();
        if (nSpotsToSignal > 0) {
            event.addAllSpots(this.spotsAdded);
            event.addAllSpots(this.spotsRemoved);
            event.addAllSpots(this.spotsMoved);
            event.addAllSpots(this.spotsUpdated);
            for (Spot spot : this.spotsAdded) {
                event.putSpotFlag(spot, 0);
            }
            for (Spot spot : this.spotsRemoved) {
                event.putSpotFlag(spot, 1);
            }
            for (Spot spot : this.spotsMoved) {
                event.putSpotFlag(spot, 3);
            }
            for (Spot spot : this.spotsUpdated) {
                event.putSpotFlag(spot, 2);
            }
        }
        if (nEdgesToSignal > 0) {
            event.addAllEdges(this.trackModel.edgesAdded);
            event.addAllEdges(this.trackModel.edgesRemoved);
            event.addAllEdges(this.trackModel.edgesModified);
            for (DefaultWeightedEdge edge : this.trackModel.edgesAdded) {
                event.putEdgeFlag(edge, 4);
            }
            for (DefaultWeightedEdge edge : this.trackModel.edgesRemoved) {
                event.putEdgeFlag(edge, 5);
            }
            for (DefaultWeightedEdge edge : this.trackModel.edgesModified) {
                event.putEdgeFlag(edge, 6);
            }
        }
        event.setTracksUpdated(tracksToUpdate);
        try {
            if (nEdgesToSignal + nSpotsToSignal > 0) {
                for (ModelChangeListener listener : this.modelChangeListeners) {
                    listener.modelChanged(event);
                }
            }
            Iterator<Object> iterator = this.eventCache.iterator();
            while (iterator.hasNext()) {
                int eventID = (Integer)iterator.next();
                ModelChangeEvent cachedEvent = new ModelChangeEvent(this, eventID);
                for (ModelChangeListener listener : this.modelChangeListeners) {
                    listener.modelChanged(cachedEvent);
                }
            }
        }
        finally {
            this.spotsAdded.clear();
            this.spotsRemoved.clear();
            this.spotsMoved.clear();
            this.spotsUpdated.clear();
            this.trackModel.edgesAdded.clear();
            this.trackModel.edgesRemoved.clear();
            this.trackModel.edgesModified.clear();
            this.trackModel.tracksUpdated.clear();
            this.eventCache.clear();
        }
    }
}

