/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.TrackMateModule;
import fiji.plugin.trackmate.util.TMUtils;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public interface TrackMateFactoryBase<F extends TrackMateFactoryBase<F>>
extends TrackMateModule {
    default public String marshal(Map<String, Object> settings, Element element) {
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (null == value) {
                return "No value set for parameter " + key;
            }
            element.setAttribute(key, value.toString());
        }
        return null;
    }

    default public String unmarshal(Element element, Map<String, Object> settings) {
        Map<String, Object> defaultSettings = this.getDefaultSettings();
        settings.clear();
        for (Object key : element.getAttributes()) {
            String keyString = ((Attribute)key).getName();
            if ("DETECTOR_NAME".equals(keyString) || "TRACKER_NAME".equals(keyString)) continue;
            if (!defaultSettings.containsKey(keyString)) {
                return "When unmarshaling: Unknown parameter " + keyString + " in factory " + this.getName() + ".\n";
            }
            Attribute att = element.getAttribute(keyString);
            if (null == att) {
                return "When unmarshaling: No value set for parameter " + keyString + " in factory " + this.getName() + ".\n";
            }
            Class<?> klass = defaultSettings.get(keyString).getClass();
            try {
                Object value;
                if (klass == String.class) {
                    value = att.getValue();
                } else if (klass == Integer.class) {
                    value = att.getIntValue();
                } else if (klass == Double.class) {
                    value = att.getDoubleValue();
                } else if (klass == Float.class) {
                    value = Float.valueOf(att.getFloatValue());
                } else if (klass == Long.class) {
                    value = att.getLongValue();
                } else if (klass == Boolean.class) {
                    value = att.getBooleanValue();
                } else {
                    return "When unmarshalling: Unsupported type " + klass.getSimpleName() + " for parameter " + keyString + " in factory " + this.getName();
                }
                settings.put(keyString, value);
            }
            catch (DataConversionException e) {
                return "When unmarshalling: Cannot parse value '" + att.getValue() + "' for parameter " + keyString + " in factory " + this.getName() + ".";
            }
        }
        return null;
    }

    public Map<String, Object> getDefaultSettings();

    default public String checkSettings(Map<String, Object> settings) {
        return TMUtils.checkSettings(settings, this.getDefaultSettings());
    }

    default public String toString(Map<String, Object> sm) {
        String error = this.checkSettings(sm);
        if (null != error) {
            return error;
        }
        return TMUtils.echoMap(sm, 0);
    }

    default public F copy() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            TrackMateFactoryBase copy = (TrackMateFactoryBase)constructor.newInstance(new Object[0]);
            return (F)copy;
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not copy the factory: " + e.getMessage(), e);
        }
    }
}

