/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import org.scijava.Cancelable;

public class TrackFeatureCalculator
extends MultiThreadedBenchmarkAlgorithm
implements Cancelable {
    private static final String BASE_ERROR_MSG = "[TrackFeatureCalculator] ";
    private final Settings settings;
    private final Model model;
    private boolean isCanceled;
    private String cancelReason;
    private final boolean doLogIt;

    public TrackFeatureCalculator(Model model, Settings settings, boolean doLogIt) {
        this.settings = settings;
        this.model = model;
        this.doLogIt = doLogIt;
    }

    public boolean checkInput() {
        if (null == this.model) {
            this.errorMessage = "[TrackFeatureCalculator] Model object is null.";
            return false;
        }
        if (null == this.settings) {
            this.errorMessage = "[TrackFeatureCalculator] Settings object is null.";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        for (TrackAnalyzer analyzer : this.settings.getTrackAnalyzers()) {
            List features = analyzer.getFeatures();
            Map featureNames = analyzer.getFeatureNames();
            Map featureShortNames = analyzer.getFeatureShortNames();
            Map featureDimensions = analyzer.getFeatureDimensions();
            Map isIntFeature = analyzer.getIsIntFeature();
            this.model.getFeatureModel().declareTrackFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
        }
        this.computeTrackFeaturesAgent(this.model.getTrackModel().trackIDs(false), this.settings.getTrackAnalyzers(), this.doLogIt);
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public void computeTrackFeatures(Collection<Integer> trackIDs, boolean doLogIt) {
        List<TrackAnalyzer> trackFeatureAnalyzers = this.settings.getTrackAnalyzers();
        this.computeTrackFeaturesAgent(trackIDs, trackFeatureAnalyzers, doLogIt);
    }

    private void computeTrackFeaturesAgent(Collection<Integer> trackIDs, List<TrackAnalyzer> analyzers, boolean doLogIt) {
        this.isCanceled = false;
        this.cancelReason = null;
        Logger logger = this.model.getLogger();
        if (doLogIt) {
            logger.log("Computing track features:\n", Logger.BLUE_COLOR);
        }
        for (TrackAnalyzer analyzer : analyzers) {
            if (this.isCanceled()) {
                return;
            }
            if (analyzer.isManualFeature()) continue;
            analyzer.setNumThreads(this.numThreads);
            if (analyzer.isLocal()) {
                analyzer.process(trackIDs, this.model);
            } else {
                analyzer.process(this.model.getTrackModel().trackIDs(false), this.model);
            }
            if (!doLogIt) continue;
            logger.log("  - " + analyzer.getName() + " in " + analyzer.getProcessingTime() + " ms.\n");
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

