/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.graph;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.graph.SortedDepthFirstIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TimeDirectedSortedDepthFirstIterator
extends SortedDepthFirstIterator<Spot, DefaultWeightedEdge> {
    public TimeDirectedSortedDepthFirstIterator(Graph<Spot, DefaultWeightedEdge> g, Spot startVertex, Comparator<Spot> comparator) {
        super(g, startVertex, comparator);
    }

    @Override
    protected void addUnseenChildrenOf(Spot vertex) {
        ArrayList<Spot> sortedChildren = new ArrayList<Spot>();
        HashMap<Spot, DefaultWeightedEdge> localEdges = new HashMap<Spot, DefaultWeightedEdge>();
        int ts = vertex.getFeature("FRAME").intValue();
        for (DefaultWeightedEdge edge : this.specifics.edgesOf(vertex)) {
            Spot oppositeV = (Spot)Graphs.getOppositeVertex((Graph)this.graph, (Object)edge, (Object)vertex);
            int tt = oppositeV.getFeature("FRAME").intValue();
            if (tt <= ts) continue;
            if (!this.seen.containsKey(oppositeV)) {
                sortedChildren.add(oppositeV);
            }
            localEdges.put(oppositeV, edge);
        }
        Collections.sort(sortedChildren, Collections.reverseOrder(this.comparator));
        for (Spot child : sortedChildren) {
            if (this.nListeners != 0) {
                this.fireEdgeTraversed(this.createEdgeTraversalEvent((DefaultWeightedEdge)localEdges.get(child)));
            }
            if (this.seen.containsKey(child)) {
                this.encounterVertexAgain(child, (DefaultWeightedEdge)localEdges.get(child));
                continue;
            }
            this.encounterVertex(child, (DefaultWeightedEdge)localEdges.get(child));
        }
    }
}

