/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.table;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.ModelChangeListener;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionChangeListener;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.FileChooser;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.TrackMateModelView;
import fiji.plugin.trackmate.visualization.table.TablePanel;
import fiji.plugin.trackmate.visualization.trackscheme.utils.SearchBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AllSpotsTableView
extends JFrame
implements TrackMateModelView,
ModelChangeListener,
SelectionChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "SPOT_TABLE";
    private String selectedFile;
    private final Model model;
    private final TablePanel<Spot> spotTable;
    private final AtomicBoolean ignoreSelectionChange = new AtomicBoolean(false);
    private final SelectionModel selectionModel;

    public AllSpotsTableView(final Model model, final SelectionModel selectionModel, final DisplaySettings ds, String imageFileName) {
        super("All spots table");
        this.setIconImage(Icons.TRACKMATE_ICON.getImage());
        this.model = model;
        this.selectionModel = selectionModel;
        this.selectedFile = imageFileName + "_allspots.csv";
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.spotTable = AllSpotsTableView.createSpotTable(model, ds);
        mainPanel.add((Component)this.spotTable.getPanel(), "Center");
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 2);
        toolbar.setLayout(layout);
        JButton exportBtn = new JButton("Export to CSV", Icons.CSV_ICON);
        exportBtn.addActionListener(e -> this.exportToCsv());
        toolbar.add(exportBtn);
        toolbar.add(Box.createHorizontalGlue());
        SearchBar searchBar = new SearchBar(model, this);
        searchBar.setMaximumSize(new java.awt.Dimension(160, 30));
        toolbar.add(searchBar);
        JToggleButton tglColoring = new JToggleButton("coloring");
        tglColoring.addActionListener(e -> {
            this.spotTable.setUseColoring(tglColoring.isSelected());
            this.refresh();
        });
        toolbar.add(tglColoring);
        mainPanel.add((Component)toolbar, "North");
        this.getContentPane().add(mainPanel);
        this.pack();
        this.spotTable.getTable().getSelectionModel().addListSelectionListener(new SpotTableSelectionListener());
        final DisplaySettings.UpdateListener refresher = () -> this.refresh();
        ds.listeners().add((Object)refresher);
        selectionModel.addSelectionChangeListener(this);
        model.addModelChangeListener(this);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ AllSpotsTableView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                selectionModel.removeSelectionChangeListener(this.this$0);
                model.removeModelChangeListener(this.this$0);
                ds.listeners().remove((Object)refresher);
            }
        });
    }

    public void exportToCsv() {
        File file = FileChooser.chooseFile(this, this.selectedFile, new FileNameExtensionFilter("CSV files", "csv"), "Export table to CSV", FileChooser.DialogType.SAVE, FileChooser.SelectionMode.FILES_ONLY);
        if (null == file) {
            return;
        }
        this.selectedFile = file.getAbsolutePath();
        this.exportToCsv(this.selectedFile);
    }

    public void exportToCsv(String csvFile) {
        try {
            this.spotTable.exportToCsv(new File(csvFile));
        }
        catch (IOException e) {
            this.model.getLogger().error("Problem exporting to file " + csvFile + "\n" + e.getMessage());
        }
    }

    public static final TablePanel<Spot> createSpotTable(Model model, DisplaySettings ds) {
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getSpotFeatures());
        Map<String, String> featureNames = model.getFeatureModel().getSpotFeatureNames();
        Map<String, String> featureShortNames = model.getFeatureModel().getSpotFeatureShortNames();
        HashMap<String, String> featureUnits = new HashMap<String, String>();
        for (String feature2 : features) {
            Dimension dimension = model.getFeatureModel().getSpotFeatureDimensions().get(feature2);
            String units = TMUtils.getUnitsFor(dimension, model.getSpaceUnits(), model.getTimeUnits());
            featureUnits.put(feature2, units);
        }
        Map<String, Boolean> isInts = model.getFeatureModel().getSpotFeatureIsInt();
        HashMap<String, String> infoTexts = new HashMap<String, String>();
        Function<Spot, String> labelGenerator = spot -> spot.getName();
        BiConsumer<Spot, String> labelSetter = (spot, label) -> spot.setName((String)label);
        String SPOT_ID = "ID";
        features.add(0, "ID");
        featureNames.put("ID", "Spot ID");
        featureShortNames.put("ID", "Spot ID");
        featureUnits.put("ID", "");
        isInts.put("ID", Boolean.TRUE);
        infoTexts.put("ID", "The id of the spot.");
        String TRACK_ID = "TRACK_ID";
        features.add(1, "TRACK_ID");
        featureNames.put("TRACK_ID", "Track ID");
        featureShortNames.put("TRACK_ID", "Track ID");
        featureUnits.put("TRACK_ID", "");
        isInts.put("TRACK_ID", Boolean.TRUE);
        infoTexts.put("TRACK_ID", "The id of the track this spot belongs to.");
        BiFunction<Spot, String, Double> featureFun = (spot, feature) -> {
            if (feature.equals("TRACK_ID")) {
                Integer trackID = model.getTrackModel().trackIDOf((Spot)spot);
                return trackID == null ? null : Double.valueOf(trackID.doubleValue());
            }
            if (feature.equals("ID")) {
                return spot.ID();
            }
            return spot.getFeature((String)feature);
        };
        Supplier coloring = () -> FeatureUtils.createSpotColorGenerator(model, ds);
        BiConsumer<Spot, Color> colorSetter = (spot, color) -> spot.putFeature("MANUAL_SPOT_COLOR", Double.valueOf(color.getRGB()));
        TablePanel<Spot> table = new TablePanel<Spot>(model.getSpots().iterable(true), features, featureFun, featureNames, featureShortNames, featureUnits, isInts, infoTexts, coloring, labelGenerator, labelSetter, "MANUAL_SPOT_COLOR", colorSetter);
        return table;
    }

    @Override
    public void render() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public void modelChanged(ModelChangeEvent event) {
        if (event.getEventID() == 9) {
            this.refresh();
            return;
        }
        ArrayList<Spot> spots = new ArrayList<Spot>();
        for (Spot spot : this.model.getSpots().iterable(true)) {
            spots.add(spot);
        }
        this.spotTable.setObjects(spots);
        this.refresh();
    }

    @Override
    public void selectionChanged(SelectionChangeEvent event) {
        boolean added;
        if (this.ignoreSelectionChange.get()) {
            return;
        }
        this.ignoreSelectionChange.set(true);
        Set<Spot> selectedVertices = this.selectionModel.getSpotSelection();
        JTable vt = this.spotTable.getTable();
        vt.getSelectionModel().clearSelection();
        for (Spot spot : selectedVertices) {
            int row = this.spotTable.getViewRowForObject(spot);
            vt.getSelectionModel().addSelectionInterval(row, row);
        }
        Map<Spot, Boolean> spotsAdded = event.getSpots();
        if (spotsAdded != null && spotsAdded.size() == 1 && (added = spotsAdded.values().iterator().next().booleanValue())) {
            Spot spot = spotsAdded.keySet().iterator().next();
            this.centerViewOn(spot);
        }
        this.refresh();
        this.ignoreSelectionChange.set(false);
    }

    @Override
    public void centerViewOn(Spot spot) {
        this.spotTable.scrollToObject(spot);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void clear() {
    }

    private final class SpotTableSelectionListener
    implements ListSelectionListener {
        private SpotTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting() || AllSpotsTableView.this.ignoreSelectionChange.get()) {
                return;
            }
            AllSpotsTableView.this.ignoreSelectionChange.set(true);
            int[] selectedRows = AllSpotsTableView.this.spotTable.getTable().getSelectedRows();
            ArrayList<Spot> toSelect = new ArrayList<Spot>(selectedRows.length);
            for (int row : selectedRows) {
                toSelect.add(AllSpotsTableView.this.spotTable.getObjectForViewRow(row));
            }
            AllSpotsTableView.this.selectionModel.clearSelection();
            AllSpotsTableView.this.selectionModel.addSpotToSelection(toSelect);
            AllSpotsTableView.this.refresh();
            AllSpotsTableView.this.ignoreSelectionChange.set(false);
        }
    }
}

