/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxStyleUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphSelectionModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.AbstractTrackMateModelView;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import fiji.plugin.trackmate.visualization.trackscheme.SpotImageUpdater;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeFrame;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphLayout;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeStylist;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TrackScheme
extends AbstractTrackMateModelView {
    public static final String INFO_TEXT = "<html>TrackScheme displays the tracking results as track lanes, <br>ignoring the spot actual position. <p>Tracks can be edited through link creation and removal.</html>";
    static final int Y_COLUMN_SIZE = 96;
    static final int X_COLUMN_SIZE = 160;
    static final int DEFAULT_CELL_WIDTH = 128;
    static final int DEFAULT_CELL_HEIGHT = 40;
    public static final String DEFAULT_COLOR = "#FF00FF";
    private static final Dimension DEFAULT_SIZE = new Dimension(800, 600);
    static final int TABLE_CELL_WIDTH = 40;
    static final Color GRID_COLOR = Color.GRAY;
    static final boolean DEFAULT_DO_DISPLAY_COSTS_ON_EDGES = false;
    static final int DEFAULT_PAINT_DECORATION_LEVEL = 1;
    static final boolean DEFAULT_LINKING_ENABLED = false;
    static final boolean DEFAULT_THUMBNAILS_ENABLED = false;
    public static final String KEY = "TRACKSCHEME";
    private final TrackSchemeFrame gui;
    private JGraphXAdapter graph;
    private TrackSchemeGraphLayout graphLayout;
    private boolean doFireSelectionChangeEvent = true;
    private boolean doFireModelChangeEvent = true;
    private Map<Integer, Integer> rowLengths = new HashMap<Integer, Integer>();
    private int unlaidSpotColumn = 2;
    private SpotImageUpdater spotImageUpdater;
    TrackSchemeStylist stylist;
    private boolean doThumbnailCapture = false;

    public TrackScheme(final Model model, SelectionModel selectionModel, DisplaySettings displaySettings) {
        super(model, selectionModel, displaySettings);
        this.gui = new TrackSchemeFrame(this, displaySettings);
        String title = "TrackScheme";
        this.gui.setTitle("TrackScheme");
        this.gui.setSize(DEFAULT_SIZE);
        displaySettings.listeners().add(() -> this.doTrackStyle());
        this.gui.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ TrackScheme this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                model.removeModelChangeListener(this.this$0);
            }
        });
        this.gui.setLocationByPlatform(true);
        this.gui.setLocationRelativeTo(null);
        this.gui.setVisible(true);
    }

    public void setSpotImageUpdater(SpotImageUpdater spotImageUpdater) {
        this.spotImageUpdater = spotImageUpdater;
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getUnlaidSpotColumn() {
        return this.unlaidSpotColumn;
    }

    public int getNextFreeColumn(int frame) {
        Integer columnIndex = this.rowLengths.get(frame);
        if (null == columnIndex) {
            columnIndex = 2;
        }
        return columnIndex + 1;
    }

    public TrackSchemeFrame getGUI() {
        return this.gui;
    }

    public JGraphXAdapter getGraph() {
        return this.graph;
    }

    public TrackSchemeGraphLayout getGraphLayout() {
        return this.graphLayout;
    }

    private JGraphXAdapter createGraph() {
        this.gui.logger.setStatus("Creating graph adapter.");
        JGraphXAdapter lGraph = new JGraphXAdapter(this.model);
        lGraph.setAllowLoops(false);
        lGraph.setAllowDanglingEdges(false);
        lGraph.setCellsCloneable(false);
        lGraph.setCellsSelectable(true);
        lGraph.setCellsDisconnectable(false);
        lGraph.setCellsMovable(true);
        lGraph.setGridEnabled(false);
        lGraph.setLabelsVisible(true);
        lGraph.setDropEnabled(false);
        lGraph.addListener("cellsRemoved", new CellRemovalListener());
        lGraph.getSelectionModel().addListener("change", (mxEventSource.mxIEventListener)new SelectionChangeListener());
        return lGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private mxICell updateCellOf(Spot spot) {
        mxCell cell = this.graph.getCellFor(spot);
        this.graph.getModel().beginUpdate();
        try {
            if (null == cell) {
                int row = this.getUnlaidSpotColumn();
                cell = this.insertSpotInGraph(spot, row);
                int frame = spot.getFeature("FRAME").intValue();
                this.rowLengths.put(frame, row + 1);
            }
            if (this.spotImageUpdater != null && this.doThumbnailCapture) {
                String style = cell.getStyle();
                double radiusFactor = this.displaySettings.getSpotDisplayRadius();
                String imageStr = this.spotImageUpdater.getImageString(spot, radiusFactor);
                style = mxStyleUtils.setStyle((String)style, (String)mxConstants.STYLE_IMAGE, (String)("data:image/base64," + imageStr));
                this.graph.getModel().setStyle((Object)cell, style);
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        return cell;
    }

    private mxICell insertSpotInGraph(Spot spot, int targetColumn) {
        mxCell cellAdded = this.graph.getCellFor(spot);
        if (cellAdded != null) {
            return cellAdded;
        }
        cellAdded = this.graph.addJGraphTVertex(spot);
        int row = spot.getFeature("FRAME").intValue();
        double x = (targetColumn - 1) * 160 - 64;
        double y = (0.5 + (double)row) * 96.0 - 20.0;
        mxGeometry geometry = new mxGeometry(x, y, 128.0, 40.0);
        cellAdded.setGeometry(geometry);
        double radiusFactor = this.displaySettings.getSpotDisplayRadius();
        if (null != this.spotImageUpdater && this.doThumbnailCapture) {
            String imageStr = this.spotImageUpdater.getImageString(spot, radiusFactor);
            this.graph.getModel().setStyle((Object)cellAdded, mxConstants.STYLE_IMAGE + "=data:image/base64," + imageStr);
        }
        return cellAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importTrack(int trackIndex) {
        this.model.beginUpdate();
        this.graph.getModel().beginUpdate();
        try {
            this.model.setTrackVisibility(trackIndex, true);
            int targetColumn = this.getUnlaidSpotColumn();
            Set<Spot> trackSpots = this.model.getTrackModel().trackSpots(trackIndex);
            for (Spot trackSpot : trackSpots) {
                int frame = trackSpot.getFeature("FRAME").intValue();
                int column = Math.max(targetColumn, this.getNextFreeColumn(frame));
                this.insertSpotInGraph(trackSpot, column);
                this.rowLengths.put(frame, column);
            }
            Set<DefaultWeightedEdge> trackEdges = this.model.getTrackModel().trackEdges(trackIndex);
            for (DefaultWeightedEdge trackEdge : trackEdges) {
                this.graph.addJGraphTEdge(trackEdge);
            }
        }
        finally {
            this.model.endUpdate();
            this.graph.getModel().endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEdgeManually(mxCell cell) {
        if (cell.isEdge()) {
            mxIGraphModel graphModel = this.graph.getModel();
            cell.setValue((Object)"New");
            this.model.beginUpdate();
            graphModel.beginUpdate();
            try {
                Spot source = this.graph.getSpotFor(cell.getSource());
                Spot target = this.graph.getSpotFor(cell.getTarget());
                if (Spot.frameComparator.compare(source, target) == 0) {
                    this.graph.removeCells(new Object[]{cell});
                } else {
                    DefaultWeightedEdge edge;
                    if (Spot.frameComparator.compare(source, target) > 0) {
                        Spot tmp = source;
                        source = target;
                        target = tmp;
                    }
                    if (null == (edge = this.model.getTrackModel().getEdge(source, target))) {
                        edge = this.model.addEdge(source, target, -1.0);
                    } else {
                        this.graph.removeCells(new Object[]{cell});
                        cell = this.graph.addJGraphTEdge(edge);
                        cell.setValue((Object)String.format("%.1f", this.model.getTrackModel().getEdgeWeight(edge)));
                        int ID = this.model.getTrackModel().trackIDOf(edge);
                        if (!this.model.getTrackModel().isVisible(ID)) {
                            this.importTrack(ID);
                        }
                    }
                    this.graph.mapEdgeToCell(edge, cell);
                }
            }
            finally {
                graphModel.endUpdate();
                this.model.endUpdate();
                this.selectionModel.clearEdgeSelection();
            }
        }
    }

    @Override
    public void selectionChanged(SelectionChangeEvent event) {
        boolean added;
        if (!this.doFireSelectionChangeEvent) {
            return;
        }
        this.doFireSelectionChangeEvent = false;
        ArrayList<mxCell> newSelection = new ArrayList<mxCell>(this.selectionModel.getSpotSelection().size() + this.selectionModel.getEdgeSelection().size());
        Iterator<DefaultWeightedEdge> edgeIt = this.selectionModel.getEdgeSelection().iterator();
        while (edgeIt.hasNext()) {
            mxCell cell = this.graph.getCellFor(edgeIt.next());
            if (null == cell) continue;
            newSelection.add(cell);
        }
        Iterator<Spot> spotIt = this.selectionModel.getSpotSelection().iterator();
        while (spotIt.hasNext()) {
            mxCell cell = this.graph.getCellFor(spotIt.next());
            if (null == cell) continue;
            newSelection.add(cell);
        }
        mxGraphSelectionModel mGSmodel = this.graph.getSelectionModel();
        mGSmodel.setCells(newSelection.toArray());
        Map<Spot, Boolean> spotsAdded = event.getSpots();
        if (spotsAdded != null && spotsAdded.size() == 1 && (added = spotsAdded.values().iterator().next().booleanValue())) {
            Spot spot = spotsAdded.keySet().iterator().next();
            this.centerViewOn(spot);
        }
        this.doFireSelectionChangeEvent = true;
    }

    @Override
    public void centerViewOn(Spot spot) {
        this.gui.centerViewOn((mxICell)this.graph.getCellFor(spot));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelChanged(ModelChangeEvent event) {
        if (event.getEventID() != 8) {
            return;
        }
        this.graph.getModel().beginUpdate();
        try {
            ArrayList<mxCell> cellsToRemove = new ArrayList<mxCell>();
            int targetColumn = this.getUnlaidSpotColumn();
            if (!event.getSpots().isEmpty()) {
                HashSet<mxCell> spotsWithStyleToUpdate = new HashSet<mxCell>();
                for (Spot spot : event.getSpots()) {
                    if (event.getSpotFlag(spot) == 0) {
                        int frame = spot.getFeature("FRAME").intValue();
                        int column = Math.max(targetColumn, this.getNextFreeColumn(frame));
                        mxICell newCell = this.insertSpotInGraph(spot, column);
                        this.rowLengths.put(frame, column);
                        spotsWithStyleToUpdate.add((mxCell)newCell);
                        continue;
                    }
                    if (event.getSpotFlag(spot) == 2) {
                        mxICell cell = this.updateCellOf(spot);
                        spotsWithStyleToUpdate.add((mxCell)cell);
                        continue;
                    }
                    if (event.getSpotFlag(spot) != 1) continue;
                    mxCell cell = this.graph.getCellFor(spot);
                    cellsToRemove.add(cell);
                }
                this.graph.removeCells(cellsToRemove.toArray(), true);
                this.stylist.updateVertexStyle(spotsWithStyleToUpdate);
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        if (!event.getEdges().isEmpty()) {
            this.graph.getModel().beginUpdate();
            try {
                if (event.getEdges().size() > 0) {
                    ArrayList<mxCell> edgesToUpdate = new ArrayList<mxCell>();
                    ArrayList<mxCell> spotsWithStyleToUpdate = new ArrayList<mxCell>();
                    for (DefaultWeightedEdge edge : event.getEdges()) {
                        if (event.getEdgeFlag(edge) == 4) {
                            mxCell edgeCell = this.graph.getCellFor(edge);
                            if (null == edgeCell) {
                                Spot source = this.model.getTrackModel().getEdgeSource(edge);
                                mxCell sourceCell = this.graph.getCellFor(source);
                                Spot target = this.model.getTrackModel().getEdgeTarget(edge);
                                mxCell targetCell = this.graph.getCellFor(target);
                                if (sourceCell == null || targetCell == null) {
                                    Integer trackID = this.model.getTrackModel().trackIDOf(edge);
                                    Set<Spot> trackSpots = this.model.getTrackModel().trackSpots(trackID);
                                    for (Spot trackSpot : trackSpots) {
                                        mxCell spotCell = this.graph.getCellFor(trackSpot);
                                        if (spotCell != null) continue;
                                        int frame = trackSpot.getFeature("FRAME").intValue();
                                        int targetColumn = this.getUnlaidSpotColumn();
                                        int column = Math.max(targetColumn, this.getNextFreeColumn(frame));
                                        mxCell spotCellAdded = (mxCell)this.insertSpotInGraph(trackSpot, column);
                                        this.rowLengths.put(frame, column);
                                        spotsWithStyleToUpdate.add(spotCellAdded);
                                    }
                                    Set<DefaultWeightedEdge> trackEdges = this.model.getTrackModel().trackEdges(trackID);
                                    for (DefaultWeightedEdge trackEdge : trackEdges) {
                                        mxCell edgeCellToAdd = this.graph.getCellFor(trackEdge);
                                        if (null != edgeCellToAdd) continue;
                                        edgeCellToAdd = this.graph.addJGraphTEdge(trackEdge);
                                        this.graph.getModel().add(this.graph.getDefaultParent(), (Object)edgeCellToAdd, 0);
                                        edgesToUpdate.add(edgeCellToAdd);
                                    }
                                }
                                edgeCell = this.graph.addJGraphTEdge(edge);
                            }
                            this.graph.getModel().add(this.graph.getDefaultParent(), (Object)edgeCell, 0);
                            edgesToUpdate.add(edgeCell);
                            continue;
                        }
                        if (event.getEdgeFlag(edge) == 6) {
                            edgesToUpdate.add(this.graph.getCellFor(edge));
                            continue;
                        }
                        if (event.getEdgeFlag(edge) != 5) continue;
                        mxCell cell = this.graph.getCellFor(edge);
                        this.graph.removeCells(new Object[]{cell});
                    }
                    this.stylist.updateEdgeStyle(edgesToUpdate);
                    this.stylist.updateVertexStyle(spotsWithStyleToUpdate);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TrackScheme.this.gui.graphComponent.refresh();
                            TrackScheme.this.gui.graphComponent.repaint();
                        }
                    });
                }
            }
            finally {
                this.graph.getModel().endUpdate();
            }
        }
    }

    @Override
    public void render() {
        final long start = System.currentTimeMillis();
        this.graph = this.createGraph();
        this.gui.logger.setProgress(0.5);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TrackScheme this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.gui.logger.setStatus("Generating GUI components.");
                this.this$0.gui.init(this.this$0.graph);
                this.this$0.gui.logger.setStatus("Creating style manager.");
                this.this$0.stylist = new TrackSchemeStylist(this.this$0.model, this.this$0.graph, this.this$0.displaySettings);
                this.this$0.gui.logger.setStatus("Creating layout manager.");
                this.this$0.graphLayout = new TrackSchemeGraphLayout(this.this$0.graph, this.this$0.model, this.this$0.gui.graphComponent);
                this.this$0.gui.logger.setProgress(0.75);
                this.this$0.doTrackStyle();
                this.this$0.gui.logger.setStatus("Executing layout.");
                this.this$0.doTrackLayout();
                this.this$0.gui.logger.setProgress(0.9);
                this.this$0.gui.logger.setStatus("Refreshing display.");
                this.this$0.gui.graphComponent.refresh();
                mxCellState bounds = this.this$0.graph.getView().validateCellState(this.this$0.graph.getDefaultParent(), false);
                if (null == bounds) {
                    return;
                }
                Dimension dim = new Dimension();
                dim.setSize(bounds.getRectangle().width + bounds.getRectangle().x, bounds.getRectangle().height + bounds.getRectangle().y);
                this.this$0.gui.graphComponent.getGraphControl().setPreferredSize(dim);
                this.this$0.gui.logger.setStatus("");
                this.this$0.gui.graphComponent.zoomOut();
                this.this$0.gui.graphComponent.zoomOut();
                this.this$0.gui.logger.setProgress(0.0);
                long end = System.currentTimeMillis();
                this.this$0.gui.logger.log(String.format("TrackScheme rendering done in %.1f s.", (double)(end - start) / 1000.0));
                this.this$0.gui.revalidate();
            }
        });
    }

    @Override
    public void refresh() {
    }

    @Override
    public void clear() {
        System.out.println("[TrackScheme] clear() called");
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    private void userChangedSelection(Collection<Object> added, Collection<Object> removed) {
        DefaultWeightedEdge edge;
        Spot spot;
        mxICell child;
        mxCell cell;
        if (!this.doFireSelectionChangeEvent) {
            return;
        }
        ArrayList<Spot> spotsToAdd = new ArrayList<Spot>();
        ArrayList<Spot> spotsToRemove = new ArrayList<Spot>();
        ArrayList<DefaultWeightedEdge> edgesToAdd = new ArrayList<DefaultWeightedEdge>();
        ArrayList<DefaultWeightedEdge> edgesToRemove = new ArrayList<DefaultWeightedEdge>();
        if (null != added) {
            for (Object obj : added) {
                cell = (mxCell)obj;
                if (cell.getChildCount() > 0) {
                    for (int i = 0; i < cell.getChildCount(); ++i) {
                        child = cell.getChildAt(i);
                        if (child.isVertex()) {
                            spot = this.graph.getSpotFor(child);
                            spotsToRemove.add(spot);
                            continue;
                        }
                        edge = this.graph.getEdgeFor(child);
                        edgesToRemove.add(edge);
                    }
                    continue;
                }
                if (cell.isVertex()) {
                    Spot spot2 = this.graph.getSpotFor((mxICell)cell);
                    spotsToRemove.add(spot2);
                    continue;
                }
                DefaultWeightedEdge edge2 = this.graph.getEdgeFor((mxICell)cell);
                edgesToRemove.add(edge2);
            }
        }
        if (null != removed) {
            for (Object obj : removed) {
                cell = (mxCell)obj;
                if (cell.getChildCount() > 0) {
                    for (int i = 0; i < cell.getChildCount(); ++i) {
                        child = cell.getChildAt(i);
                        if (child.isVertex()) {
                            spot = this.graph.getSpotFor(child);
                            spotsToAdd.add(spot);
                            continue;
                        }
                        edge = this.graph.getEdgeFor(child);
                        edgesToAdd.add(edge);
                    }
                    continue;
                }
                if (cell.isVertex()) {
                    Spot spot3 = this.graph.getSpotFor((mxICell)cell);
                    spotsToAdd.add(spot3);
                    continue;
                }
                DefaultWeightedEdge edge3 = this.graph.getEdgeFor((mxICell)cell);
                edgesToAdd.add(edge3);
            }
        }
        this.doFireSelectionChangeEvent = false;
        if (!edgesToAdd.isEmpty()) {
            this.selectionModel.addEdgeToSelection(edgesToAdd);
        }
        if (!spotsToAdd.isEmpty()) {
            this.selectionModel.addSpotToSelection(spotsToAdd);
        }
        if (!edgesToRemove.isEmpty()) {
            this.selectionModel.removeEdgeFromSelection(edgesToRemove);
        }
        if (!spotsToRemove.isEmpty()) {
            this.selectionModel.removeSpotFromSelection(spotsToRemove);
        }
        this.doFireSelectionChangeEvent = true;
    }

    public boolean toggleLinking() {
        boolean enabled = this.gui.graphComponent.getConnectionHandler().isEnabled();
        this.gui.graphComponent.getConnectionHandler().setEnabled(!enabled);
        return !enabled;
    }

    public boolean toggleThumbnail() {
        if (!this.doThumbnailCapture) {
            this.createThumbnails();
        }
        this.doThumbnailCapture = !this.doThumbnailCapture;
        return this.doThumbnailCapture;
    }

    public void zoomIn() {
        this.gui.graphComponent.zoomIn();
    }

    public void zoomOut() {
        this.gui.graphComponent.zoomOut();
    }

    public void resetZoom() {
        this.gui.graphComponent.zoomActual();
    }

    public void doTrackStyle() {
        if (null == this.stylist) {
            return;
        }
        this.gui.logger.setStatus("Setting style.");
        this.graph.getModel().beginUpdate();
        try {
            this.stylist.updateEdgeStyle(this.graph.getEdgeCells());
            this.stylist.updateVertexStyle(this.graph.getVertexCells());
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createThumbnails() {
        NavigableSet<Integer> frames = this.model.getSpots().keySet();
        HashMap spotPerFrame = new HashMap(frames.size());
        for (Integer frame : frames) {
            spotPerFrame.put(frame, new HashSet(this.model.getSpots().getNSpots(frame, true)));
        }
        for (Integer trackID : this.model.getTrackModel().trackIDs(true)) {
            for (Spot spot : this.model.getTrackModel().trackSpots(trackID)) {
                int frame = spot.getFeature("FRAME").intValue();
                ((HashSet)spotPerFrame.get(frame)).add(spot);
            }
        }
        if (null != this.spotImageUpdater) {
            this.gui.logger.setStatus("Collecting spot thumbnails.");
            double radiusFactor = this.displaySettings.getSpotDisplayRadius();
            int index = 0;
            try {
                this.graph.getModel().beginUpdate();
                for (Integer frame : frames) {
                    for (Spot spot : (HashSet)spotPerFrame.get(frame)) {
                        mxCell cell = this.graph.getCellFor(spot);
                        String imageStr = this.spotImageUpdater.getImageString(spot, radiusFactor);
                        String style = cell.getStyle();
                        style = mxStyleUtils.setStyle((String)style, (String)mxConstants.STYLE_IMAGE, (String)("data:image/base64," + imageStr));
                        this.graph.getModel().setStyle((Object)cell, style);
                    }
                    this.gui.logger.setProgress((double)index++ / (double)frames.size());
                }
            }
            finally {
                this.graph.getModel().endUpdate();
                this.gui.logger.setProgress(0.0);
                this.gui.logger.setStatus("");
            }
        }
    }

    public void doTrackLayout() {
        this.graphLayout.execute(null);
        this.rowLengths = this.graphLayout.getRowLengths();
        int maxLength = 2;
        for (int rowLength : this.rowLengths.values()) {
            if (maxLength >= rowLength) continue;
            maxLength = rowLength;
        }
        this.unlaidSpotColumn = maxLength;
        this.gui.graphComponent.refresh();
        this.gui.graphComponent.repaint();
    }

    public void captureUndecorated() {
        BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)this.graph, null, (double)1.0, (Color)Color.WHITE, (boolean)true, null, (mxGraphics2DCanvas)this.gui.graphComponent.getCanvas());
        ImagePlus imp = new ImagePlus("TrackScheme capture", (Image)image);
        imp.show();
    }

    public void captureDecorated() {
        JViewport view = this.gui.graphComponent.getViewport();
        Point currentPos = view.getViewPosition();
        view.setViewPosition(new Point(0, 0));
        Dimension size = view.getViewSize();
        BufferedImage image = (BufferedImage)view.createImage(size.width, size.height);
        Graphics2D captureG = image.createGraphics();
        view.paintComponents(captureG);
        view.setViewPosition(currentPos);
        ImagePlus imp = new ImagePlus("TrackScheme capture", (Image)image);
        imp.show();
    }

    public void toggleDisplayDecoration() {
        this.gui.graphComponent.loopPaintDecorationLevel();
        this.gui.graphComponent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkSpots() {
        TreeMap<Integer, Spot> spotsInTime = new TreeMap<Integer, Spot>();
        for (Spot spot : this.selectionModel.getSpotSelection()) {
            spotsInTime.put(spot.getFeature("FRAME").intValue(), spot);
        }
        int targetColumn = this.getUnlaidSpotColumn();
        this.model.beginUpdate();
        this.graph.getModel().beginUpdate();
        try {
            Iterator it = spotsInTime.keySet().iterator();
            Integer previousTime = (Integer)it.next();
            Spot previousSpot = (Spot)spotsInTime.get(previousTime);
            Integer ID = this.model.getTrackModel().trackIDOf(previousSpot);
            if (ID != null && !this.model.getTrackModel().isVisible(ID)) {
                this.importTrack(ID);
            }
            while (it.hasNext()) {
                DefaultWeightedEdge edge;
                mxCell previousCell;
                mxCell currentCell;
                Integer currentTime = (Integer)it.next();
                Spot currentSpot = (Spot)spotsInTime.get(currentTime);
                ID = this.model.getTrackModel().trackIDOf(currentSpot);
                if (ID != null && !this.model.getTrackModel().isVisible(ID)) {
                    this.importTrack(ID);
                }
                if (null == (currentCell = this.graph.getCellFor(currentSpot))) {
                    currentCell = this.insertSpotInGraph(currentSpot, targetColumn);
                }
                if (null == (previousCell = this.graph.getCellFor(previousSpot))) {
                    int frame = previousSpot.getFeature("FRAME").intValue();
                    int column = Math.max(targetColumn, this.getNextFreeColumn(frame));
                    this.rowLengths.put(frame, column);
                    previousCell = this.insertSpotInGraph(previousSpot, column);
                }
                if (null == (edge = this.model.getTrackModel().getEdge(previousSpot, currentSpot))) {
                    edge = this.model.addEdge(previousSpot, currentSpot, -1.0);
                    cell = this.graph.addJGraphTEdge(edge);
                    cell.setValue((Object)"New");
                } else {
                    cell = this.graph.addJGraphTEdge(edge);
                    cell.setValue((Object)String.format("%.1f", this.model.getTrackModel().getEdgeWeight(edge)));
                    ID = this.model.getTrackModel().trackIDOf(edge);
                    if (ID != null && !this.model.getTrackModel().isVisible(ID)) {
                        this.importTrack(ID);
                    }
                }
                previousSpot = currentSpot;
            }
        }
        finally {
            this.graph.getModel().endUpdate();
            this.model.endUpdate();
        }
    }

    public void removeSelectedCells() {
        this.graph.getModel().beginUpdate();
        try {
            this.graph.removeCells(this.graph.getSelectionCells());
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedLinkCells() {
        ArrayList<Object> edgeCells = new ArrayList<Object>();
        for (Object obj : this.graph.getSelectionCells()) {
            DefaultWeightedEdge e = this.graph.getEdgeFor((mxICell)obj);
            if (e == null) continue;
            edgeCells.add(obj);
        }
        this.graph.getModel().beginUpdate();
        try {
            this.graph.removeCells(edgeCells.toArray());
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    public void selectTrack(Collection<mxCell> vertices, Collection<mxCell> edges, int direction) {
        HashSet<Spot> inspectionSpots = new HashSet<Spot>(vertices.size());
        for (mxCell cell : vertices) {
            Spot spot = this.graph.getSpotFor((mxICell)cell);
            if (null == spot) continue;
            inspectionSpots.add(spot);
        }
        HashSet<DefaultWeightedEdge> inspectionEdges = new HashSet<DefaultWeightedEdge>(edges.size());
        for (mxCell cell : edges) {
            DefaultWeightedEdge dwe = this.graph.getEdgeFor((mxICell)cell);
            if (null == dwe) continue;
            inspectionEdges.add(dwe);
        }
        this.selectionModel.selectTrack(inspectionSpots, inspectionEdges, direction);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    private class CellRemovalListener
    implements mxEventSource.mxIEventListener {
        private CellRemovalListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Object sender, mxEventObject evt) {
            if (!TrackScheme.this.doFireModelChangeEvent) {
                return;
            }
            Object[] objects = (Object[])evt.getProperty("cells");
            HashSet<Spot> spotsToRemove = new HashSet<Spot>();
            ArrayList<DefaultWeightedEdge> edgesToRemove = new ArrayList<DefaultWeightedEdge>();
            for (Object obj : objects) {
                DefaultWeightedEdge edge;
                mxCell cell = (mxCell)obj;
                if (null == cell) continue;
                if (cell.isVertex()) {
                    Spot spot = TrackScheme.this.graph.getSpotFor((mxICell)cell);
                    spotsToRemove.add(spot);
                    TrackScheme.this.graph.removeMapping(spot);
                    continue;
                }
                if (!cell.isEdge() || null == (edge = TrackScheme.this.graph.getEdgeFor((mxICell)cell))) continue;
                edgesToRemove.add(edge);
                TrackScheme.this.graph.removeMapping(edge);
            }
            evt.consume();
            TrackScheme.this.doFireModelChangeEvent = false;
            TrackScheme.this.model.beginUpdate();
            try {
                TrackScheme.this.selectionModel.clearSelection();
                for (DefaultWeightedEdge edge : edgesToRemove) {
                    TrackScheme.this.model.removeEdge(edge);
                }
                for (Spot spot : spotsToRemove) {
                    TrackScheme.this.model.removeSpot(spot);
                }
            }
            finally {
                TrackScheme.this.model.endUpdate();
            }
            TrackScheme.this.doFireModelChangeEvent = true;
        }
    }

    private class SelectionChangeListener
    implements mxEventSource.mxIEventListener {
        private SelectionChangeListener() {
        }

        public void invoke(Object sender, mxEventObject evt) {
            if (!TrackScheme.this.doFireSelectionChangeEvent || sender != TrackScheme.this.graph.getSelectionModel()) {
                return;
            }
            Collection added = (Collection)evt.getProperty("added");
            Collection removed = (Collection)evt.getProperty("removed");
            TrackScheme.this.userChangedSelection(added, removed);
        }
    }
}

