/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import java.io.Serializable;
import pal.math.MersenneTwisterFast;

public class UrnModel
implements Serializable {
    private int capacity;
    private int numNumbers;
    private int numDrawn;
    private int next;
    private boolean[] isAvailable;
    private MersenneTwisterFast rng;

    public UrnModel(int n) {
        this.capacity = n;
        this.isAvailable = new boolean[n];
        this.rng = new MersenneTwisterFast();
        this.reset();
    }

    public int drawDontPutBack() {
        if (this.numNumbers == this.numDrawn) {
            this.next = -1;
        } else {
            this.draw();
            this.isAvailable[this.next] = false;
            ++this.numDrawn;
        }
        return this.next;
    }

    public void reset() {
        this.numNumbers = this.capacity;
        this.numDrawn = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.isAvailable[i] = true;
        }
    }

    public int drawPutBack() {
        if (this.numNumbers == this.numDrawn) {
            this.next = -1;
        } else {
            this.draw();
        }
        return this.next;
    }

    private void draw() {
        int i = this.rng.nextInt(this.numNumbers - this.numDrawn);
        this.next = -1;
        int k = -1;
        do {
            ++this.next;
            if (!this.isAvailable[this.next]) continue;
            ++k;
        } while (k != i);
    }
}

