/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import org.scijava.convert.ConversionRequest;
import org.scijava.plugin.HandlerPlugin;
import org.scijava.util.Types;

public interface Converter<I, O>
extends HandlerPlugin<ConversionRequest> {
    default public boolean canConvert(ConversionRequest request) {
        if (request == null) {
            return false;
        }
        Object src = request.sourceObject();
        Type destType = request.destType();
        if (src != null && destType != null) {
            return this.canConvert(src, destType);
        }
        if (src != null) {
            return this.canConvert(src, request.destClass());
        }
        if (destType != null) {
            return this.canConvert(request.sourceClass(), destType);
        }
        return this.canConvert(request.sourceClass(), request.destClass());
    }

    default public boolean canConvert(Object src, Type dest) {
        if (src == null || dest == null) {
            return false;
        }
        return this.canConvert(src.getClass(), dest);
    }

    default public boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> srcClass = src.getClass();
        return this.canConvert(srcClass, dest);
    }

    default public boolean canConvert(Class<?> src, Type dest) {
        Class<?> destClass = Types.raw(dest);
        return this.canConvert(src, destClass);
    }

    default public boolean canConvert(Class<?> src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> saneSrc = Types.box(src);
        Class<?> saneDest = Types.box(dest);
        return Types.isAssignable(saneSrc, this.getInputType()) && Types.isAssignable(this.getOutputType(), saneDest);
    }

    default public Object convert(ConversionRequest request) {
        if (request.destType() != null) {
            return this.convert(request.sourceObject(), request.destType());
        }
        return this.convert(request.sourceObject(), request.destClass());
    }

    default public Object convert(Object src, Type dest) {
        Class<?> destClass = Types.raw(dest);
        return this.convert(src, destClass);
    }

    public <T> T convert(Object var1, Class<T> var2);

    public void populateInputCandidates(Collection<Object> var1);

    public Class<O> getOutputType();

    public Class<I> getInputType();

    @Override
    default public boolean supports(ConversionRequest request) {
        return this.canConvert(request);
    }

    @Override
    default public Class<ConversionRequest> getType() {
        return ConversionRequest.class;
    }
}

