/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import org.scijava.AbstractUIDetails;
import org.scijava.Identifiable;
import org.scijava.Instantiable;
import org.scijava.InstantiableException;
import org.scijava.Locatable;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.Priority;
import org.scijava.Versioned;
import org.scijava.input.Accelerator;
import org.scijava.plugin.Attr;
import org.scijava.plugin.HasPluginInfo;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.SciJavaPlugin;
import org.scijava.util.StringMaker;
import org.scijava.util.Types;
import org.scijava.util.VersionUtils;

public class PluginInfo<PT extends SciJavaPlugin>
extends AbstractUIDetails
implements Instantiable<PT>,
Identifiable,
Locatable,
Versioned {
    private String className;
    private Class<? extends PT> pluginClass;
    private Class<PT> pluginType;
    private Plugin annotation;
    private ClassLoader classLoader;

    public PluginInfo(String className, Class<PT> pluginType) {
        this(className, null, pluginType, null, null);
    }

    public PluginInfo(String className, Class<PT> pluginType, Plugin annotation) {
        this(className, null, pluginType, annotation, null);
    }

    public PluginInfo(String className, Class<PT> pluginType, Plugin annotation, ClassLoader classLoader) {
        this(className, null, pluginType, annotation, classLoader);
    }

    public PluginInfo(Class<? extends PT> pluginClass, Class<PT> pluginType) {
        this(null, pluginClass, pluginType, null, null);
    }

    public PluginInfo(Class<? extends PT> pluginClass, Class<PT> pluginType, Plugin annotation) {
        this(null, pluginClass, pluginType, annotation, null);
    }

    protected PluginInfo(String className, Class<? extends PT> pluginClass, Class<PT> pluginType, Plugin annotation, ClassLoader classLoader) {
        if (pluginClass != null) {
            if (className != null) {
                throw new IllegalArgumentException("className and pluginClass are mutually exclusive");
            }
            this.setPluginClass(pluginClass);
        } else {
            this.className = className;
        }
        this.setPluginType(pluginType);
        this.setMenuPath(null);
        this.setMenuRoot("app");
        if (annotation == null) {
            if (pluginClass != null) {
                this.annotation = pluginClass.getAnnotation(Plugin.class);
            }
        } else {
            this.annotation = annotation;
        }
        this.populateValues();
        this.classLoader = classLoader;
    }

    public void setPluginClass(Class<? extends PT> pluginClass) {
        this.pluginClass = pluginClass;
    }

    public Class<? extends PT> getPluginClass() {
        return this.pluginClass;
    }

    public void setPluginType(Class<PT> pluginType) {
        this.pluginType = pluginType;
    }

    public Class<PT> getPluginType() {
        return this.pluginType;
    }

    public Plugin getAnnotation() {
        return this.annotation;
    }

    public URL getIconURL() throws InstantiableException {
        String iconPath = this.getIconPath();
        if (iconPath == null || iconPath.isEmpty()) {
            return null;
        }
        return this.loadClass().getResource(iconPath);
    }

    public boolean inject(Object o) {
        if (!(o instanceof HasPluginInfo)) {
            return false;
        }
        HasPluginInfo hi = (HasPluginInfo)o;
        hi.setInfo(this);
        return true;
    }

    @Override
    public String toString() {
        StringMaker sm = new StringMaker();
        sm.append("class", this.className);
        sm.append(super.toString());
        sm.append("pluginType", this.pluginType);
        return sm.toString();
    }

    @Override
    public String getClassName() {
        if (this.pluginClass != null) {
            return this.pluginClass.getName();
        }
        return this.className;
    }

    @Override
    public Class<? extends PT> loadClass() throws InstantiableException {
        if (this.pluginClass == null) {
            try {
                Class<?> c;
                Class<?> typedClass = c = Types.load(this.className, this.classLoader, false);
                this.pluginClass = typedClass;
            }
            catch (IllegalArgumentException exc) {
                throw new InstantiableException("Class not found: " + this.className, exc);
            }
        }
        return this.pluginClass;
    }

    @Override
    public PT createInstance() throws InstantiableException {
        SciJavaPlugin instance;
        Class<PT> c = this.loadClass();
        try {
            instance = (SciJavaPlugin)c.newInstance();
            this.inject(instance);
            Priority.inject(instance, this.getPriority());
        }
        catch (InstantiationException e) {
            throw new InstantiableException(e);
        }
        catch (IllegalAccessException e) {
            throw new InstantiableException(e);
        }
        return (PT)instance;
    }

    @Override
    public String getIdentifier() {
        return "plugin:" + this.getClassName();
    }

    @Override
    public String getLocation() {
        try {
            return Types.location(this.loadClass()).toExternalForm();
        }
        catch (InstantiableException exc) {
            return null;
        }
    }

    @Override
    public String getVersion() {
        try {
            return VersionUtils.getVersion(this.loadClass());
        }
        catch (InstantiableException exc) {
            return null;
        }
    }

    public static <P extends SciJavaPlugin> PluginInfo<?> get(Class<P> pluginClass, PluginIndex pluginIndex) {
        return PluginInfo.get(pluginClass, pluginIndex.getAll());
    }

    public static <P extends PT, PT extends SciJavaPlugin> PluginInfo<PT> get(Class<P> pluginClass, Class<PT> pluginType, PluginIndex pluginIndex) {
        return PluginInfo.get(pluginClass, pluginIndex.getPlugins(pluginType));
    }

    public static <P extends PT, PT extends SciJavaPlugin> PluginInfo<PT> get(Class<P> pluginClass, Collection<? extends PluginInfo<PT>> plugins) {
        String className = pluginClass.getName();
        Optional<PluginInfo> result = plugins.stream().filter(info -> info.getClassName().equals(className)).findFirst();
        return result.isPresent() ? result.get() : null;
    }

    public static PluginInfo<?> create(Class<? extends SciJavaPlugin> pluginClass) {
        PluginInfo<? extends SciJavaPlugin> info = new PluginInfo<SciJavaPlugin>(pluginClass, PluginInfo.pluginType(pluginClass));
        return info;
    }

    public static <P extends PT, PT extends SciJavaPlugin> PluginInfo<PT> create(Class<P> pluginClass, Class<PT> pluginType) {
        return new PluginInfo<P>(pluginClass, pluginType);
    }

    public static <P extends SciJavaPlugin> PluginInfo<?> getOrCreate(Class<P> pluginClass, PluginIndex pluginIndex) {
        PluginInfo<?> existing = PluginInfo.get(pluginClass, pluginIndex);
        return existing == null ? PluginInfo.create(pluginClass) : existing;
    }

    public static <P extends PT, PT extends SciJavaPlugin> PluginInfo<PT> getOrCreate(Class<P> pluginClass, Class<PT> pluginType, PluginIndex pluginIndex) {
        PluginInfo<PT> existing = PluginInfo.get(pluginClass, pluginType, pluginIndex);
        return existing == null ? PluginInfo.create(pluginClass, pluginType) : existing;
    }

    private void populateValues() {
        String menuIconPath;
        Plugin ann = this.getAnnotation();
        if (ann == null) {
            return;
        }
        this.setName(ann.name());
        this.setLabel(ann.label());
        this.setDescription(ann.description());
        Menu[] menu = ann.menu();
        MenuPath menuPath = menu.length > 0 ? this.parseMenuPath(menu) : new MenuPath(ann.menuPath());
        this.setMenuPath(menuPath);
        this.setMenuRoot(ann.menuRoot());
        String iconPath = ann.iconPath();
        this.setIconPath(iconPath);
        this.setPriority(ann.priority());
        this.setEnabled(ann.enabled());
        this.setVisible(ann.visible());
        this.setSelectable(ann.selectable());
        this.setSelectionGroup(ann.selectionGroup());
        MenuEntry menuLeaf = menuPath.getLeaf();
        if (menuLeaf != null && !iconPath.isEmpty() && ((menuIconPath = menuLeaf.getIconPath()) == null || menuIconPath.isEmpty())) {
            menuLeaf.setIconPath(iconPath);
        }
        for (Attr attr : ann.attrs()) {
            String name = attr.name();
            String value = attr.value();
            this.set(name, value);
        }
    }

    private MenuPath parseMenuPath(Menu[] menu) {
        MenuPath menuPath = new MenuPath();
        for (int i = 0; i < menu.length; ++i) {
            String name = menu[i].label();
            double weight = menu[i].weight();
            char mnemonic = menu[i].mnemonic();
            Accelerator acc = Accelerator.create(menu[i].accelerator());
            String iconPath = menu[i].iconPath();
            menuPath.add(new MenuEntry(name, weight, mnemonic, acc, iconPath));
        }
        return menuPath;
    }

    private static <P extends SciJavaPlugin> Class<? super P> pluginType(Class<P> pluginClass) {
        Plugin annotation = pluginClass.getAnnotation(Plugin.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Cannot infer plugin type from class '" + pluginClass.getName() + "' with no @Plugin annotation.");
        }
        Class<? extends SciJavaPlugin> type = annotation.type();
        if (!type.isAssignableFrom(pluginClass)) {
            throw new IllegalArgumentException("Invalid plugin type '" + type.getName() + "' for class '" + pluginClass.getName() + "'");
        }
        Class<? extends SciJavaPlugin> pluginType = type;
        return pluginType;
    }
}

