/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.ojalgo.netio.BasicLogger;

public final class CharacterRing
implements CharSequence,
Appendable,
Serializable,
BasicLogger.Buffer {
    public static final int length = 65536;
    private final char[] myCharacters = new char[65536];
    private char myCursor = '\u0000';

    @Override
    public CharacterRing append(char c) throws IOException {
        char c2 = this.myCursor;
        this.myCursor = (char)(c2 + '\u0001');
        this.myCharacters[c2] = c;
        return this;
    }

    @Override
    public CharacterRing append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public CharacterRing append(CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    public OutputStreamBuffer asOutputStream() {
        return new OutputStreamBuffer(this);
    }

    public PrinterBuffer asPrinter() {
        return new PrinterBuffer(this);
    }

    public WriterBuffer asWriter() {
        return new WriterBuffer(this);
    }

    @Override
    public char charAt(int index) {
        return this.myCharacters[(this.myCursor + index) % 65536];
    }

    @Override
    public void clear() {
        Arrays.fill(this.myCharacters, '\u0000');
        this.myCursor = '\u0000';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterRing)) {
            return false;
        }
        CharacterRing other = (CharacterRing)obj;
        if (!Arrays.equals(this.myCharacters, other.myCharacters)) {
            return false;
        }
        return this.myCursor == other.myCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(BasicLogger.Printer receiver) {
        BasicLogger.Printer printer = receiver;
        synchronized (printer) {
            char tmpChar;
            int tmpCursor;
            int i;
            for (i = tmpCursor = this.myCursor; i < 65536; ++i) {
                tmpChar = this.myCharacters[i];
                if (tmpChar == '\u0000') continue;
                receiver.print(tmpChar);
            }
            for (i = 0; i < tmpCursor; ++i) {
                tmpChar = this.myCharacters[i];
                if (tmpChar == '\u0000') continue;
                receiver.print(tmpChar);
            }
            this.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.myCharacters);
        result = 31 * result + this.myCursor;
        return result;
    }

    public int indexOfFirst(char c) {
        int tmpCursor;
        int i;
        int retVal = -1;
        for (i = tmpCursor = this.myCursor; retVal < 0 && i < 65536; ++i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i - tmpCursor;
        }
        for (i = 0; retVal < 0 && i < tmpCursor; ++i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i + tmpCursor;
        }
        return retVal;
    }

    public int indexOfLast(char c) {
        int i;
        int retVal = -1;
        char tmpCursor = this.myCursor;
        for (i = tmpCursor - '\u0001'; retVal < 0 && i >= 0; --i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i + tmpCursor;
        }
        for (i = 65535; retVal < 0 && i >= tmpCursor; --i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i - tmpCursor;
        }
        return retVal;
    }

    @Override
    public int length() {
        return 65536;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return CharBuffer.wrap(this, start, end);
    }

    @Override
    public String toString() {
        char tmpCursor = this.myCursor;
        String tmpFirstPart = String.valueOf(this.myCharacters, tmpCursor, 65536 - tmpCursor);
        String tmpSecondPart = String.valueOf(this.myCharacters, 0, tmpCursor);
        return tmpFirstPart + tmpSecondPart;
    }

    char getCursor() {
        return this.myCursor;
    }

    public static final class WriterBuffer
    extends Writer
    implements BasicLogger.Buffer {
        private final CharacterRing myRing;

        WriterBuffer(CharacterRing ring) {
            super(ring);
            this.myRing = ring;
        }

        @Override
        public void clear() {
            this.myRing.clear();
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WriterBuffer)) {
                return false;
            }
            WriterBuffer other = (WriterBuffer)obj;
            return !(this.myRing == null ? other.myRing != null : !this.myRing.equals(other.myRing));
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void flush(BasicLogger.Printer printer) {
            this.myRing.flush(printer);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myRing == null ? 0 : this.myRing.hashCode());
            return result;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.myRing.append(cbuf[off + i]);
            }
        }
    }

    public static final class PrinterBuffer
    extends BasicLogger.AppendablePrinter
    implements BasicLogger.Buffer {
        private final CharacterRing myRing;

        PrinterBuffer(CharacterRing ring) {
            super(ring);
            this.myRing = ring;
        }

        @Override
        public void clear() {
            this.myRing.clear();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PrinterBuffer)) {
                return false;
            }
            PrinterBuffer other = (PrinterBuffer)obj;
            return !(this.myRing == null ? other.myRing != null : !this.myRing.equals(other.myRing));
        }

        @Override
        public void flush(BasicLogger.Printer printer) {
            this.myRing.flush(printer);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myRing == null ? 0 : this.myRing.hashCode());
            return result;
        }
    }

    public static final class OutputStreamBuffer
    extends OutputStream
    implements BasicLogger.Buffer {
        private final CharacterRing myRing;

        OutputStreamBuffer(CharacterRing ring) {
            this.myRing = ring;
        }

        @Override
        public void clear() {
            this.myRing.clear();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OutputStreamBuffer)) {
                return false;
            }
            OutputStreamBuffer other = (OutputStreamBuffer)obj;
            return !(this.myRing == null ? other.myRing != null : !this.myRing.equals(other.myRing));
        }

        @Override
        public void flush(BasicLogger.Printer printer) {
            this.myRing.flush(printer);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myRing == null ? 0 : this.myRing.hashCode());
            return result;
        }

        @Override
        public void write(int b) throws IOException {
            this.myRing.append((char)b);
        }
    }
}

