/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.optimisation.linear.SimplexTableau;

public abstract class LinearSolver
extends GenericSolver {
    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(MatrixStore<Double> C) {
        return LinearSolver.getBuilder().objective(C);
    }

    public static Optimisation.Result solve(ConvexSolver.Builder convex, Optimisation.Options options) {
        final int numbVars = convex.countVariables();
        SimplexTableau tableau = SimplexSolver.build(convex);
        SimplexSolver solver = new SimplexSolver(tableau, options);
        final Optimisation.Result result = solver.solve();
        Optimisation.Result retVal = new Optimisation.Result(result.getState(), result.getValue(), new Access1D<Double>(){

            @Override
            public long count() {
                return numbVars;
            }

            @Override
            public double doubleValue(long index) {
                return result.doubleValue(index) - result.doubleValue((long)numbVars + index);
            }

            @Override
            public Double get(long index) {
                return this.doubleValue(index);
            }
        });
        retVal.multipliers(result.getMultipliers().get());
        return retVal;
    }

    protected LinearSolver(Optimisation.Options solverOptions) {
        super(solverOptions);
    }

    protected abstract boolean initialise(Optimisation.Result var1);

    protected abstract boolean needsAnotherIteration();

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<LinearSolver> {
        public LinearSolver build(ConvexSolver.Builder convexBuilder, Optimisation.Options options) {
            SimplexTableau tableau = SimplexSolver.build(convexBuilder);
            return new SimplexSolver(tableau, options);
        }

        @Override
        public LinearSolver build(ExpressionsBasedModel model) {
            SimplexTableau tableau = SimplexSolver.build(model);
            return new SimplexSolver(tableau, model.options);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && !model.isAnyExpressionQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            Primitive64Array tmpModelSolution = Primitive64Array.make(model.countVariables());
            for (Structure1D.IntIndex tmpFixed : model.getFixedVariables()) {
                tmpModelSolution.set((long)tmpFixed.index, model.getVariable(tmpFixed.index).getValue().doubleValue());
            }
            List<Variable> tmpPositives = model.getPositiveVariables();
            for (int p = 0; p < tmpPositives.size(); ++p) {
                Variable tmpVariable = tmpPositives.get(p);
                int tmpIndex = model.indexOf(tmpVariable);
                tmpModelSolution.set((long)tmpIndex, solverState.doubleValue(p));
            }
            List<Variable> tmpNegatives = model.getNegativeVariables();
            for (int n = 0; n < tmpNegatives.size(); ++n) {
                Variable tmpVariable = tmpNegatives.get(n);
                int tmpIndex = model.indexOf(tmpVariable);
                tmpModelSolution.set((long)tmpIndex, tmpModelSolution.doubleValue((long)tmpIndex) - solverState.doubleValue(tmpPositives.size() + n));
            }
            return new Optimisation.Result(solverState.getState(), solverState.getValue(), tmpModelSolution);
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            int tmpIndex;
            Variable tmpVariable;
            List<Variable> tmpPositives = model.getPositiveVariables();
            List<Variable> tmpNegatives = model.getNegativeVariables();
            int tmpCountPositives = tmpPositives.size();
            int tmpCountNegatives = tmpNegatives.size();
            Primitive64Array tmpSolverSolution = Primitive64Array.make(tmpCountPositives + tmpCountNegatives);
            for (int p = 0; p < tmpCountPositives; ++p) {
                tmpVariable = tmpPositives.get(p);
                tmpIndex = model.indexOf(tmpVariable);
                tmpSolverSolution.set((long)p, PrimitiveFunction.MAX.invoke(modelState.doubleValue(tmpIndex), 0.0));
            }
            for (int n = 0; n < tmpCountNegatives; ++n) {
                tmpVariable = tmpNegatives.get(n);
                tmpIndex = model.indexOf(tmpVariable);
                tmpSolverSolution.set((long)(tmpCountPositives + n), PrimitiveFunction.MAX.invoke(-modelState.doubleValue(tmpIndex), 0.0));
            }
            return new Optimisation.Result(modelState.getState(), modelState.getValue(), tmpSolverSolution);
        }

        @Override
        protected boolean isSolutionMapped() {
            return true;
        }
    }

    public static final class Builder
    extends GenericSolver.Builder<Builder, LinearSolver> {
        private final ConvexSolver.Builder myDelegate;

        public Builder() {
            this.myDelegate = new ConvexSolver.Builder();
        }

        public Builder(MatrixStore<Double> C) {
            this.myDelegate = new ConvexSolver.Builder(C);
        }

        @Override
        public int countConstraints() {
            return this.myDelegate.countConstraints();
        }

        @Override
        public int countVariables() {
            return this.myDelegate.countVariables();
        }

        public Builder equalities(MatrixStore<Double> mtrxAE, MatrixStore<Double> mtrxBE) {
            this.myDelegate.equalities(mtrxAE, mtrxBE);
            return this;
        }

        public MatrixStore<Double> getAE() {
            return this.myDelegate.getAE();
        }

        public MatrixStore<Double> getBE() {
            return this.myDelegate.getBE();
        }

        public MatrixStore<Double> getC() {
            return this.myDelegate.getC();
        }

        public Builder objective(MatrixStore<Double> mtrxC) {
            this.myDelegate.objective(mtrxC);
            return this;
        }

        @Override
        protected LinearSolver doBuild(Optimisation.Options options) {
            SimplexTableau.DenseTableau tableau = new SimplexTableau.DenseTableau(this);
            return new SimplexSolver(tableau, options);
        }
    }
}

