/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.analyzer;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.imagej.Dataset;
import org.apache.commons.io.FilenameUtils;
import org.scijava.plugin.Plugin;
import sc.fiji.filamentdetector.Calibrations;
import sc.fiji.filamentdetector.analyzer.AbstractAnalyzer;
import sc.fiji.filamentdetector.analyzer.Analyzer;
import sc.fiji.filamentdetector.model.TrackedFilament;
import sc.fiji.filamentdetector.model.TrackedFilaments;

@Plugin(type=Analyzer.class, priority=100.0)
public class LengthOverTimeAnalyzer
extends AbstractAnalyzer {
    public static String NAME = "Filament Growth Curve";
    public static String DESCRIPTION = "Generate the classic filament length versus time curve. (this analyzer is in development)";

    public LengthOverTimeAnalyzer() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
    }

    @Override
    public String getAnalyzerInfo() {
        String out = "";
        out = out + "Name : " + this.name + "\n";
        out = out + "Save results : " + this.saveResults + "\n";
        out = out + "\n";
        return out;
    }

    @Override
    public void analyze() {
        this.resultMessage = "";
        Calibrations calibrations = this.filamentWorkflow.getCalibrations();
        TrackedFilaments trackedFilaments = this.filamentWorkflow.getTrackedFilaments();
        ArrayList<Integer> filamentIDs = new ArrayList<Integer>();
        ArrayList<Double> lengths = new ArrayList<Double>();
        ArrayList<Double> times = new ArrayList<Double>();
        for (TrackedFilament trackedFilament : trackedFilaments) {
            List<Double> lengthsTrackedFilament = trackedFilament.getLengths();
            List<Double> timesTrackedFilament = trackedFilament.getFrames();
            lengthsTrackedFilament = lengthsTrackedFilament.stream().map(x -> x * calibrations.getDx()).collect(Collectors.toList());
            timesTrackedFilament = timesTrackedFilament.stream().map(x -> x * calibrations.getDt()).collect(Collectors.toList());
            filamentIDs.addAll(Collections.nCopies(lengthsTrackedFilament.size(), trackedFilament.getId()));
            lengths.addAll(lengthsTrackedFilament);
            times.addAll(timesTrackedFilament);
        }
        this.results = new HashMap();
        this.results.put("ids", filamentIDs);
        this.results.put("lengths", lengths);
        this.results.put("times", times);
        if (this.saveResults) {
            Dataset dataset = (Dataset)this.filamentWorkflow.getSourceImage().getActiveView().getData();
            if (dataset.getSource() != null && dataset.getSource() != "") {
                String filePath = FilenameUtils.removeExtension((String)dataset.getSource());
                filePath = filePath + "-LengthOverTime.csv";
                File file = new File(filePath);
                try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(file), ';', '\"', '\"', "\n");){
                    writer.writeNext((String[])Arrays.asList("filament id", "time", "length").stream().toArray(String[]::new));
                    ArrayList<String[]> data = new ArrayList<String[]>();
                    for (int i = 0; i < lengths.size(); ++i) {
                        ArrayList<String> row = new ArrayList<String>();
                        row.add(Integer.toString((Integer)filamentIDs.get(i)));
                        row.add(Double.toString((Double)times.get(i)));
                        row.add(Double.toString((Double)lengths.get(i)));
                        data.add(row.toArray(new String[0]));
                    }
                    writer.writeAll(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.resultMessage = this.resultMessage + "Can't save the result file !";
            }
        }
    }
}

