/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.imagearchive.lsm.reader.Reader;
import org.imagearchive.lsm.reader.info.CZLSMInfo;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;

public class BatchConverter {
    private final MasterModel masterModel;

    public BatchConverter(MasterModel masterModel) {
        this.masterModel = masterModel;
    }

    public void convertFile(String file, String outputDir, String format, boolean verbose, boolean sepDir) {
        String finalDir = "";
        Reader r = new Reader();
        File f = new File(file);
        ImagePlus imp = r.open(f.getParent(), f.getName(), false, false);
        if (imp != null && imp.getStackSize() > 0) {
            LSMFileInfo lsm = (LSMFileInfo)imp.getOriginalFileInfo();
            CZLSMInfo cz = (CZLSMInfo)((ImageDirectory)lsm.imageDirectories.get((int)0)).TIF_CZ_LSMINFO;
            if (sepDir) {
                finalDir = outputDir + System.getProperty("file.separator") + f.getName();
                File fdir = new File(finalDir);
                if (!fdir.exists()) {
                    fdir.mkdirs();
                }
            } else {
                finalDir = outputDir;
            }
            int position = 1;
            int i = 1;
            while ((long)i <= cz.DimensionTime) {
                int j = 1;
                while ((long)j <= cz.DimensionZ) {
                    int k = 1;
                    while ((long)k <= cz.DimensionChannels) {
                        String title = lsm.fileName + " - " + cz.channelNamesAndColors.ChannelNames[k - 1] + " - C" + new Integer(k).toString() + " Z" + new Integer(j).toString() + " T" + new Integer(i).toString();
                        this.save(new ImagePlus(title, imp.getImageStack().getProcessor(position++)), finalDir, format, title);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertBatchFile(String fileName) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fileName));
            String row = null;
            while ((row = br.readLine()) != null) {
                String[] arr = row.split("\t");
                String inputFile = arr[0];
                String outputDir = arr[1];
                String format = arr[2];
                if (arr[2] == null) {
                    format = "tiff";
                }
                boolean verbose = false;
                boolean createSepDir = false;
                if (!arr[3].equals("0")) {
                    verbose = true;
                }
                if (!arr[4].equals("0")) {
                    createSepDir = true;
                }
                IJ.showStatus((String)"Conversion started");
                IJ.showStatus((String)("Converting " + new File(inputFile).getName()));
                this.convertFile(inputFile, outputDir, format, verbose, createSepDir);
                IJ.showStatus((String)"Conversion done");
            }
        }
        catch (IOException e) {
            IJ.error((String)"Incompatible batch file format");
            IJ.log((String)("IOException error: " + e.getMessage()));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    IJ.log((String)("IOException error trying to close the file: " + e.getMessage()));
                }
            }
        }
    }

    public ImagePlus process(ImagePlus imp) {
        return imp;
    }

    public void save(ImagePlus img, String dir, String format, String fileName) {
        String path = dir + System.getProperty("file.separator") + fileName;
        if (format.equals("Tiff")) {
            new FileSaver(img).saveAsTiff(path + ".tif");
        } else if (format.equals("8-bit Tiff")) {
            this.saveAs8bitTiff(img, path + ".tif");
        } else if (format.equals("Zip")) {
            new FileSaver(img).saveAsZip(path + ".zip");
        } else if (format.equals("Raw")) {
            new FileSaver(img).saveAsRaw(path + ".raw");
        } else if (format.equals("Jpeg")) {
            new FileSaver(img).saveAsJpeg(path + ".jpg");
        }
    }

    void saveAs8bitTiff(ImagePlus img, String path) {
        ImageProcessor ip = img.getProcessor();
        if (ip instanceof ColorProcessor) {
            ip = this.reduceColors(ip);
            img.setProcessor(null, ip);
        } else if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip = ip.convertToByte(true);
            img.setProcessor(null, ip);
        }
        new FileSaver(img).saveAsTiff(path);
    }

    ImageProcessor reduceColors(ImageProcessor ip) {
        MedianCut mc = new MedianCut((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
        Image img = mc.convert(256);
        return new ByteProcessor(img);
    }
}

