/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.awt.AWTEvent;
import java.awt.geom.Rectangle2D;

public class Coordinates
implements PlugIn,
DialogListener {
    private static final String help = "<html><h1>Image&gt;Adjust&gt;Coordinates</h1><font size=+1>This command allows the user to set the corner coordinates of<br>the selection bounds or the full image. This modifies the image<br>scale (<i>pixelWidth</i>, <i>pixelHeight</i>) and <i>xOrigin</i> and <i>yOrigin</i>. If a<br>single point is selected, the coordinates of the point can be<br>specified, which only sets <i>xOrigin</i> and <i>yOrigin</i>. The units for X<br>and Y can be also selected.<br> </font>";
    private static final String SAME_AS_X = "<same as x unit>";
    private static final int IMAGE = 0;
    private static final int ROI_BOUNDS = 1;
    private static final int POINT = 2;
    private int mode = 0;
    private boolean isStack;

    @Override
    public void run(String arg) {
        String yUnit2;
        ImagePlus imp = IJ.getImage();
        int imageHeight = imp.getHeight();
        Calibration cal = imp.getCalibration();
        Roi roi = imp.getRoi();
        Rectangle2D.Double bounds = null;
        int numSlices = imp.getNSlices();
        int currSlice = imp.getCurrentSlice();
        boolean bl = this.isStack = numSlices > 1;
        if (roi != null) {
            bounds = roi.getFloatBounds();
            this.mode = bounds.width == 0.0 && bounds.height == 0.0 ? 2 : 1;
        } else {
            bounds = new Rectangle2D.Double(0.0, 0.0, imp.getWidth(), imp.getHeight());
        }
        String title = (this.mode == 0 ? "Image" : "Selection") + " Coordinates";
        if (this.mode == 2) {
            title = "Point Coordinates";
        }
        GenericDialog gd = new GenericDialog(title);
        if (this.mode == 2) {
            gd.addNumericField("X:", cal.getX(bounds.x), 2, 8, "");
            gd.addNumericField("Y:", cal.getY(bounds.y, imageHeight), 2, 8, "");
            if (this.isStack) {
                gd.addNumericField("Z:", cal.getZ(currSlice - 1), 2, 8, "");
            }
        } else {
            gd.addNumericField("Left:", cal.getX(bounds.x), 2, 8, "");
            gd.addNumericField("Right:", cal.getX(bounds.x + bounds.width), 2, 8, "");
            gd.addNumericField("Top:", cal.getY(bounds.y, imageHeight), 2, 8, "");
            gd.addNumericField("Bottom:", cal.getY(bounds.y + bounds.height, imageHeight), 2, 8, "");
            if (this.isStack) {
                gd.addNumericField("Front:", cal.getZ(0.0), 2, 8, "");
                gd.addNumericField("Back:", cal.getZ(numSlices), 2, 8, "");
            }
        }
        String xUnit = cal.getUnit();
        String yUnit = cal.getYUnit();
        String zUnit = cal.getZUnit();
        boolean xUnitChanged = false;
        boolean yUnitChanged = false;
        boolean zUnitChanged = false;
        gd.addStringField("X_unit:", xUnit, 18);
        gd.addStringField("Y_unit:", yUnit.equals(xUnit) ? SAME_AS_X : yUnit, 18);
        if (this.isStack) {
            gd.addStringField("Z_unit:", zUnit.equals(xUnit) ? SAME_AS_X : zUnit, 18);
        }
        gd.addHelp(help);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (this.mode == 2) {
            double x = gd.getNextNumber();
            double y = gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error("Invalid number");
                return;
            }
            cal.xOrigin = this.coordinate2offset(x, bounds.x, cal.pixelWidth);
            cal.yOrigin = this.coordinate2offset(y, bounds.y, cal.getInvertY() ? -cal.pixelHeight : cal.pixelHeight);
            if (this.isStack) {
                double z = gd.getNextNumber();
                if (gd.invalidNumber()) {
                    IJ.error("Invalid number");
                    return;
                }
                cal.zOrigin = this.coordinate2offset(z, currSlice - 1, cal.pixelDepth);
            }
        } else {
            double xl = gd.getNextNumber();
            double xr = gd.getNextNumber();
            double yt = gd.getNextNumber();
            double yb = gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error("Invalid number");
                return;
            }
            cal.pixelWidth = (xr - xl) / bounds.width;
            cal.pixelHeight = (yb - yt) / bounds.height;
            cal.xOrigin = this.coordinate2offset(xl, bounds.x, cal.pixelWidth);
            cal.yOrigin = this.coordinate2offset(yt, bounds.y, cal.pixelHeight);
            cal.setInvertY(cal.pixelHeight < 0.0);
            if (this.isStack) {
                double zf = gd.getNextNumber();
                double zl = gd.getNextNumber();
                cal.pixelDepth = (zl - zf) / (double)numSlices;
                cal.zOrigin = this.coordinate2offset(zf, 0.0, cal.pixelDepth);
            }
            if (cal.pixelHeight < 0.0) {
                cal.pixelHeight = -cal.pixelHeight;
            }
        }
        String xUnit2 = gd.getNextString();
        boolean bl2 = xUnitChanged = !xUnit2.equals(xUnit);
        if (xUnitChanged) {
            cal.setXUnit(xUnit2);
        }
        boolean bl3 = yUnitChanged = !(yUnit2 = gd.getNextString()).equals(yUnit) && !yUnit2.equals(SAME_AS_X);
        if (yUnitChanged) {
            cal.setYUnit(yUnit2);
        }
        String zUnit2 = null;
        if (this.isStack) {
            zUnit2 = gd.getNextString();
            boolean bl4 = zUnitChanged = !zUnit2.equals(zUnit) && !zUnit2.equals(SAME_AS_X);
            if (zUnitChanged) {
                cal.setZUnit(zUnit2);
            }
        }
        ImageWindow win = imp.getWindow();
        imp.repaintWindow();
        if (IJ.recording()) {
            if (Recorder.scriptMode()) {
                if (xUnitChanged) {
                    Recorder.recordCall("imp.getCalibration().setXUnit(\"" + xUnit2 + "\");", true);
                }
                if (yUnitChanged) {
                    Recorder.recordCall("imp.getCalibration().setYUnit(\"" + yUnit2 + "\");", true);
                }
                if (zUnitChanged) {
                    Recorder.recordCall("imp.getCalibration().setZUnit(\"" + zUnit2 + "\");", true);
                }
            } else {
                if (xUnitChanged) {
                    Recorder.record("Stack.setXUnit", xUnit2);
                }
                if (yUnitChanged) {
                    Recorder.record("Stack.setYUnit", yUnit2);
                }
                if (zUnitChanged) {
                    Recorder.record("Stack.setZUnit", zUnit2);
                }
            }
        }
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (this.mode == 2) {
            gd.getNextNumber();
            gd.getNextNumber();
            if (this.isStack) {
                gd.getNextNumber();
            }
            return !gd.invalidNumber();
        }
        double xl = gd.getNextNumber();
        double xr = gd.getNextNumber();
        double yt = gd.getNextNumber();
        double yb = gd.getNextNumber();
        if (this.isStack) {
            double zf = gd.getNextNumber();
            double zl = gd.getNextNumber();
            return !gd.invalidNumber() && xr > xl && yt != yb && zl > zf;
        }
        return !gd.invalidNumber() && xr > xl && yt != yb;
    }

    private double coordinate2offset(double coordinate, double pixelPos, double pixelSize) {
        return pixelPos - coordinate / pixelSize;
    }
}

