/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter;

import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.gabor.SingleGaborFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.lipschitz.SingleLipschitzFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.dog2.SingleDifferenceOfGaussiansFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.gauss.SingleGaussianBlurFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.gradient.SingleGaussianGradientMagnitudeFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.hessian.SingleHessianEigenvaluesFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.identity.IdentityFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.laplacian.SingleLaplacianOfGaussianFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.SingleMaxFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.SingleMeanFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.SingleMinFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.SingleVarianceFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.structure.SingleStructureTensorEigenvaluesFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;

public class SingleFeatures {
    public static FeatureSetting identity() {
        return SingleFeatures.createFeature(IdentityFeature.class, new Object[0]);
    }

    @Deprecated
    public static FeatureSetting gabor(double sigma, double gamma, double psi, double frequency, int nAngles) {
        return SingleFeatures.gabor(sigma, gamma, psi, frequency, nAngles, false);
    }

    @Deprecated
    public static FeatureSetting legacyGabor(double sigma, double gamma, double psi, double frequency, int nAngles) {
        return SingleFeatures.gabor(sigma, gamma, psi, frequency, nAngles, true);
    }

    @Deprecated
    private static FeatureSetting gabor(double sigma, double gamma, double psi, double frequency, int nAngles, boolean legacyNormalize) {
        return SingleFeatures.createFeature(SingleGaborFeature.class, "sigma", sigma, "gamma", gamma, "psi", psi, "frequency", frequency, "nAngles", nAngles, "legacyNormalize", legacyNormalize);
    }

    public static FeatureSetting gauss(double sigma) {
        return SingleFeatures.createFeature(SingleGaussianBlurFeature.class, "sigma", sigma);
    }

    public static FeatureSetting gradient(double sigma) {
        return SingleFeatures.createFeature(SingleGaussianGradientMagnitudeFeature.class, "sigma", sigma);
    }

    @Deprecated
    public static FeatureSetting lipschitz(double slope, long border) {
        return SingleFeatures.createFeature(SingleLipschitzFeature.class, "slope", slope, "border", border);
    }

    public static FeatureSetting hessian(double sigma) {
        return SingleFeatures.createFeature(SingleHessianEigenvaluesFeature.class, "sigma", sigma);
    }

    public static FeatureSetting differenceOfGaussians(double sigma1, double sigma2) {
        return SingleFeatures.createFeature(SingleDifferenceOfGaussiansFeature.class, "sigma1", sigma1, "sigma2", sigma2);
    }

    public static FeatureSetting structureTensor(double sigma, double integrationScale) {
        return SingleFeatures.createFeature(SingleStructureTensorEigenvaluesFeature.class, "sigma", sigma, "integrationScale", integrationScale);
    }

    public static FeatureSetting laplacian(double sigma) {
        return SingleFeatures.createFeature(SingleLaplacianOfGaussianFeature.class, "sigma", sigma);
    }

    public static FeatureSetting min(double radius) {
        return SingleFeatures.createFeature(SingleMinFeature.class, "radius", radius);
    }

    public static FeatureSetting max(double radius) {
        return SingleFeatures.createFeature(SingleMaxFeature.class, "radius", radius);
    }

    public static FeatureSetting mean(double radius) {
        return SingleFeatures.createFeature(SingleMeanFeature.class, "radius", radius);
    }

    public static FeatureSetting variance(double radius) {
        return SingleFeatures.createFeature(SingleVarianceFeature.class, "radius", radius);
    }

    private static FeatureSetting createFeature(Class<? extends FeatureOp> aClass, Object ... args) {
        return new FeatureSetting(aClass, args);
    }
}

