/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.dog2;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractGroupFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.SingleFeatures;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;

@Plugin(type=FeatureOp.class, label="difference of gaussians (for each sigma)")
public class DifferenceOfGaussiansFeature
extends AbstractGroupFeatureOp {
    private List<Pair<Double, Double>> sigmaPairs(List<Double> sigmas) {
        ArrayList<Pair<Double, Double>> sigmaPairs = new ArrayList<Pair<Double, Double>>();
        for (double sigma1 : sigmas) {
            for (double sigma2 : sigmas) {
                if (!(sigma1 < sigma2)) continue;
                sigmaPairs.add((Pair<Double, Double>)new ValuePair((Object)sigma1, (Object)sigma2));
            }
        }
        return sigmaPairs;
    }

    @Override
    protected List<FeatureSetting> initFeatures() {
        List<Double> sigmas = this.globalSettings().sigmas();
        List<Pair<Double, Double>> pairs = this.sigmaPairs(sigmas);
        return pairs.stream().map(sigma1And2 -> SingleFeatures.differenceOfGaussians((Double)sigma1And2.getA(), (Double)sigma1And2.getB())).collect(Collectors.toList());
    }
}

