/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection.descriptor;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import fiji.util.node.Leaf;
import java.util.ArrayList;
import mpicbg.models.Point;
import mpicbg.pointdescriptor.ModelPointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.matcher.SimpleMatcher;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;
import mpicbg.pointdescriptor.model.TranslationInvariantRigidModel3D;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;
import mpicbg.pointdescriptor.similarity.SquareDistance;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import mpicbg.spim.registration.detection.DetectionView;
import mpicbg.spim.registration.detection.descriptor.CorrespondenceExtraction;

public class ModelBased3d<T extends DetectionView<?, T>>
implements CorrespondenceExtraction<T> {
    final Matcher matcher;
    final TranslationInvariantModel<?> model;

    public ModelBased3d(TranslationInvariantModel<?> model, Matcher matcher) {
        this.matcher = matcher;
        this.model = model;
    }

    public ModelBased3d(TranslationInvariantModel<?> model) {
        this(model, new SimpleMatcher(3));
    }

    public ModelBased3d(Matcher matcher) {
        this(new TranslationInvariantRigidModel3D(), matcher);
    }

    public ModelBased3d() {
        this(new SimpleMatcher(3));
    }

    @Override
    public ArrayList<PointMatchGeneric<T>> extractCorrespondenceCandidates(ArrayList<T> nodeListA, ArrayList<T> nodeListB, double differenceThreshold, double ratioOfDistance, boolean useAssociatedBeads) {
        KDTree treeA = new KDTree(nodeListA);
        KDTree treeB = new KDTree(nodeListB);
        int numNeighbors = this.matcher.getRequiredNumNeighbors();
        SquareDistance similarityMeasure = new SquareDistance();
        ArrayList<ModelPointDescriptor<T>> descriptors1 = ModelBased3d.createModelPointDescriptors(treeA, nodeListA, numNeighbors, this.model, this.matcher, similarityMeasure);
        ArrayList<ModelPointDescriptor<T>> descriptors2 = ModelBased3d.createModelPointDescriptors(treeB, nodeListB, numNeighbors, this.model, this.matcher, similarityMeasure);
        ArrayList<PointMatchGeneric<T>> correspondences = new ArrayList<PointMatchGeneric<T>>();
        for (ModelPointDescriptor<T> descriptorA : descriptors1) {
            double bestDifference = Double.MAX_VALUE;
            double secondBestDifference = Double.MAX_VALUE;
            ModelPointDescriptor<T> bestMatch = null;
            ModelPointDescriptor<T> secondBestMatch = null;
            for (ModelPointDescriptor<T> descriptorB : descriptors2) {
                double difference = descriptorA.descriptorDistance(descriptorB);
                if (!(difference < secondBestDifference)) continue;
                secondBestDifference = difference;
                secondBestMatch = descriptorB;
                if (!(secondBestDifference < bestDifference)) continue;
                double tmpDiff = secondBestDifference;
                ModelPointDescriptor<T> tmpMatch = secondBestMatch;
                secondBestDifference = bestDifference;
                secondBestMatch = bestMatch;
                bestDifference = tmpDiff;
                bestMatch = tmpMatch;
            }
            if (!(bestDifference < differenceThreshold) || !(bestDifference * ratioOfDistance <= secondBestDifference)) continue;
            DetectionView detectionA = (DetectionView)((Object)descriptorA.getBasisPoint());
            DetectionView detectionB = (DetectionView)((Object)bestMatch.getBasisPoint());
            detectionA.addPointDescriptorCorrespondence(detectionB, 1.0);
            detectionB.addPointDescriptorCorrespondence(detectionA, 1.0);
            correspondences.add(new PointMatchGeneric<DetectionView>(detectionA, detectionB, 1.0));
        }
        return correspondences;
    }

    public static <P extends Point> ArrayList<ModelPointDescriptor<P>> createModelPointDescriptors(KDTree<P> tree, ArrayList<P> basisPoints, int numNeighbors, TranslationInvariantModel<?> model, Matcher matcher, SimilarityMeasure similarityMeasure) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<ModelPointDescriptor<P>> descriptors = new ArrayList<ModelPointDescriptor<P>>();
        for (Point point : basisPoints) {
            ArrayList<Point> neighbors = new ArrayList<Point>();
            Point[] neighborList = (Point[])nnsearch.findNNearestNeighbors((Leaf)point, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n]);
            }
            try {
                descriptors.add(new ModelPointDescriptor<Point>(point, neighbors, model, similarityMeasure, matcher));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }
}

