/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

import ij.gui.GenericDialog;
import java.util.ArrayList;
import java.util.Collections;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.util.GenericDialogAppender;
import spim.process.cuda.CUDADevice;
import spim.process.cuda.CUDAStandardFunctions;

public class CUDATools {
    public static ArrayList<Boolean> deviceChoice = null;
    public static int standardDevice = -1;

    public static ArrayList<CUDADevice> queryCUDADetails(CUDAStandardFunctions cuda, boolean askForMultipleDevices) {
        return CUDATools.queryCUDADetails(cuda, askForMultipleDevices, null);
    }

    public static ArrayList<CUDADevice> queryCUDADetails(CUDAStandardFunctions cuda, boolean askForMultipleDevices, GenericDialogAppender additionalQueries) {
        GenericDialog gdCUDA;
        int numDevices = cuda.getNumDevicesCUDA();
        if (numDevices == -1) {
            IOFunctions.println("Querying CUDA devices crashed, no devices available.");
            return null;
        }
        if (numDevices == 0) {
            IOFunctions.println("No CUDA devices detected.");
            return null;
        }
        CUDADevice[] deviceList = new CUDADevice[numDevices];
        byte[] name = new byte[256];
        int highestComputeCapability = 0;
        long highestMemory = 0L;
        int highestComputeCapabilityDevice = -1;
        for (int i = 0; i < numDevices; ++i) {
            long freeMem;
            cuda.getNameDeviceCUDA(i, name);
            String deviceName = "";
            for (byte b : name) {
                if (b == 0) continue;
                deviceName = deviceName + (char)b;
            }
            deviceName.trim();
            long mem = cuda.getMemDeviceCUDA(i);
            try {
                freeMem = cuda.getFreeMemDeviceCUDA(i);
            }
            catch (UnsatisfiedLinkError e) {
                IOFunctions.println("Using an outdated version of the CUDA libs, cannot query free memory. Assuming total memory.");
                freeMem = mem;
            }
            int majorVersion = cuda.getCUDAcomputeCapabilityMajorVersion(i);
            int minorVersion = cuda.getCUDAcomputeCapabilityMinorVersion(i);
            int compCap = 10 * majorVersion + minorVersion;
            if (compCap > highestComputeCapability) {
                highestComputeCapability = compCap;
                highestComputeCapabilityDevice = i;
            }
            if (mem > highestMemory) {
                highestMemory = mem;
            }
            deviceList[i] = new CUDADevice(i, deviceName, mem, freeMem, majorVersion, minorVersion);
        }
        ArrayList<CUDADevice> selectedDevices = new ArrayList<CUDADevice>();
        if (askForMultipleDevices) {
            int i;
            if (deviceChoice == null || deviceChoice.size() != deviceList.length) {
                deviceChoice = new ArrayList(deviceList.length + 1);
                for (int i2 = 0; i2 < deviceList.length; ++i2) {
                    deviceChoice.add(true);
                }
                deviceChoice.add(false);
            }
            gdCUDA = new GenericDialog("Choose CUDA/CPUs devices to use");
            for (i = 0; i < deviceList.length; ++i) {
                gdCUDA.addCheckbox("GPU_" + (i + 1) + " of " + deviceList.length + ": " + deviceList[i], deviceChoice.get(i).booleanValue());
            }
            if (additionalQueries != null) {
                additionalQueries.addQuery(gdCUDA);
            }
            gdCUDA.showDialog();
            if (gdCUDA.wasCanceled()) {
                return null;
            }
            for (i = 0; i < deviceList.length; ++i) {
                if (gdCUDA.getNextBoolean()) {
                    selectedDevices.add(deviceList[i]);
                    deviceChoice.set(i, true);
                    continue;
                }
                deviceChoice.set(i, false);
            }
            if (additionalQueries != null && !additionalQueries.parseDialog(gdCUDA)) {
                return null;
            }
            if (selectedDevices.size() == 0) {
                IOFunctions.println("You selected no device, quitting.");
                return null;
            }
        } else {
            gdCUDA = new GenericDialog("Choose CUDA device");
            if (standardDevice < 0 || standardDevice >= deviceList.length) {
                standardDevice = highestComputeCapabilityDevice;
            }
            String[] desc = new String[deviceList.length];
            for (int i = 0; i < deviceList.length; ++i) {
                desc[i] = "GPU " + (i + 1) + " of " + deviceList.length + ": " + deviceList[i];
            }
            gdCUDA.addChoice("Device", desc, desc[standardDevice]);
            if (additionalQueries != null) {
                additionalQueries.addQuery(gdCUDA);
            }
            gdCUDA.showDialog();
            if (gdCUDA.wasCanceled()) {
                return null;
            }
            standardDevice = gdCUDA.getNextChoiceIndex();
            selectedDevices.add(deviceList[standardDevice]);
            if (additionalQueries != null && !additionalQueries.parseDialog(gdCUDA)) {
                return null;
            }
        }
        Collections.sort(selectedDevices);
        for (CUDADevice dev : selectedDevices) {
            IOFunctions.println("Using device " + dev);
        }
        return selectedDevices;
    }
}

