/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.overlay;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Data;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.overlay.Overlay;
import net.imagej.plugins.commands.overlay.AbstractOverlayProperties;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="Overlay Properties...", menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Overlay", mnemonic=111), @Menu(label="Properties...", mnemonic=112, weight=5.0)}, headless=true, initializer="initialize", attrs={@Attr(name="no-legacy")})
public class OverlayProperties
extends AbstractOverlayProperties {
    @Parameter
    private ImageDisplay display;

    private void initialize() {
        this.setOverlays(this.getSelectedOverlays());
        this.updateValues();
    }

    private List<Overlay> getSelectedOverlays() {
        ArrayList<Overlay> result = new ArrayList<Overlay>();
        if (this.display == null) {
            return result;
        }
        for (DataView view : this.display) {
            Data data;
            if (!view.isSelected() || !((data = view.getData()) instanceof Overlay)) continue;
            Overlay o = (Overlay)data;
            result.add(o);
        }
        return result;
    }
}

