/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;
import VolumeJ.VJRenderer;
import VolumeJ.VJUserInterface;
import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import volume.Volume;

public class VJRenderView
extends Thread {
    protected VJRenderer renderer;
    protected float rotx;
    protected float roty;
    protected float rotz;
    protected float scale;
    protected VJMatrix m;
    protected VJMatrix mLight;
    protected String message;
    protected String description;
    protected boolean running;

    public VJRenderView(VJRenderer renderer, String message) {
        super("Render shell");
        if (renderer == null) {
            IJ.error((String)"renderer not initialized!");
            return;
        }
        this.renderer = renderer;
        this.message = message;
        this.description = "" + message + " " + renderer.getClassifier().toString();
        this.description = this.description + " scale " + this.scale + renderer.getShader().toString() + renderer.getInterpolator();
        if (IJ.debugMode) {
            VJUserInterface.write("VJRenderView created");
        }
    }

    public VJRenderView(VJRenderer renderer, double scale, double rotx, double roty, double rotz, String message) {
        super("Render shell");
        if (renderer == null) {
            IJ.error((String)"renderer not initialized!");
            return;
        }
        this.renderer = renderer;
        this.message = message;
        this.scale = (float)scale;
        this.rotx = (float)rotx;
        this.roty = (float)roty;
        this.rotz = (float)rotz;
        this.description = "" + message + " " + renderer.getClassifier().toString();
        this.description = this.description + " scale " + scale + " rot " + rotx + "," + roty + "," + rotz;
        this.description = this.description + " " + renderer.getShader().toString() + renderer.getInterpolator();
    }

    protected void computeTransformationMatrix() {
        this.m = new VJMatrix();
        VJMatrix mm = new VJMatrix();
        mm.scale(this.scale, this.scale, this.scale);
        this.m.mul(mm);
        this.mLight = new VJMatrix(this.m);
        VJMatrix mAspects = new VJMatrix();
        mAspects.scale(this.renderer.getVolume().getAspectx(), this.renderer.getVolume().getAspecty(), this.renderer.getVolume().getAspectz());
        this.m.mul(mAspects);
        VJRenderView.center(this.m, this.renderer.getVolume());
        VJRenderView.center(this.mLight, this.renderer.getVolume());
        mm = new VJMatrix();
        mm.rotatex(this.rotx);
        this.m.mul(mm);
        this.mLight.mul(mm);
        mm = new VJMatrix();
        mm.rotatey(this.roty);
        this.m.mul(mm);
        this.mLight.mul(mm);
        mm = new VJMatrix();
        mm.rotatez(this.rotz);
        this.m.mul(mm);
        this.renderer.setTransformation(this.m, this.mLight);
        if (IJ.debugMode) {
            VJUserInterface.write("VJRenderView initial rotated: x=" + this.rotx + " y=" + this.roty + " z=" + this.rotz);
        }
        this.description = this.description + " aniso " + this.renderer.getVolume().getAspectx() + "x" + this.renderer.getVolume().getAspecty() + "x" + this.renderer.getVolume().getAspectz();
    }

    @Override
    public synchronized void run() {
    }

    protected ImageProcessor renderToImageProcessor() {
        ByteProcessor ip = null;
        Object pixels = this.renderToPixelArray();
        if (pixels instanceof byte[]) {
            ip = new ByteProcessor(this.renderer.getViewportWidth(), this.renderer.getViewportHeight(), (byte[])pixels, null);
        } else if (pixels instanceof int[]) {
            ip = new ColorProcessor(this.renderer.getViewportWidth(), this.renderer.getViewportHeight(), (int[])pixels);
        }
        if (pixels instanceof float[]) {
            ip = new FloatProcessor(this.renderer.getViewportWidth(), this.renderer.getViewportHeight(), (float[])pixels, null);
        }
        return ip;
    }

    protected Object renderToPixelArray() {
        try {
            Thread thread = new Thread(this.renderer);
            thread.setPriority(4);
            thread.start();
            thread.join();
            return this.renderer.getPixels();
        }
        catch (Exception e) {
            VJUserInterface.write("problems!" + e);
            return null;
        }
    }

    public void kill() {
        this.running = false;
        if (this.renderer instanceof VJRenderer) {
            this.renderer.kill();
        }
    }

    protected static void center(VJMatrix m, Volume v) {
        VJMatrix mt = new VJMatrix();
        mt.translate(-v.getWidth() / 2, -v.getHeight() / 2, -v.getDepth() / 2);
        m.mul(mt);
    }

    protected void report(long elapsedTime) {
        double seconds = (double)elapsedTime / 1000.0;
        long vxs = this.renderer.getVolume().getWidth() * this.renderer.getVolume().getHeight() * this.renderer.getVolume().getDepth();
        VJUserInterface.write("" + IJ.d2s((double)((double)vxs / seconds), (int)2) + "voxels/second");
    }

    protected long memoryInUse() {
        long freeMem = Runtime.getRuntime().freeMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        return totMem - freeMem;
    }

    @Override
    public String toString() {
        return this.description;
    }
}

