/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJAlphaColor;
import VolumeJ.VJClassifier;
import VolumeJ.VJClassifierLevoy;
import VolumeJ.VJCutout;
import VolumeJ.VJInterpolator;
import VolumeJ.VJLight;
import VolumeJ.VJMatrix;
import VolumeJ.VJShader;
import VolumeJ.VJUserInterface;
import VolumeJ.VJViewspaceUtil;
import volume.Volume;

public abstract class VJRenderer
extends Thread {
    protected static final int GRAYBYTE = 1;
    protected static final int COLORINT = 4;
    protected boolean doPerspective = false;
    protected boolean doDepthCueing = false;
    protected int outputType;
    protected double pixelms;
    protected int sequenceNumber;
    protected boolean running;
    protected VJMatrix m;
    protected VJMatrix mi;
    protected VJMatrix mLight;
    protected VJMatrix miLight;
    protected VJClassifier classifier;
    protected VJInterpolator interpolator;
    protected VJShader shader;
    protected Object pixels;
    protected VJCutout cutout;
    protected Volume v;
    protected int width;
    protected int height;
    protected int depth;
    protected int ioffset;
    protected int joffset;
    protected int koffset;
    protected String message;
    protected boolean doPixeltracing;
    protected int tracei;
    protected int tracej;
    protected String traceString;
    protected String description;

    public VJRenderer(VJInterpolator interpolator, VJShader shader, VJClassifier classifier) throws IllegalArgumentException {
        if (!(interpolator instanceof VJInterpolator && shader instanceof VJShader && classifier instanceof VJClassifier)) {
            throw new IllegalArgumentException("not proper parameters");
        }
        this.interpolator = interpolator;
        this.shader = shader;
        this.classifier = classifier;
        this.message = "";
        this.outputType = 1;
    }

    public int[] defaultViewport() {
        if (!(this.v instanceof Volume) || !(this.m instanceof VJMatrix)) {
            VJUserInterface.write("VJRenderer.defaultViewport error: volume and transformation  matrix need to be initialized.");
        }
        int[] vp = VJViewspaceUtil.suggestViewport(this.v, this.m);
        this.setViewport(vp[0], vp[1]);
        return vp;
    }

    public void setOutputColor() {
        this.outputType = 4;
    }

    public void setOutputGrayscale() {
        this.outputType = 1;
    }

    public void setViewport(int width, int height) {
        this.width = width;
        this.height = height;
        this.minmax();
    }

    protected Object newViewportBuffer() {
        this.pixels = this.outputType == 4 ? (Object)new int[this.width * this.height] : (Object)new byte[this.width * this.height];
        return this.pixels;
    }

    protected void setPixel(int pixel, int i, int j) {
        if (this.pixels instanceof byte[]) {
            ((byte[])this.pixels)[j * this.width + i] = (byte)pixel;
        } else {
            ((int[])this.pixels)[j * this.width + i] = pixel;
        }
    }

    protected void setPixel(VJAlphaColor pixel, int i, int j) {
        if (this.pixels instanceof byte[]) {
            ((byte[])this.pixels)[j * this.width + i] = (byte)((int)pixel.r & 0xFF);
        } else {
            int rvalue = pixel.getRed();
            int gvalue = pixel.getGreen();
            int bvalue = pixel.getBlue();
            ((int[])this.pixels)[j * this.width + i] = rvalue << 16 | gvalue << 8 | bvalue;
        }
    }

    public void setTransformation(VJMatrix m) {
        this.setTransformation(m, m);
    }

    public void setTransformation(VJMatrix m, VJMatrix mLight) {
        this.m = m;
        this.mLight = mLight;
        try {
            this.mi = m.inverse();
        }
        catch (Exception e) {
            VJUserInterface.error(e.toString());
        }
        this.miLight = mLight.inverse();
        if (this.classifier instanceof VJClassifierLevoy) {
            ((VJClassifierLevoy)this.classifier).setupOpacities(this.mi.getOversamplingRatio());
        }
        this.setShader(this.shader);
        if (this.width > 0 && this.height > 0) {
            this.minmax();
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setShader(VJShader shader) {
        this.shader = shader;
        if (shader.getLight() instanceof VJLight) {
            shader.getLight().objectify(this.miLight);
        }
    }

    protected void minmax() {
        int[][] minmax = VJViewspaceUtil.minmax(this.v, this.m);
        this.ioffset = (minmax[0][0] + minmax[1][0]) / 2 - this.width / 2;
        this.joffset = (minmax[0][1] + minmax[1][1]) / 2 - this.height / 2;
        this.koffset = minmax[0][2];
        this.depth = minmax[1][2] - minmax[0][2];
    }

    @Override
    public void run() {
    }

    public void kill() {
        this.running = false;
    }

    public void setVolume(Volume v) {
        this.v = v;
    }

    public Object getPixels() {
        if (this.pixels == null) {
            VJUserInterface.write("VJRenderer subclass error: pixels == null");
        }
        return this.pixels;
    }

    public int[] getViewport() {
        int[] vp = new int[]{this.width, this.height};
        return vp;
    }

    public int getViewportWidth() {
        return this.width;
    }

    public int getViewportHeight() {
        return this.height;
    }

    public Volume getVolume() {
        return this.v;
    }

    public VJMatrix getTransformation() {
        return this.m;
    }

    public void setInterpolator(VJInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public VJInterpolator getInterpolator() {
        return this.interpolator;
    }

    public void setClassifier(VJClassifier classifier) {
        this.classifier = classifier;
    }

    public VJClassifier getClassifier() {
        return this.classifier;
    }

    public VJShader getShader() {
        return this.shader;
    }

    public void setCutout(VJCutout cutout) {
        this.cutout = cutout;
    }

    public void trace(int i, int j) {
        this.doPixeltracing = true;
        this.tracei = i;
        this.tracej = j;
        this.traceString = "";
    }

    protected boolean onTrace(int i, int j) {
        return this.doPixeltracing && i == this.tracei && j == this.tracej;
    }

    protected void trace(String s) {
        this.traceString = this.traceString + s + "\n";
    }

    protected void traceWrite() {
        if (this.doPixeltracing && this.traceString.length() > 1) {
            VJUserInterface.write(this.traceString);
        }
        this.traceString = "";
    }

    public double getTimePerPixel() {
        return this.pixelms;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

