/*
 * Decompiled with CFR 0.152.
 */
package volume;

import volume.Kernel2D;

public class LoG
extends Kernel2D {
    private double sigma;

    public LoG(double sigma) {
        this.sigma = sigma;
        if (sigma != 0.0) {
            int width = (int)(6.0 * sigma + 1.0);
            if (width % 2 == 0) {
                ++width;
            }
            this.halfwidth = width / 2;
            this.k = new double[this.halfwidth * 2 + 1][this.halfwidth * 2 + 1];
            for (int m = -this.halfwidth; m <= this.halfwidth; ++m) {
                for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
                    this.k[m + this.halfwidth][l + this.halfwidth] = this.function(l, m);
                }
            }
        } else {
            this.halfwidth = 0;
        }
    }

    public double getSigma() {
        return this.sigma;
    }

    protected double function(double x, double y) {
        return -1.0 / (Math.PI * Math.pow(this.sigma, 4.0)) * (1.0 - (x * x + y * y) / (2.0 * this.sigma * this.sigma)) * Math.exp(-((x * x + y * y) / (2.0 * this.sigma * this.sigma)));
    }

    @Override
    public String toString() {
        return "Laplacian of Gaussian 2D " + this.sigma;
    }
}

