/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.retained;

import java.io.IOException;
import java.io.InputStream;
import org.jogamp.java3d.utils.scenegraph.io.retained.SGIORuntimeException;

class PositionInputStream
extends InputStream {
    private long pos = 0L;
    private InputStream stream;

    public PositionInputStream(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int s = this.stream.read(b);
        this.pos += (long)s;
        return s;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int s = this.stream.read(b, off, len);
        this.pos += (long)s;
        return s;
    }

    @Override
    public long skip(long n) throws IOException {
        long s = this.stream.skip(n);
        this.pos += s;
        return s;
    }

    public void seekForward(long position) throws IOException {
        if (this.pos > position) {
            throw new SGIORuntimeException("Seeking Backward " + this.pos + "  " + position);
        }
        this.stream.skip((int)(position - this.pos));
        this.pos = position;
    }

    public long getFilePointer() {
        return this.pos;
    }
}

