/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.util.ArrayList;
import org.jogamp.java3d.InputDevice;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigDevice;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.java3d.utils.universe.ConfigSensor;
import org.jogamp.vecmath.Matrix4d;

class ConfigPhysicalEnvironment
extends ConfigObject {
    PhysicalEnvironment j3dPhysicalEnvironment = null;
    Matrix4d coexistenceToTrackerBase = null;
    private ConfigSensor headTracker = null;
    private ArrayList inputDevices = new ArrayList();
    private int coexistenceCenterInPworldPolicy = 2;

    ConfigPhysicalEnvironment() {
    }

    @Override
    protected void initialize(ConfigCommand command) {
    }

    @Override
    protected void setProperty(ConfigCommand command) {
        Object[] argv = command.argv;
        int argc = command.argc;
        if (argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(argv[1])) {
            this.syntaxError("The first argument to " + command.commandName + " must be a name");
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be a property name");
        }
        String prop = (String)argv[2];
        Object val = argv[3];
        if (prop.equals("CoexistenceCenterInPworldPolicy")) {
            String sval;
            if (!(val instanceof String)) {
                this.syntaxError("CoexistenceCenterInPworldPolicy must be string");
            }
            if ((sval = (String)val).equals("NOMINAL_HEAD")) {
                this.coexistenceCenterInPworldPolicy = 0;
            } else if (sval.equals("NOMINAL_SCREEN")) {
                this.coexistenceCenterInPworldPolicy = 2;
            } else if (sval.equals("NOMINAL_FEET")) {
                this.coexistenceCenterInPworldPolicy = 1;
            } else {
                this.syntaxError("Illegal value " + sval + " for CoexistenceCenterInPworldPolicy");
            }
        } else if (prop.equals("CoexistenceToTrackerBase")) {
            if (val instanceof Matrix4d) {
                this.coexistenceToTrackerBase = (Matrix4d)val;
            } else {
                this.syntaxError("CoexistenceToTrackerBase must be a Matrix4d");
            }
        } else if (prop.equals("InputDevice")) {
            if (!(val instanceof String)) {
                this.syntaxError("InputDevice must be a name");
            }
            String sval = (String)val;
            this.inputDevices.add(this.configContainer.findConfigObject("Device", sval));
        } else if (prop.equals("HeadTracker")) {
            if (!(val instanceof String)) {
                this.syntaxError("HeadTracker must be a Sensor name");
            }
            String sval = (String)val;
            this.headTracker = (ConfigSensor)this.configContainer.findConfigObject("Sensor", sval);
        } else {
            this.syntaxError("Unknown " + command.commandName + " \"" + prop + "\"");
        }
    }

    PhysicalEnvironment createJ3dPhysicalEnvironment() {
        this.j3dPhysicalEnvironment = new PhysicalEnvironment();
        this.j3dPhysicalEnvironment.setCoexistenceCenterInPworldPolicy(this.coexistenceCenterInPworldPolicy);
        if (this.coexistenceToTrackerBase != null) {
            this.j3dPhysicalEnvironment.setCoexistenceToTrackerBase(new Transform3D(this.coexistenceToTrackerBase));
        }
        return this.j3dPhysicalEnvironment;
    }

    void processDevices() {
        for (int j = 0; j < this.inputDevices.size(); ++j) {
            ConfigDevice configDevice = (ConfigDevice)this.inputDevices.get(j);
            InputDevice device = configDevice.j3dInputDevice;
            this.j3dPhysicalEnvironment.addInputDevice(device);
        }
        if (this.headTracker != null) {
            this.j3dPhysicalEnvironment.setHeadIndex(0);
            this.j3dPhysicalEnvironment.setSensor(0, this.headTracker.j3dSensor);
        }
    }
}

