/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class ArcTanH
extends PostfixMathCommand {
    public ArcTanH() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.atanh(param));
    }

    public Object atanh(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).atanh();
        }
        if (param instanceof Number) {
            double val = ((Number)param).doubleValue();
            if (val > -1.0 && val < 1.0) {
                double res = Math.log((1.0 + val) / (1.0 - val)) / 2.0;
                return new Double(res);
            }
            Complex temp = new Complex(val, 0.0);
            return temp.atanh();
        }
        throw new ParseException("Invalid parameter type");
    }
}

