/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.lang.reflect.Method;
import org.scijava.launcher.ClassLoaders;
import org.scijava.launcher.Log;

public final class ReflectionUnlocker {
    private static Method addOpens;
    private static Method addExports;
    private static Method getPackages;

    private ReflectionUnlocker() {
    }

    public static void unlockAll() {
        if (addOpens == null) {
            return;
        }
        try {
            ClassLoader cl = Object.class.getClassLoader();
            Class<?> moduleLayerClass = ClassLoaders.loadClass(cl, "java.lang.ModuleLayer");
            Object moduleLayerBoot = moduleLayerClass.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            Method bootModules = moduleLayerBoot.getClass().getMethod("modules", new Class[0]);
            Iterable modules = (Iterable)bootModules.invoke(moduleLayerBoot, new Object[0]);
            modules.forEach(ReflectionUnlocker::unlockModule);
        }
        catch (Exception e) {
            Log.error("Failed to discover modules");
            Log.debug(e);
        }
    }

    private static void unlockModule(Object m) {
        try {
            for (String pkg : (Iterable)getPackages.invoke(m, new Object[0])) {
                try {
                    addOpens.invoke(m, pkg);
                    addExports.invoke(m, pkg);
                }
                catch (Exception e) {
                    Log.debug("Failed to unlock package: " + pkg);
                    Log.debug(e);
                }
            }
        }
        catch (Exception e) {
            Log.error("Failed to unlock module: " + m);
            Log.debug(e);
        }
    }

    static {
        try {
            ClassLoader cl = Object.class.getClassLoader();
            Class<?> moduleClass = ClassLoaders.loadClass(cl, "java.lang.Module");
            getPackages = moduleClass.getMethod("getPackages", new Class[0]);
            addOpens = moduleClass.getDeclaredMethod("implAddOpensToAllUnnamed", String.class);
            addOpens.setAccessible(true);
            addExports = moduleClass.getDeclaredMethod("implAddExportsToAllUnnamed", String.class);
            addExports.setAccessible(true);
        }
        catch (Exception e) {
            Log.debug("Failed to initialize ReflectionUnlocker");
            Log.debug(e);
        }
    }
}

