/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class Local_Thickness_Driver
implements PlugInFilter {
    private ImagePlus imp;
    public int thresh;
    public boolean inverse;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        String title = Local_Thickness_Driver.stripExtension(this.imp.getTitle());
        this.imp.unlock();
        if (!this.getScale()) {
            return;
        }
        if (this.inverse) {
            IJ.run((String)"Geometry to Distance Map", (String)("threshold=" + this.thresh + " inverse"));
        } else {
            IJ.run((String)"Geometry to Distance Map", (String)("threshold=" + this.thresh));
        }
        ImagePlus impDM = WindowManager.getCurrentImage();
        IJ.run((String)"Distance Map to Distance Ridge");
        ImagePlus impDR = WindowManager.getCurrentImage();
        impDM.hide();
        impDM.flush();
        WindowManager.setTempCurrentImage((ImagePlus)impDR);
        IJ.run((String)"Distance Ridge to Local Thickness");
        ImagePlus impLT = WindowManager.getCurrentImage();
        impDR.hide();
        impDR.flush();
        IJ.run((String)"Local Thickness to Cleaned-Up Local Thickness");
        ImagePlus impLTC = WindowManager.getCurrentImage();
        impLT.hide();
        impLT.flush();
        impLTC.setTitle(title + "_LocThk");
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Done");
    }

    static String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    boolean getScale() {
        this.thresh = (int)Prefs.get((String)"edtS1.thresh", (double)128.0);
        this.inverse = Prefs.get((String)"edtS1.inverse", (boolean)false);
        GenericDialog gd = new GenericDialog("EDT...", (Frame)IJ.getInstance());
        gd.addNumericField("Threshold (1 to 255; value < thresh is background)", (double)this.thresh, 0);
        gd.addCheckbox("Inverse case (background when value >= thresh)", this.inverse);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.thresh = (int)gd.getNextNumber();
        this.inverse = gd.getNextBoolean();
        Prefs.set((String)"edtS1.thresh", (int)this.thresh);
        Prefs.set((String)"edtS1.inverse", (boolean)this.inverse);
        return true;
    }
}

