/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Pixels;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;

final class MacRobot
extends GlassRobot {
    private long ptr;

    MacRobot() {
    }

    private native long _init();

    @Override
    public void create() {
        Application.checkEventThread();
        this.ptr = this._init();
    }

    private native void _destroy(long var1);

    @Override
    public void destroy() {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        this._destroy(this.ptr);
    }

    protected native void _keyPress(int var1);

    @Override
    public void keyPress(KeyCode keyCode) {
        Application.checkEventThread();
        this._keyPress(keyCode.getCode());
    }

    protected native void _keyRelease(int var1);

    @Override
    public void keyRelease(KeyCode keyCode) {
        Application.checkEventThread();
        this._keyRelease(keyCode.getCode());
    }

    private native void _mouseMove(long var1, float var3, float var4);

    @Override
    public void mouseMove(double d, double d2) {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        this._mouseMove(this.ptr, (float)d, (float)d2);
    }

    private native void _mousePress(long var1, int var3);

    @Override
    public void mousePress(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        this._mousePress(this.ptr, GlassRobot.convertToRobotMouseButton(mouseButtonArray));
    }

    private native void _mouseRelease(long var1, int var3);

    @Override
    public void mouseRelease(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        this._mouseRelease(this.ptr, GlassRobot.convertToRobotMouseButton(mouseButtonArray));
    }

    protected native void _mouseWheel(int var1);

    @Override
    public void mouseWheel(int n) {
        Application.checkEventThread();
        this._mouseWheel(n);
    }

    private native float _getMouseX(long var1);

    @Override
    public double getMouseX() {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return 0.0;
        }
        return this._getMouseX(this.ptr);
    }

    private native float _getMouseY(long var1);

    @Override
    public double getMouseY() {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return 0.0;
        }
        return this._getMouseY(this.ptr);
    }

    protected native int _getPixelColor(double var1, double var3);

    @Override
    public Color getPixelColor(double d, double d2) {
        Application.checkEventThread();
        return GlassRobot.convertFromIntArgb(this._getPixelColor(d, d2));
    }

    protected native Pixels _getScreenCapture(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public WritableImage getScreenCapture(WritableImage writableImage, double d, double d2, double d3, double d4, boolean bl) {
        Application.checkEventThread();
        int n = (int)d3;
        int n2 = (int)d4;
        if (n <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (n >= Integer.MAX_VALUE / n2) {
            throw new IllegalArgumentException("invalid capture size");
        }
        Pixels pixels = this._getScreenCapture((int)d, (int)d2, n, n2, bl);
        return MacRobot.convertFromPixels(writableImage, pixels);
    }
}

