/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localization;

import net.imglib2.algorithm.localization.FitFunction;

public class Gaussian
implements FitFunction {
    public String toString() {
        return "Gaussian function A \u00d7 exp( -b \u00d7 \u2211 (x\u1d62 - x\u2080\u1d62)\u00b2 )";
    }

    @Override
    public final double val(double[] x, double[] a) {
        return a[a.length - 2] * Gaussian.E(x, a);
    }

    @Override
    public final double grad(double[] x, double[] a, int k) {
        int ndims = x.length;
        if (k == a.length - 2) {
            return Gaussian.E(x, a);
        }
        if (k < ndims) {
            int dim = k;
            return 2.0 * a[a.length - 1] * (x[dim] - a[dim]) * a[a.length - 2] * Gaussian.E(x, a);
        }
        double d = 0.0;
        for (int i = 0; i < ndims; ++i) {
            double si = x[i] - a[i];
            d += si * si;
        }
        return -d * a[a.length - 2] * Gaussian.E(x, a);
    }

    @Override
    public final double hessian(double[] x, double[] a, int rIn, int cIn) {
        int c = cIn;
        int r = rIn;
        if (c < r) {
            int tmp = c;
            c = r;
            r = tmp;
        }
        int ndims = x.length;
        if (c == r) {
            if (c < ndims) {
                int dim = c;
                double di = x[dim] - a[dim];
                return 2.0 * a[a.length - 2] * a[a.length - 1] * (2.0 * a[a.length - 1] * di * di - 1.0) * Gaussian.E(x, a);
            }
            if (c == a.length - 2) {
                return 0.0;
            }
            return a[a.length - 2] * Gaussian.E(x, a) * Gaussian.S(x, a) * Gaussian.S(x, a) / a[a.length - 1] / a[a.length - 1];
        }
        if (c < ndims && r < ndims) {
            int i = c;
            int j = r;
            double di = x[i] - a[i];
            double dj = x[j] - a[j];
            return 4.0 * a[a.length - 2] * a[a.length - 1] * a[a.length - 1] * di * dj * Gaussian.E(x, a);
        }
        if (c == a.length - 2) {
            int dim = r;
            return 2.0 * a[a.length - 1] * (x[dim] - a[dim]) * Gaussian.E(x, a);
        }
        if (r == a.length - 2) {
            return -Gaussian.S(x, a) * Gaussian.E(x, a) / a[a.length - 1];
        }
        int i = r;
        return 2.0 * a[a.length - 2] * (x[i] - a[i]) * Gaussian.E(x, a) * (1.0 - Gaussian.S(x, a));
    }

    private static final double S(double[] x, double[] a) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double di = x[i] - a[i];
            sum += di * di;
        }
        return a[a.length - 1] * sum;
    }

    private static final double E(double[] x, double[] a) {
        return Math.exp(-Gaussian.S(x, a));
    }
}

