/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.pde.ExplicitDiffusionScheme;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public abstract class ExplicitDiffusionScheme2D<T extends RealType<T>>
extends ExplicitDiffusionScheme<T> {
    private static final String BASE_ERROR_MESSAGE = "[" + ExplicitDiffusionScheme2D.class.getSimpleName() + "] ";

    public ExplicitDiffusionScheme2D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D) {
        super(input, D);
    }

    public ExplicitDiffusionScheme2D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory) {
        super(input, D, imgFactory);
    }

    @Override
    protected abstract float diffusionScheme(float[] var1, float[][] var2);

    @Override
    public boolean checkInput() {
        if (null == this.input) {
            this.errorMessage = BASE_ERROR_MESSAGE + "The input image is null.";
            return false;
        }
        if (null == this.D) {
            this.errorMessage = BASE_ERROR_MESSAGE + "The diffusion tensor is null.";
            return false;
        }
        if (this.D.numDimensions() + 1 != this.input.numDimensions()) {
            this.errorMessage = BASE_ERROR_MESSAGE + "The diffusion tensor is expected to have " + this.input.numDimensions() + " dimension, but has " + this.D.numDimensions() + ".";
            return false;
        }
        for (int i = 0; i < this.input.numDimensions(); ++i) {
            if (this.D.dimension(i) == this.input.dimension(i)) continue;
            this.errorMessage = BASE_ERROR_MESSAGE + "Dimension " + i + " of the diffusion tensor is of size " + this.D.dimension(i) + ", expected " + this.input.dimension(i) + ".";
            return false;
        }
        return true;
    }

    @Override
    protected float[] initDensityArray() {
        return new float[9];
    }

    @Override
    protected float[][] initDiffusionTensorArray() {
        return new float[3][9];
    }

    @Override
    protected final void yieldDensity(RandomAccess<T> ura, float[] target) {
        target[0] = ((RealType)ura.get()).getRealFloat();
        ura.bck(1);
        target[1] = ((RealType)ura.get()).getRealFloat();
        ura.fwd(0);
        target[2] = ((RealType)ura.get()).getRealFloat();
        ura.fwd(1);
        target[3] = ((RealType)ura.get()).getRealFloat();
        ura.fwd(1);
        target[4] = ((RealType)ura.get()).getRealFloat();
        ura.bck(0);
        target[5] = ((RealType)ura.get()).getRealFloat();
        ura.bck(0);
        target[6] = ((RealType)ura.get()).getRealFloat();
        ura.bck(1);
        target[7] = ((RealType)ura.get()).getRealFloat();
        ura.bck(1);
        target[8] = ((RealType)ura.get()).getRealFloat();
    }

    @Override
    protected final void yieldDiffusionTensor(RandomAccess<FloatType> dra, float[][] target) {
        dra.setPosition(0, this.tensorComponentDimension);
        target[0][0] = ((FloatType)dra.get()).get();
        dra.fwd(2);
        target[1][0] = ((FloatType)dra.get()).get();
        dra.fwd(2);
        target[2][0] = ((FloatType)dra.get()).get();
        dra.bck(1);
        dra.setPosition(1, this.tensorComponentDimension);
        target[1][1] = ((FloatType)dra.get()).get();
        dra.fwd(2);
        target[2][1] = ((FloatType)dra.get()).get();
        dra.fwd(0);
        dra.setPosition(1, this.tensorComponentDimension);
        target[1][2] = ((FloatType)dra.get()).get();
        dra.fwd(1);
        dra.setPosition(0, this.tensorComponentDimension);
        target[0][1] = ((FloatType)dra.get()).get();
        dra.fwd(2);
        target[1][3] = ((FloatType)dra.get()).get();
        dra.fwd(1);
        dra.setPosition(1, this.tensorComponentDimension);
        target[1][4] = ((FloatType)dra.get()).get();
        dra.bck(0);
        dra.setPosition(1, this.tensorComponentDimension);
        target[1][5] = ((FloatType)dra.get()).get();
        dra.fwd(2);
        target[2][2] = ((FloatType)dra.get()).get();
        dra.bck(0);
        dra.setPosition(1, this.tensorComponentDimension);
        target[1][6] = ((FloatType)dra.get()).get();
        dra.bck(1);
        dra.setPosition(0, this.tensorComponentDimension);
        target[0][2] = ((FloatType)dra.get()).get();
        dra.fwd(2);
        target[1][7] = ((FloatType)dra.get()).get();
        dra.bck(1);
        dra.setPosition(1, this.tensorComponentDimension);
        target[1][8] = ((FloatType)dra.get()).get();
    }
}

