/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import stitching.CommonFunctions;
import stitching.utils.Log;

public class Stitch_Many_Images
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/preibisch";
    private final String paperURL = "http://bioinformatics.oxfordjournals.org/cgi/content/abstract/btp184";
    public static int stitchingType = 0;
    final String[] stichingTypes = new String[]{"Stitch_grid of images (different files in one directory)", "Stitch_all_images in one directory (unknown configuration, test all possiblities)", "Stitch_series of images in one file (including the stage coordinates from the microscope)", "Stitch_collection of images (defined by a configuration file)"};
    final String[] extraExplanations = new String[]{"Please select the type of stitching you want to perform"};
    final int numStitchingTypes = this.stichingTypes.length;
    public static String fileNameStatic = "TileConfiguration.txt";
    public static boolean computeOverlapStatic = true;
    public static String handleRGBStatic = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String rgbOrderStatic = CommonFunctions.rgbTypes[0];
    public static String fusionMethodStatic = CommonFunctions.methodListCollection[1];
    public static double alphaStatic = 1.5;
    public static double thresholdRStatic = 0.3;
    public static double thresholdDisplacementRelativeStatic = 2.5;
    public static double thresholdDisplacementAbsoluteStatic = 3.5;
    public static boolean previewOnlyStatic = false;

    public void run(String arg0) {
        GenericDialog gd = new GenericDialog("Stitching of Many Images (2d/3d)");
        boolean[] defaultState = new boolean[this.numStitchingTypes];
        defaultState[Stitch_Many_Images.stitchingType] = true;
        gd.addCheckboxGroup(this.numStitchingTypes, 1, this.stichingTypes, defaultState, this.extraExplanations);
        Vector checkBoxes = gd.getCheckboxes();
        for (Object o : checkBoxes) {
            ((Checkbox)o).addItemListener(new IntroItemListener((Checkbox)o, checkBoxes));
        }
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.addMessage("Please note that the Stitching is based on a publication.\nIf you use it successfully for your research please be so kind to cite our work:\nPreibisch et al., Bioinformatics (2009), 25(11):1463-1465\n");
        text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://bioinformatics.oxfordjournals.org/cgi/content/abstract/btp184");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int result = 0;
        for (int i = 0; i < this.numStitchingTypes; ++i) {
            if (!gd.getNextBoolean()) continue;
            result = i;
        }
        Log.info("You selected " + this.stichingTypes[result]);
        stitchingType = result;
        switch (result) {
            case 0: {
                this.stitchGrid();
                break;
            }
            case 1: {
                this.stitchDirectory();
                break;
            }
            case 2: {
                this.stitchMultiSeriesFile();
                break;
            }
            case 3: {
                this.stitchCollection();
                break;
            }
        }
    }

    public void stitchGrid() {
    }

    public void stitchDirectory() {
    }

    public void stitchMultiSeriesFile() {
    }

    public void stitchCollection() {
        boolean previewOnly;
        double thresholdDisplacementAbsolute;
        double thresholdDisplacementRelative;
        double thresholdR;
        double alpha;
        String fusionMethod;
        String rgbOrder;
        String handleRGB;
        boolean computeOverlap;
        String fileName;
        GenericDialogPlus gd = new GenericDialogPlus("Stitch Image Collection");
        gd.addFileField("Layout file", fileNameStatic, 50);
        gd.addCheckbox("compute_overlap (otherwise use the coordinates given in the layout file)", computeOverlapStatic);
        gd.addChoice("Channels_for_Registration", CommonFunctions.colorList, handleRGBStatic);
        gd.addChoice("rgb_order", CommonFunctions.rgbTypes, rgbOrderStatic);
        gd.addChoice("Fusion_Method", CommonFunctions.methodListCollection, CommonFunctions.methodListCollection[1]);
        gd.addNumericField("Fusion alpha", alphaStatic, 2);
        gd.addNumericField("Regression Threshold", thresholdRStatic, 2);
        gd.addNumericField("Max/Avg Displacement Threshold", thresholdDisplacementRelativeStatic, 2);
        gd.addNumericField("Absolute Avg Displacement Threshold", thresholdDisplacementAbsoluteStatic, 2);
        gd.addCheckbox("Create_only_Preview", previewOnlyStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        fileNameStatic = fileName = gd.getNextString();
        computeOverlapStatic = computeOverlap = gd.getNextBoolean();
        handleRGBStatic = handleRGB = gd.getNextChoice();
        rgbOrderStatic = rgbOrder = gd.getNextChoice();
        fusionMethodStatic = fusionMethod = gd.getNextChoice();
        alphaStatic = alpha = gd.getNextNumber();
        thresholdRStatic = thresholdR = gd.getNextNumber();
        thresholdDisplacementRelativeStatic = thresholdDisplacementRelative = gd.getNextNumber();
        thresholdDisplacementAbsoluteStatic = thresholdDisplacementAbsolute = gd.getNextNumber();
        previewOnlyStatic = previewOnly = gd.getNextBoolean();
        this.runStitching();
    }

    protected void runStitching() {
    }

    protected class IntroItemListener
    implements ItemListener {
        final Checkbox checkbox;
        final Vector<?> checkboxes;

        public IntroItemListener(Checkbox checkbox, Vector<?> checkboxes) {
            this.checkboxes = checkboxes;
            this.checkbox = checkbox;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 2) {
                this.checkbox.setState(true);
            } else if (event.getStateChange() == 1) {
                for (Object o : this.checkboxes) {
                    if (o == this.checkbox) {
                        ((Checkbox)o).setState(true);
                        continue;
                    }
                    ((Checkbox)o).setState(false);
                }
            }
        }
    }
}

