/*
 * Decompiled with CFR 0.152.
 */
package fiji.analyze.directionality;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.filter.Convolver;
import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Directionality_
implements PlugIn {
    private static final float FREQ_THRESHOLD = 5.0f;
    private static final double SIGMA_NUMBER = 2.0;
    private static final String PLUGIN_NAME = "Directionality analysis";
    private static final String VERSION_STR = "2.3.0";
    private static boolean setting_debug = false;
    private static int setting_nbins = 90;
    private static double setting_bin_start = -90.0;
    private static double setting_bin_end = 90.0;
    private static AnalysisMethod setting_method = AnalysisMethod.FOURIER_COMPONENTS;
    private static boolean setting_display_table = false;
    private static boolean setting_build_orientation_map = false;
    private static boolean setting_display_color_wheel = false;
    protected ImagePlus imp;
    protected boolean debug = false;
    protected int nbins = 90;
    private double bin_start = -90.0;
    private double bin_end = 90.0;
    private AnalysisMethod method = AnalysisMethod.FOURIER_COMPONENTS;
    private boolean display_table = false;
    private boolean build_orientation_map = false;
    private boolean display_color_wheel = false;
    private FloatProcessor fip;
    protected ImageStack filters;
    protected FloatProcessor window;
    protected FloatProcessor r;
    protected FloatProcessor theta;
    protected int width;
    protected int height;
    protected int small_side;
    protected int long_side;
    protected int npady;
    protected int npadx;
    protected int step;
    protected int pad_size;
    protected double[] bins;
    protected ArrayList<double[]> histograms;
    private FloatProcessor padded_square_block;
    private float[] window_pixels;
    protected ArrayList<double[]> params_from_fit;
    protected double[] goodness_of_fit;
    protected String fit_string;
    private int slice_index;
    ImageStack orientation_map;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (null == this.imp) {
            IJ.error((String)"Directionality", (String)"No images are open.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (null != roi) {
            this.imp = new Duplicator().run(this.imp, 1, this.imp.getNSlices());
        }
        if (null != arg && arg.length() > 0) {
            boolean endIsSpecified = false;
            String str = Directionality_.parseArgumentString(arg, "nbins=");
            if (null != str) {
                try {
                    this.nbins = Integer.parseInt(str);
                }
                catch (NumberFormatException nfe) {
                    IJ.error((String)("Directionality: bad argument for number of bins: " + str));
                    return;
                }
            }
            if (null != (str = Directionality_.parseArgumentString(arg, "start="))) {
                try {
                    this.bin_start = Double.parseDouble(str);
                }
                catch (NumberFormatException nfe) {
                    IJ.error((String)("Directionality: bad argument for start point: " + str));
                    return;
                }
            }
            if (null != (str = Directionality_.parseArgumentString(arg, "end="))) {
                try {
                    this.bin_end = Double.parseDouble(str);
                    endIsSpecified = true;
                }
                catch (NumberFormatException nfe) {
                    IJ.error((String)("Directionality: bad argument for end point: " + str));
                    return;
                }
            }
            if (null != (str = Directionality_.parseArgumentString(arg, "method="))) {
                for (AnalysisMethod m : AnalysisMethod.values()) {
                    if (!m.toCommandName().equalsIgnoreCase(str)) continue;
                    this.method = m;
                }
            }
            if (!endIsSpecified) {
                this.bin_end = this.bin_start + 180.0;
            }
        } else {
            boolean userHasCanceled = this.showDialog();
            if (userHasCanceled) {
                return;
            }
        }
        this.bin_end = Math.min(this.bin_end, this.bin_start + 180.0);
        this.computeHistograms();
        this.fitHistograms();
        JFrame plot_frame = this.plotResults();
        JFrame data_frame = this.displayFitAnalysis();
        plot_frame.setLocationRelativeTo((Component)this.imp.getWindow());
        data_frame.setLocationRelativeTo(plot_frame);
        plot_frame.setVisible(true);
        data_frame.setVisible(true);
        if (this.display_table) {
            ResultsTable table = this.displayResultsTable();
            table.show("Directionality histograms for " + this.imp.getShortTitle() + " (using " + this.method.toString() + ")");
        }
        if (this.build_orientation_map) {
            ImagePlus imp_map = new ImagePlus("Orientation map for " + this.imp.getShortTitle(), this.orientation_map);
            imp_map.show();
            ImageCanvas canvas_map = imp_map.getCanvas();
            Directionality_.addColorMouseListener(canvas_map, this.bin_start, this.bin_end);
        }
        if (this.display_color_wheel) {
            ImagePlus cw = Directionality_.generateColorWheel(this.bin_start, this.bin_end);
            cw.show();
            ImageCanvas canvas_cw = cw.getCanvas();
            Directionality_.addColorMouseListener(canvas_cw, this.bin_start, this.bin_end);
        }
    }

    public void computeHistograms() {
        if (null == this.imp) {
            return;
        }
        this.params_from_fit = null;
        this.goodness_of_fit = null;
        this.bins = Directionality_.prepareBins(this.nbins, this.bin_start, this.bin_end);
        switch (this.method) {
            case FOURIER_COMPONENTS: {
                this.initFourierFields();
                break;
            }
        }
        int n_slices = this.imp.getStackSize();
        this.histograms = new ArrayList(n_slices * this.imp.getNChannels());
        if (this.build_orientation_map) {
            this.orientation_map = new ImageStack(this.imp.getWidth(), this.imp.getHeight());
        }
        ImageProcessor ip = null;
        double[] dir = null;
        for (int i = 0; i < n_slices; ++i) {
            this.slice_index = i;
            ip = this.imp.getStack().getProcessor(i + 1);
            for (int channel_number = 0; channel_number < ip.getNChannels(); ++channel_number) {
                int j;
                this.fip = ip.toFloat(channel_number, this.fip);
                switch (this.method) {
                    case FOURIER_COMPONENTS: {
                        dir = this.fourier_component(this.fip);
                        break;
                    }
                    case LOCAL_GRADIENT_ORIENTATION: {
                        dir = this.local_gradient_orientation(this.fip);
                    }
                }
                void sum = dir[0];
                for (j = 1; j < dir.length; ++j) {
                    sum += dir[j];
                }
                for (j = 0; j < dir.length; ++j) {
                    dir[j] = dir[j] / sum;
                }
                this.histograms.add(dir);
            }
        }
    }

    public ResultsTable displayResultsTable() {
        if (null == this.histograms) {
            return null;
        }
        ResultsTable table = new ResultsTable();
        table.setPrecision(9);
        String[] names = this.makeNames();
        for (int i = 0; i < this.bins.length; ++i) {
            table.incrementCounter();
            table.addValue("Direction (\u00b0)", Math.toDegrees(this.bins[i]));
            for (int j = 0; j < names.length; ++j) {
                double[] dir = this.histograms.get(j);
                table.addValue(names[j], dir[i]);
                double val = CurveFitter.f((int)12, (double[])this.params_from_fit.get(j), (double)this.bins[i]);
                table.addValue(names[j] + "-fit", val);
            }
        }
        return table;
    }

    public ArrayList<double[]> getFitAnalysis() {
        if (null == this.histograms) {
            return null;
        }
        ArrayList<double[]> fit_analysis = new ArrayList<double[]>(this.histograms.size());
        double[] gof = this.getGoodnessOfFit();
        double[] params = null;
        double[] dir = null;
        double[] analysis = null;
        for (int i = 0; i < this.histograms.size(); ++i) {
            params = this.params_from_fit.get(i);
            dir = this.histograms.get(i);
            analysis = new double[4];
            double amount = 0.0;
            double center = params[2];
            double std = params[3];
            for (int j = 0; j < dir.length; ++j) {
                double xn = this.bins[j];
                if (Math.abs(xn - center) > 90.0) {
                    xn = xn > center ? (xn -= 180.0) : (xn += 180.0);
                }
                if (xn < center - 2.0 * std || xn > center + 2.0 * std) continue;
                amount += dir[j];
            }
            analysis[0] = center;
            analysis[1] = std;
            analysis[2] = amount;
            analysis[3] = gof[i];
            fit_analysis.add(analysis);
        }
        return fit_analysis;
    }

    public JFrame plotResults() {
        float color_index;
        XYSeriesCollection histogram_plots = new XYSeriesCollection();
        LookupPaintScale lut = Directionality_.createLUT(this.histograms.size());
        String[] names = this.makeNames();
        double[] degrees_bins = new double[this.nbins];
        for (int i = 0; i < degrees_bins.length; ++i) {
            degrees_bins[i] = Math.toDegrees(this.bins[i]);
        }
        for (int i = 0; i < this.histograms.size(); ++i) {
            double[] dir = this.histograms.get(i);
            XYSeries series = new XYSeries((Comparable)((Object)names[i]));
            for (int j = 0; j < this.nbins; ++j) {
                series.add(degrees_bins[j], dir[j]);
            }
            histogram_plots.addSeries(series);
        }
        histogram_plots.setIntervalWidth(Math.toDegrees(this.bins[1] - this.bins[0]));
        JFreeChart chart = ChartFactory.createHistogram((String)"Directionality histograms", (String)"Direction (\u00b0)", (String)"Amount", (IntervalXYDataset)histogram_plots, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        ClusteredXYBarRenderer renderer = new ClusteredXYBarRenderer(0.3, false);
        for (int i = 0; i < this.histograms.size(); ++i) {
            color_index = (float)i / (float)(this.histograms.size() - 1);
            renderer.setSeriesPaint(i, lut.getPaint((double)color_index));
        }
        plot.setRenderer(0, (XYItemRenderer)renderer);
        if (null != this.params_from_fit) {
            int i;
            double[] X = new double[this.bins.length * 10];
            for (int i2 = 0; i2 < X.length; ++i2) {
                X[i2] = degrees_bins[0] + (degrees_bins[this.nbins - 1] - degrees_bins[0]) / (double)X.length * (double)i2;
            }
            XYSeriesCollection fits = new XYSeriesCollection();
            for (i = 0; i < this.histograms.size(); ++i) {
                double[] params = (double[])this.params_from_fit.get(i).clone();
                XYSeries fit_series = new XYSeries((Comparable)((Object)names[i]));
                for (int j = 0; j < X.length; ++j) {
                    double xn = Math.toRadians(X[j]);
                    double val = CurveFitter.f((int)12, (double[])params, (double)xn);
                    fit_series.add(X[j], val);
                }
                fits.addSeries(fit_series);
            }
            plot.setDataset(1, (XYDataset)fits);
            plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            for (i = 0; i < this.histograms.size(); ++i) {
                color_index = (float)i / (float)(this.histograms.size() - 1);
                plot.getRenderer(1).setSeriesPaint(i, lut.getPaint((double)color_index));
            }
        }
        plot.getDomainAxis().setRange(degrees_bins[0], degrees_bins[this.nbins - 1]);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        JFrame window = new JFrame("Directionality for " + this.imp.getShortTitle() + " (using " + this.method.toString() + ")");
        window.add((Component)chartPanel);
        window.validate();
        window.setSize(new Dimension(500, 270));
        return window;
    }

    public void fitHistograms() {
        if (null == this.histograms) {
            return;
        }
        this.params_from_fit = new ArrayList(this.histograms.size());
        this.goodness_of_fit = new double[this.histograms.size()];
        double[] init_params = new double[4];
        double[] params = new double[4];
        CurveFitter fitter = null;
        for (int i = 0; i < this.histograms.size(); ++i) {
            double[] dir = this.histograms.get(i);
            double ymax = Double.NEGATIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            int imax = 0;
            for (int j = 0; j < dir.length; ++j) {
                if (dir[j] > ymax) {
                    ymax = dir[j];
                    imax = j;
                }
                if (!(dir[j] < ymin)) continue;
                ymin = dir[j];
            }
            fitter = new CurveFitter(this.bins, dir);
            init_params[0] = ymin;
            init_params[1] = ymax;
            init_params[2] = this.bins[imax];
            init_params[3] = 2.0 * (this.bins[1] - this.bins[0]);
            fitter.doFit(12);
            params = fitter.getParams();
            this.goodness_of_fit[i] = fitter.getFitGoodness();
            params[3] = Math.abs(params[3]);
            this.params_from_fit.add(params);
        }
        this.fit_string = fitter.getFormula();
    }

    public JFrame displayFitAnalysis() {
        if (null == this.params_from_fit) {
            return null;
        }
        Object[] column_names = new String[]{"Slice", "Direction (\u00b0)", "Dispersion (\u00b0)", "Amount", "Goodness"};
        Object[][] table_data = new Object[this.params_from_fit.size()][column_names.length];
        String[] names = this.makeNames();
        ArrayList<double[]> fit_analysis = this.getFitAnalysis();
        double[] analysis = null;
        for (int i = 0; i < table_data.length; ++i) {
            analysis = fit_analysis.get(i);
            table_data[i][0] = names[i];
            table_data[i][1] = String.format("%.2f", Math.toDegrees(analysis[0]));
            table_data[i][2] = String.format("%.2f", Math.toDegrees(analysis[1]));
            table_data[i][3] = String.format("%.2f", analysis[2]);
            table_data[i][4] = String.format("%.2f", analysis[3]);
        }
        JTable table = new JTable(table_data, column_names);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPane = new JScrollPane(table);
        table.setAutoResizeMode(4);
        JPanel table_panel = new JPanel(new GridLayout());
        table_panel.add(scrollPane);
        JFrame frame = new JFrame("Directionality analysis for " + this.imp.getShortTitle() + " (using " + this.method.toString() + ")");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(table_panel);
        frame.pack();
        return frame;
    }

    public void setImagePlus(ImagePlus imp) {
        this.imp = imp;
        this.histograms = null;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public ArrayList<double[]> getFitParameters() {
        if (null == this.params_from_fit) {
            this.fitHistograms();
        }
        return this.params_from_fit;
    }

    public double[] getGoodnessOfFit() {
        if (null == this.params_from_fit) {
            this.fitHistograms();
        }
        return this.goodness_of_fit;
    }

    public ArrayList<double[]> getHistograms() {
        return this.histograms;
    }

    public double[] getBins() {
        double[] degree_bins = new double[this.nbins];
        for (int i = 0; i < degree_bins.length; ++i) {
            degree_bins[i] = 180.0 * this.bins[i] / Math.PI;
        }
        return degree_bins;
    }

    public void setBinNumber(int nbins) {
        this.nbins = nbins;
        this.histograms = null;
    }

    public int getBinNumber() {
        return this.nbins;
    }

    public void setBinStart(double bin_start) {
        this.bin_start = bin_start;
        this.bin_end = bin_start + 180.0;
        this.histograms = null;
    }

    public double getBinStart() {
        return this.bin_start;
    }

    public void setBinRange(double bin_start, double bin_end) {
        this.bin_start = bin_start;
        this.bin_end = Math.min(bin_end, bin_start + 180.0);
        this.histograms = null;
    }

    public double getBinEnd() {
        return this.bin_end;
    }

    public void setMethod(AnalysisMethod method) {
        this.method = method;
        this.histograms = null;
    }

    public AnalysisMethod getMethod() {
        return this.method;
    }

    public void setDebugFlag(boolean flag) {
        this.debug = flag;
    }

    public void setBuildOrientationMapFlag(boolean flag) {
        this.build_orientation_map = flag;
    }

    public ImageStack getOrientationMap() {
        return this.orientation_map;
    }

    private boolean showDialog() {
        String current = this.imp.getTitle();
        String[] method_names = new String[AnalysisMethod.values().length];
        for (int i = 0; i < method_names.length; ++i) {
            method_names[i] = AnalysisMethod.values()[i].toString();
        }
        GenericDialog gd = new GenericDialog("Directionality analysis v2.3.0");
        gd.addMessage(current);
        gd.addChoice("Method:", method_names, setting_method.toString());
        gd.addNumericField("Nbins: ", (double)setting_nbins, 0);
        gd.addNumericField("Histogram_start", setting_bin_start, 0, 4, "\u00b0");
        gd.addNumericField("Histogram_end", setting_bin_end, 0, 4, "\u00b0");
        gd.addCheckbox("Build orientation map", setting_build_orientation_map);
        gd.addCheckbox("Display_color_wheel", setting_display_color_wheel);
        gd.addCheckbox("Display_table", setting_display_table);
        gd.addCheckbox("Debug", setting_debug);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return true;
        }
        String chosen_method = gd.getNextChoice();
        for (int i = 0; i < method_names.length; ++i) {
            if (!chosen_method.equals(method_names[i])) continue;
            this.method = AnalysisMethod.values()[i];
            break;
        }
        setting_method = this.method;
        this.nbins = (int)gd.getNextNumber();
        this.bin_start = gd.getNextNumber();
        this.bin_end = gd.getNextNumber();
        this.build_orientation_map = gd.getNextBoolean();
        this.display_color_wheel = gd.getNextBoolean();
        this.display_table = gd.getNextBoolean();
        this.debug = gd.getNextBoolean();
        setting_nbins = this.nbins;
        setting_bin_start = this.bin_start;
        setting_bin_end = this.bin_end;
        setting_build_orientation_map = this.build_orientation_map;
        setting_display_color_wheel = this.display_color_wheel;
        setting_display_table = this.display_table;
        setting_debug = this.debug;
        return false;
    }

    private void initFourierFields() {
        if (null == this.imp) {
            return;
        }
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (this.width == this.height) {
            this.npadx = 1;
            this.npady = 1;
            this.long_side = this.width;
            this.small_side = this.width;
            this.step = 0;
        } else {
            this.small_side = Math.min(this.width, this.height);
            this.long_side = Math.max(this.width, this.height);
            int npad = this.long_side / this.small_side + 1;
            if (this.width == this.long_side) {
                this.npadx = npad;
                this.npady = 1;
            } else {
                this.npadx = 1;
                this.npady = npad;
            }
            int delta = this.long_side - this.small_side;
            this.step = delta / (npad - 1);
        }
        this.pad_size = 2;
        while (this.pad_size < this.small_side) {
            this.pad_size *= 2;
        }
        this.padded_square_block = new FloatProcessor(this.pad_size, this.pad_size);
        this.window = Directionality_.getBlackmanProcessor(this.small_side, this.small_side);
        this.window_pixels = (float[])this.window.getPixels();
        this.r = Directionality_.makeRMatrix(this.pad_size, this.pad_size);
        this.theta = Directionality_.makeThetaMatrix(this.pad_size, this.pad_size);
        this.filters = this.makeFftFilters();
        if (this.debug) {
            new ImagePlus("Angular filters", this.filters).show();
        }
    }

    private final double[] local_gradient_orientation(FloatProcessor ip) {
        double range2_max;
        double range2_min;
        double range1_max;
        double range1_min;
        double[] norm_dir = new double[this.nbins];
        FloatProcessor grad_x = (FloatProcessor)ip.duplicate();
        FloatProcessor grad_y = (FloatProcessor)ip.duplicate();
        Convolver convolver = new Convolver();
        float[] kernel_y = new float[]{-5.0f, -4.0f, 0.0f, 4.0f, 5.0f, -8.0f, -10.0f, 0.0f, 10.0f, 8.0f, -10.0f, -20.0f, 0.0f, 20.0f, 10.0f, -8.0f, -10.0f, 0.0f, 10.0f, 8.0f, -5.0f, -4.0f, 0.0f, 4.0f, 5.0f};
        float[] kernel_x = new float[]{5.0f, 8.0f, 10.0f, 8.0f, 5.0f, 4.0f, 10.0f, 20.0f, 10.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -4.0f, -10.0f, -20.0f, -10.0f, -4.0f, -5.0f, -8.0f, -10.0f, -8.0f, -5.0f};
        convolver.convolveFloat((ImageProcessor)grad_x, kernel_x, 5, 5);
        convolver.convolveFloat((ImageProcessor)grad_y, kernel_y, 5, 5);
        float[] pixels_gx = (float[])grad_x.getPixels();
        float[] pixels_gy = (float[])grad_y.getPixels();
        float[] pixels_theta = new float[pixels_gx.length];
        float[] pixels_r = new float[pixels_gx.length];
        double max_norm = 0.0;
        double wrapped_start = ((this.bin_start + 90.0) % 180.0 + 180.0) % 180.0 - 90.0;
        double wrapped_end = ((this.bin_end + 90.0) % 180.0 + 180.0) % 180.0 - 90.0;
        if (wrapped_end <= wrapped_start) {
            range1_min = -90.0;
            range1_max = wrapped_end;
            range2_min = wrapped_start;
            range2_max = 90.0;
        } else {
            range1_min = wrapped_start;
            range1_max = wrapped_end;
            range2_min = wrapped_start;
            range2_max = wrapped_end;
        }
        for (int i = 0; i < pixels_gx.length; ++i) {
            float dx = pixels_gx[i];
            float dy = -pixels_gy[i];
            double norm = dx * dx + dy * dy;
            double angle = Math.atan(dy / dx);
            double angle_degs = angle * 180.0 / Math.PI;
            if (angle_degs >= range1_min && angle_degs <= range1_max || angle_degs >= range2_min && angle_degs <= range2_max) {
                double angle_ref;
                if (norm > max_norm) {
                    max_norm = norm;
                }
                for (angle_ref = angle * 180.0 / Math.PI; angle_ref > this.bin_end; angle_ref -= 180.0) {
                }
                while (angle_ref < this.bin_start) {
                    angle_ref += 180.0;
                }
                pixels_theta[i] = (float)angle_ref;
                pixels_r[i] = (float)norm;
                int histo_index = (int)((angle_ref - this.bin_start) / ((this.bins[1] - this.bins[0]) * 180.0 / Math.PI));
                if (histo_index == this.nbins) {
                    histo_index = 0;
                }
                int n = histo_index;
                norm_dir[n] = norm_dir[n] + norm;
                continue;
            }
            pixels_theta[i] = (float)(this.bins[0] * 180.0 / Math.PI);
        }
        if (this.build_orientation_map) {
            float[] pixels = (float[])ip.getPixels();
            float max_brightness = Float.NEGATIVE_INFINITY;
            float min_brightness = Float.POSITIVE_INFINITY;
            for (int i = 0; i < pixels.length; ++i) {
                if (pixels[i] > max_brightness) {
                    max_brightness = pixels[i];
                }
                if (!(pixels[i] < min_brightness)) continue;
                min_brightness = pixels[i];
            }
            ColorProcessor cp = new ColorProcessor(ip.getWidth(), ip.getHeight());
            byte[] H = new byte[pixels_r.length];
            byte[] S = new byte[pixels_r.length];
            for (int i = 0; i < pixels_r.length; ++i) {
                H[i] = (byte)(255.0 * ((double)pixels_theta[i] - this.bins[0] * 180.0 / Math.PI) / (this.bin_end - this.bin_start));
                S[i] = (byte)(255.0 * (double)pixels_r[i] / max_norm);
            }
            byte[] B = (byte[])ip.convertToByte(true).getPixels();
            cp.setHSB(H, S, B);
            this.orientation_map.addSlice(this.makeNames()[this.slice_index], (ImageProcessor)cp);
        }
        return norm_dir;
    }

    private final double[] fourier_component(FloatProcessor ip) {
        Roi original_square = new Roi((this.pad_size - this.small_side) / 2, (this.pad_size - this.small_side) / 2, this.small_side, this.small_side);
        double[] dir = new double[this.nbins];
        ImageStack spectra = null;
        if (this.debug) {
            spectra = new ImageStack(this.small_side, this.small_side);
        }
        FloatProcessor[] hue_arrays = null;
        FloatProcessor[] saturation_arrays = null;
        if (this.build_orientation_map) {
            hue_arrays = new FloatProcessor[this.npadx * this.npady];
            saturation_arrays = new FloatProcessor[this.npadx * this.npady];
        }
        float max_norm = 0.0f;
        for (int ix = 0; ix < this.npadx; ++ix) {
            for (int iy = 0; iy < this.npady; ++iy) {
                Roi square_roi = new Roi(ix * this.step, iy * this.step, this.small_side, this.small_side);
                ip.setRoi(square_roi);
                ImageProcessor square_block = ip.crop();
                float[] block_pixels = (float[])square_block.getPixels();
                for (int i = 0; i < block_pixels.length; ++i) {
                    int n = i;
                    block_pixels[n] = block_pixels[n] * this.window_pixels[i];
                }
                this.padded_square_block.setValue(0.0);
                this.padded_square_block.fill();
                this.padded_square_block.insert(square_block, (this.pad_size - this.small_side) / 2, (this.pad_size - this.small_side) / 2);
                FHT fft = new FHT((ImageProcessor)this.padded_square_block);
                fft.setShowProgress(false);
                fft.transform();
                fft.swapQuadrants();
                FHT pspectrum = fft.conjugateMultiply(fft);
                pspectrum.setRoi(original_square);
                float[] spectrum_px = (float[])pspectrum.getPixels();
                if (this.debug) {
                    FloatProcessor small_pspectrum = (FloatProcessor)pspectrum.crop();
                    spectra.addSlice("block nbr " + (ix + 1) * (iy + 1), (ImageProcessor)Directionality_.displayLog(small_pspectrum));
                }
                float[] weights = null;
                float[] max_weights = null;
                float[] best_angle = null;
                if (this.build_orientation_map) {
                    weights = new float[this.small_side * this.small_side];
                    max_weights = new float[this.small_side * this.small_side];
                    best_angle = new float[this.small_side * this.small_side];
                }
                for (int bin = 0; bin < this.nbins; ++bin) {
                    int i;
                    float[] fpx = (float[])this.filters.getPixels(bin + 1);
                    if (this.build_orientation_map) {
                        FHT tmp = fft.getCopy();
                        tmp.setShowProgress(false);
                        float[] tmp_px = (float[])tmp.getPixels();
                        for (i = 0; i < spectrum_px.length; ++i) {
                            int n = bin;
                            dir[n] = dir[n] + (double)(spectrum_px[i] * fpx[i]);
                            int n2 = i;
                            tmp_px[n2] = tmp_px[n2] * fpx[i];
                        }
                        tmp.inverseTransform();
                        tmp.setRoi(original_square);
                        FloatProcessor small_tmp = (FloatProcessor)tmp.crop();
                        float[] small_tmp_px = (float[])small_tmp.getPixels();
                        for (int j = 0; j < small_tmp_px.length; ++j) {
                            weights[j] = small_tmp_px[j] * small_tmp_px[j];
                            if (weights[j] > max_weights[j]) {
                                max_weights[j] = weights[j];
                                best_angle[j] = (float)this.bins[bin];
                            }
                            if (!(weights[j] > max_norm)) continue;
                            max_norm = weights[j];
                        }
                        continue;
                    }
                    for (i = 0; i < spectrum_px.length; ++i) {
                        int n = bin;
                        dir[n] = dir[n] + (double)(spectrum_px[i] * fpx[i]);
                    }
                }
                if (!this.build_orientation_map) continue;
                hue_arrays[ix + this.npadx * iy] = new FloatProcessor(ip.getWidth(), ip.getHeight());
                hue_arrays[ix + this.npadx * iy].insert((ImageProcessor)new FloatProcessor(this.small_side, this.small_side, best_angle, null), ix * this.step, iy * this.step);
                saturation_arrays[ix + this.npadx * iy] = new FloatProcessor(ip.getWidth(), ip.getHeight());
                saturation_arrays[ix + this.npadx * iy].insert((ImageProcessor)new FloatProcessor(this.small_side, this.small_side, max_weights, null), ix * this.step, iy * this.step);
            }
        }
        if (this.build_orientation_map) {
            FloatProcessor big_hue = new FloatProcessor(ip.getWidth(), ip.getHeight());
            FloatProcessor big_saturation = new FloatProcessor(ip.getWidth(), ip.getHeight());
            float[] big_hue_px = (float[])big_hue.getPixels();
            float[] big_saturation_px = (float[])big_saturation.getPixels();
            float[] saturation_px = null;
            float[] hue_px = null;
            for (int ix = 0; ix < this.npadx; ++ix) {
                for (int iy = 0; iy < this.npady; ++iy) {
                    hue_px = (float[])hue_arrays[ix + this.npadx * iy].getPixels();
                    saturation_px = (float[])saturation_arrays[ix + this.npadx * iy].getPixels();
                    for (int i = 0; i < big_hue_px.length; ++i) {
                        if (!(255.0f * saturation_px[i] / max_norm >= big_saturation_px[i])) continue;
                        big_saturation_px[i] = 255.0f * saturation_px[i] / max_norm;
                        big_hue_px[i] = (float)(255.0 * (((double)hue_px[i] - this.bins[0]) / (this.bins[this.nbins - 1] - this.bins[0])));
                    }
                }
            }
            ByteProcessor big_brightness = (ByteProcessor)ip.convertToByte(true);
            ColorProcessor cp = new ColorProcessor(ip.getWidth(), ip.getHeight());
            cp.setHSB((byte[])big_hue.convertToByte(false).getPixels(), (byte[])big_saturation.convertToByte(false).getPixels(), (byte[])big_brightness.getPixels());
            this.orientation_map.addSlice(this.makeNames()[this.slice_index], (ImageProcessor)cp);
        }
        if (this.debug) {
            new ImagePlus("Log10 power FFT of " + this.makeNames()[this.slice_index], spectra).show();
        }
        return dir;
    }

    private final ImageStack makeFftFilters() {
        ImageStack filters = new ImageStack(this.pad_size, this.pad_size, this.nbins);
        float[] r_px = (float[])this.r.getPixels();
        float[] theta_px = (float[])this.theta.getPixels();
        double theta_bw = this.bins[1] - this.bins[0];
        double r_c = this.pad_size / 4;
        double r_bw = r_c / 2.0;
        for (int i = 1; i <= this.nbins; ++i) {
            double theta_c;
            float[] pixels = new float[this.pad_size * this.pad_size];
            for (theta_c = this.bins[i - 1]; theta_c >= Math.PI; theta_c -= Math.PI) {
            }
            while (theta_c < 0.0) {
                theta_c += Math.PI;
            }
            theta_c -= 1.5707963267948966;
            for (int index = 0; index < pixels.length; ++index) {
                double angular_part;
                double current_r = r_px[index];
                if (current_r < 5.0 || current_r > (double)(this.pad_size / 2)) continue;
                double radial_part = Math.exp(-(current_r - r_c) * (current_r - r_c) / (r_bw * r_bw));
                double current_theta = theta_px[index];
                if (Math.abs(current_theta - theta_c) < theta_bw) {
                    angular_part = Math.cos((current_theta - theta_c) / theta_bw * Math.PI / 2.0);
                    angular_part *= angular_part;
                } else if (Math.abs(current_theta - (theta_c - Math.PI)) < theta_bw) {
                    angular_part = Math.cos((current_theta - (theta_c - Math.PI)) / theta_bw * Math.PI / 2.0);
                    angular_part *= angular_part;
                } else {
                    if (!(Math.abs(current_theta - (theta_c + Math.PI)) < theta_bw)) continue;
                    angular_part = Math.cos((current_theta - (theta_c + Math.PI)) / theta_bw * Math.PI / 2.0);
                    angular_part *= angular_part;
                }
                pixels[index] = (float)(angular_part * radial_part);
            }
            filters.setPixels((Object)pixels, i);
            filters.setSliceLabel("Angle: " + String.format("%.1f", this.bins[i - 1] * 180.0 / Math.PI), i);
        }
        return filters;
    }

    private final String[] makeNames() {
        String[] names;
        int n_slices = this.imp.getStack().getSize();
        if (this.imp.getType() == 4) {
            names = new String[3 * n_slices];
            for (int i = 0; i < n_slices; ++i) {
                String label = this.imp.getStack().getShortSliceLabel(i + 1);
                if (null == label) {
                    names[0 + i * 3] = "Slice_" + (i + 1) + "R";
                    names[1 + i * 3] = "Slice_" + (i + 1) + "G";
                    names[2 + i * 3] = "Slice_" + (i + 1) + "B";
                    continue;
                }
                names[0 + i * 3] = label + "_R";
                names[1 + i * 3] = label + "_G";
                names[2 + i * 3] = label + "_B";
            }
        } else {
            if (n_slices <= 1) {
                return new String[]{this.imp.getShortTitle()};
            }
            names = new String[n_slices];
            for (int i = 0; i < n_slices; ++i) {
                String label = this.imp.getStack().getShortSliceLabel(i + 1);
                names[i] = null == label ? "Slice_" + (i + 1) : label;
            }
        }
        return names;
    }

    public static final ImagePlus generateColorWheel(double angle_start, double angle_end) {
        int cw_height = 256;
        int cw_width = 128;
        int offset = 64;
        ColorProcessor color_ip = new ColorProcessor(192, 256);
        FloatProcessor R = Directionality_.makeRMatrix(384, 256);
        FloatProcessor T = Directionality_.makeThetaMatrix(384, 256);
        Roi half_roi = new Roi(192, 0, 192, 256);
        R.setRoi(half_roi);
        R = (FloatProcessor)R.crop();
        T.setRoi(half_roi);
        T = (FloatProcessor)T.crop();
        float[] r = (float[])R.getPixels();
        float[] t = (float[])T.getPixels();
        byte[] hue = new byte[r.length];
        byte[] sat = new byte[r.length];
        byte[] bgh = new byte[r.length];
        for (int i = 0; i < t.length; ++i) {
            if (r[i] > 128.0f) {
                hue[i] = 0;
                sat[i] = 0;
                bgh[i] = -1;
                continue;
            }
            hue[i] = (byte)(255.0 * ((double)t[i] + 1.5707963267948966) / Math.PI);
            sat[i] = (byte)(255.0f * r[i] / 128.0f);
            bgh[i] = -1;
        }
        color_ip.setHSB(hue, sat, bgh);
        color_ip.setBackgroundValue(255.0);
        color_ip.filterRGB(9, 64.0);
        color_ip.setColor(Color.WHITE);
        Roi fill_roi = new Roi(0, 0, 64, 256);
        color_ip.setRoi(fill_roi);
        color_ip.fill(fill_roi);
        color_ip.setColor(Color.BLACK);
        color_ip.setJustification(2);
        String txt_min = String.valueOf(angle_start);
        String txt_mid = String.valueOf(0.5 * (angle_start + angle_end));
        String txt_max = String.valueOf(angle_end);
        TextRoi text_roi_min = new TextRoi(59, 231, txt_min);
        text_roi_min.drawPixels((ImageProcessor)color_ip);
        TextRoi text_roi_max = new TextRoi(59, 0, txt_max);
        text_roi_max.drawPixels((ImageProcessor)color_ip);
        TextRoi text_roi_mid = new TextRoi(59, 115, txt_mid);
        text_roi_mid.drawPixels((ImageProcessor)color_ip);
        ImagePlus imp = new ImagePlus("Color wheel", (ImageProcessor)color_ip);
        return imp;
    }

    protected static final void addColorMouseListener(final ImageCanvas canvas, final double angle_start, final double angle_end) {
        MouseMotionListener ml = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Point coord = canvas.getCursorLoc();
                int x = coord.x;
                int y = coord.y;
                try {
                    ColorProcessor cp = (ColorProcessor)canvas.getImage().getProcessor();
                    int c = cp.getPixel(x, y);
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    float[] hsb = Color.RGBtoHSB(r, g, b, null);
                    float angle = (float)((double)hsb[0] * (angle_end - angle_start) + angle_start);
                    float amount = hsb[1];
                    IJ.showStatus((String)String.format("Orientation: %5.1f \u00b0 - Amont: %5.1f %%", Float.valueOf(angle), Float.valueOf(100.0f * amount)));
                }
                catch (ClassCastException cce) {
                    return;
                }
            }
        };
        canvas.addMouseMotionListener(ml);
    }

    protected static final double[] prepareBins(int n, double first, double last) {
        double[] bins = new double[n];
        for (int i = 0; i < n; ++i) {
            bins[i] = (first + (double)i * (last - first) / (double)(n - 1)) / 180.0 * Math.PI;
        }
        return bins;
    }

    protected static final String parseArgumentString(String argument_string, String command_str) {
        if (argument_string.contains(command_str)) {
            int narg = argument_string.indexOf(command_str) + command_str.length();
            int next_arg = argument_string.indexOf(",", narg);
            if (next_arg == -1) {
                next_arg = argument_string.length();
            }
            String str = argument_string.substring(narg, next_arg);
            return str;
        }
        return null;
    }

    protected static final FloatProcessor displayLog(FloatProcessor ip) {
        FloatProcessor log10 = new FloatProcessor(ip.getWidth(), ip.getHeight());
        float[] log10_pixels = (float[])log10.getPixels();
        float[] pixels = (float[])ip.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            log10_pixels[i] = (float)Math.log10(1.0f + pixels[i]);
        }
        return log10;
    }

    protected static final double[] getBlackmanPeriodicWindow1D(int n) {
        double[] window = new double[n];
        for (int i = 0; i < window.length; ++i) {
            window[i] = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n) + 0.08 * Math.cos(Math.PI * 4 / (double)n);
        }
        return window;
    }

    protected static final FloatProcessor getBlackmanProcessor(int nx, int ny) {
        FloatProcessor bpw = new FloatProcessor(nx, ny);
        float[] pixels = (float[])bpw.getPixels();
        double[] bpwx = Directionality_.getBlackmanPeriodicWindow1D(nx);
        double[] bpwy = Directionality_.getBlackmanPeriodicWindow1D(nx);
        for (int i = 0; i < pixels.length; ++i) {
            int iy = i / nx;
            int ix = i % nx;
            pixels[i] = (float)(bpwx[ix] * bpwy[iy]);
        }
        return bpw;
    }

    protected static final FloatProcessor makeRMatrix(int nx, int ny) {
        FloatProcessor r = new FloatProcessor(nx, ny);
        float[] pixels = (float[])r.getPixels();
        int xc = nx / 2;
        int yc = ny / 2;
        for (int i = 0; i < pixels.length; ++i) {
            int iy = i / nx;
            int ix = i % nx;
            pixels[i] = (float)Math.sqrt((ix - xc) * (ix - xc) + (iy - yc) * (iy - yc));
        }
        return r;
    }

    protected static final FloatProcessor makeThetaMatrix(int nx, int ny) {
        FloatProcessor theta = new FloatProcessor(nx, ny);
        float[] pixels = (float[])theta.getPixels();
        int xc = nx / 2;
        int yc = ny / 2;
        for (int i = 0; i < pixels.length; ++i) {
            int iy = i / nx;
            int ix = i % nx;
            pixels[i] = (float)Math.atan2(-(iy - yc), ix - xc);
        }
        return theta;
    }

    protected static final LookupPaintScale createLUT(int ncol) {
        float[][] colors = new float[][]{{0.0f, 0.29411766f, 0.5882353f}, {0.1f, 0.8f, 0.1f}, {0.5882353f, 0.29411766f, 0.0f}};
        float[] limits = new float[]{0.0f, 0.5f, 1.0f};
        LookupPaintScale lut = new LookupPaintScale(0.0, 1.0, (Paint)Color.BLACK);
        for (int j = 0; j < ncol; ++j) {
            float val = (float)j / ((float)ncol - 0.99f);
            int i = 0;
            for (i = 0; i < limits.length && !(val < limits[i]); ++i) {
            }
            float r = colors[--i][0] + (val - limits[i]) / (limits[i + 1] - limits[i]) * (colors[i + 1][0] - colors[i][0]);
            float g = colors[i][1] + (val - limits[i]) / (limits[i + 1] - limits[i]) * (colors[i + 1][1] - colors[i][1]);
            float b = colors[i][2] + (val - limits[i]) / (limits[i + 1] - limits[i]) * (colors[i + 1][2] - colors[i][2]);
            lut.add((double)val, (Paint)new Color(r, g, b));
        }
        return lut;
    }

    public static void main(String[] args) {
        Line[] rois;
        ImagePlus imp = NewImage.createShortImage((String)"Lines", (int)400, (int)400, (int)1, (int)1);
        ImageProcessor ip = imp.getProcessor();
        ip.setLineWidth(4);
        ip.setColor(Color.WHITE);
        Line line_30deg = new Line(10.0, 412.0, 446.0, 160.2753);
        Line line_30deg2 = new Line(10.0, 312.0, 446.4102, 60.2753);
        Line line_m60deg = new Line(10.0, 10.0, 300.0, 512.2947);
        for (Line roi : rois = new Line[]{line_30deg, line_30deg2, line_m60deg}) {
            roi.setStrokeWidth(2.0f);
            ip.draw((Roi)roi);
        }
        GaussianBlur smoother = new GaussianBlur();
        smoother.blurGaussian(ip, 2.0, 2.0, 0.01);
        imp.show();
        Directionality_ da = new Directionality_();
        da.setImagePlus(imp);
        da.setBinNumber(60);
        da.setBinStart(-90.0);
        da.setBuildOrientationMapFlag(false);
        da.setDebugFlag(false);
        AnalysisMethod method = AnalysisMethod.FOURIER_COMPONENTS;
        da.setMethod(method);
        da.computeHistograms();
        ArrayList<double[]> fit_results = da.getFitParameters();
        double center = fit_results.get(0)[2];
        System.out.println("With method: " + (Object)((Object)method));
        System.out.println(String.format("Found maxima at %.1f, expected it at 30\u00b0.\n", center / Math.PI * 180.0, 30));
        da.plotResults().setVisible(true);
        da.displayResultsTable().show("Table");
    }

    public static enum AnalysisMethod {
        FOURIER_COMPONENTS,
        LOCAL_GRADIENT_ORIENTATION;


        public String toString() {
            switch (this) {
                case FOURIER_COMPONENTS: {
                    return "Fourier components";
                }
                case LOCAL_GRADIENT_ORIENTATION: {
                    return "Local gradient orientation";
                }
            }
            return "Not implemented";
        }

        public String toCommandName() {
            switch (this) {
                case FOURIER_COMPONENTS: {
                    return "Fourier";
                }
                case LOCAL_GRADIENT_ORIENTATION: {
                    return "Gradient";
                }
            }
            return "Not implemented";
        }
    }
}

