/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;

public class FontFile2
implements Serializable {
    public static final int HEAD = 0;
    public static final int MAPX = 1;
    public static final int CMAP = 2;
    public static final int LOCA = 3;
    public static final int GLYF = 4;
    public static final int HHEA = 5;
    public static final int HMTX = 6;
    public static final int NAME = 7;
    public static final int POST = 8;
    public static final int CVT = 9;
    public static final int FPGM = 10;
    public static final int HDMX = 11;
    public static final int KERN = 12;
    public static final int OS2 = 13;
    public static final int PREP = 14;
    public static final int DSIG = 15;
    public static final int CFF = 16;
    public static final int GSUB = 17;
    public static final int BASE = 18;
    private int[] tables = new int[19];
    private int[] offsets = new int[19];
    private byte[] fontData;
    private int pointer = 0;

    public FontFile2(byte[] byArray) {
        this.fontData = byArray;
        this.readHeader();
    }

    private final void readHeader() {
        int n = this.getNextUint32();
        int n2 = this.getNextUint16();
        int n3 = this.getNextUint16();
        int n4 = this.getNextUint16();
        int n5 = this.getNextUint16();
        for (int i = 0; i < n2; ++i) {
            String string = this.getNextUint32AsTag();
            int n6 = this.getNextUint32();
            int n7 = this.getNextUint32();
            int n8 = this.getNextUint32();
            int n9 = -1;
            if (string.equals("maxp")) {
                n9 = 1;
            } else if (string.equals("head")) {
                n9 = 0;
            } else if (string.equals("cmap")) {
                n9 = 2;
            } else if (string.equals("loca")) {
                n9 = 3;
            } else if (string.equals("glyf")) {
                n9 = 4;
            } else if (string.equals("hhea")) {
                n9 = 5;
            } else if (string.equals("hmtx")) {
                n9 = 6;
            } else if (string.equals("name")) {
                n9 = 7;
            } else if (string.equals("post")) {
                n9 = 8;
            } else if (string.equals("cvt ")) {
                n9 = 9;
            } else if (string.equals("fpgm")) {
                n9 = 10;
            } else if (string.equals("hdmx")) {
                n9 = 11;
            } else if (string.equals("kern")) {
                n9 = 12;
            } else if (string.equals("OS/2")) {
                n9 = 13;
            } else if (string.equals("prep")) {
                n9 = 14;
            } else if (string.equals("DSIG")) {
                n9 = 15;
            } else if (string.equals("BASE")) {
                n9 = 18;
            } else if (string.equals("CFF ")) {
                n9 = 16;
            } else if (string.equals("GSUB")) {
                n9 = 17;
            }
            if (n9 == -1) continue;
            this.tables[n9] = n7;
            this.offsets[n9] = n8;
        }
    }

    public int selectTable(int n) {
        this.pointer = this.tables[n];
        return this.pointer;
    }

    public int getTableSize(int n) {
        return this.offsets[n];
    }

    public final int getNextUint32() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.fontData[this.pointer];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            n += n2 << 8 * (3 - i);
            ++this.pointer;
        }
        return n;
    }

    public final int getNextUint64() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            int n2 = this.fontData[this.pointer];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            n += n2 << 8 * (7 - i);
            ++this.pointer;
        }
        return n;
    }

    public final void setPointer(int n) {
        this.pointer = n;
    }

    public final int getOffset(int n) {
        return this.offsets[n];
    }

    public final int getTable(int n) {
        return this.tables[n];
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final String getNextUint32AsTag() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append((char)this.fontData[this.pointer]);
            ++this.pointer;
        }
        return stringBuffer.toString();
    }

    public final int getNextUint16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.fontData[this.pointer] & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return n;
    }

    public final short getShort() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            byte by = this.fontData[this.pointer];
            n += by << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public final int getNextUint8() {
        int n = this.fontData[this.pointer] & 0xFF;
        ++this.pointer;
        return n;
    }

    public final int getNextint8() {
        byte by = this.fontData[this.pointer];
        ++this.pointer;
        return by;
    }

    public void skip(int n) {
        this.pointer += n;
    }

    public short getFWord() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.fontData[this.pointer] & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short getNextInt16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.fontData[this.pointer] & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short getNextSignedInt16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.fontData[this.pointer] & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short readUFWord() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.fontData[this.pointer] & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public float getFixed() {
        int n = (this.fontData[this.pointer] & 0xFF) * 256 + (this.fontData[this.pointer + 1] & 0xFF);
        if (n > 32768) {
            n -= 65536;
        }
        this.pointer += 2;
        int n2 = (this.fontData[this.pointer] & 0xFF) * 256 + (this.fontData[this.pointer + 1] & 0xFF);
        this.pointer += 2;
        return (float)n + (float)n2 / 65536.0f;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        int n = this.fontData[this.pointer] & 0xFF;
        ++this.pointer;
        for (int i = 0; i < n; ++i) {
            int n2 = this.fontData[this.pointer] & 0xFF;
            ++this.pointer;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public float getF2Dot14() {
        boolean bl;
        int n = ((this.fontData[this.pointer] & 0xFF) << 8) + (this.fontData[this.pointer + 1] & 0xFF);
        this.pointer += 2;
        if (n == 49152) {
            return -1.0f;
        }
        if (n == 16384) {
            return 1.0f;
        }
        boolean bl2 = bl = (n & 0x8000) == 32768;
        if (bl) {
            return -((float)(n & 0x8000) / 16384.0f);
        }
        return (float)n / 16384.0f;
    }

    public byte[] readBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(byArray, 0, this.fontData, n, n2);
        return byArray;
    }
}

