/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.ImgLibFunction;
import java.util.Stack;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public abstract class TwoOperandsPixelBasedAbstractFunction<T extends RealType<T>>
extends PostfixMathCommand
implements ImgLibFunction<T> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        FloatType result = null;
        if (param1 instanceof Img) {
            if (param2 instanceof Img) {
                result = this.evaluate((RealType)((Img)param1), (Img)((Img)param2));
            } else if (param2 instanceof RealType) {
                FloatType t2 = (FloatType)param2;
                result = this.evaluate((Img)param1, t2);
            } else {
                if (!(param2 instanceof Double)) throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand 2: " + param2.getClass().getSimpleName());
                FloatType t2 = new FloatType(((Double)param2).floatValue());
                result = this.evaluate((Img)param1, t2);
            }
        } else {
            if (!(param1 instanceof RealType)) throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand 1: " + param1.getClass().getSimpleName());
            FloatType t1 = (FloatType)param1;
            if (param2 instanceof Img) {
                result = this.evaluate(t1, (Img)param2);
            } else {
                if (!(param2 instanceof RealType)) throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand 2: " + param2.getClass().getSimpleName());
                FloatType t2 = (FloatType)param2;
                result = new FloatType(this.evaluate(t1, t2));
            }
        }
        inStack.push(result);
    }

    public final <R extends RealType<R>> Img<FloatType> evaluate(Img<R> img1, Img<R> img2) throws ParseException {
        long[] dimensions = new long[img1.numDimensions()];
        img1.dimensions(dimensions);
        ArrayImg result = new ArrayImgFactory().create(dimensions, (NativeType)new FloatType());
        boolean compatible_containers = Util.equalIterationOrder((IterableInterval[])new IterableInterval[]{img1, img2});
        if (compatible_containers) {
            Cursor c1 = img1.cursor();
            Cursor c2 = img2.cursor();
            Cursor rc = result.cursor();
            while (c1.hasNext()) {
                c1.fwd();
                c2.fwd();
                rc.fwd();
                ((FloatType)rc.get()).set(this.evaluate((RealType)c1.get(), (RealType)c2.get()));
            }
        } else {
            Cursor rc = result.localizingCursor();
            RandomAccess c1 = img1.randomAccess();
            RandomAccess c2 = img2.randomAccess();
            while (rc.hasNext()) {
                rc.fwd();
                c1.setPosition((Localizable)rc);
                c2.setPosition((Localizable)rc);
                ((FloatType)rc.get()).set(this.evaluate((RealType)c1.get(), (RealType)c2.get()));
            }
        }
        return result;
    }

    public final <R extends RealType<R>> Img<FloatType> evaluate(Img<R> img, R alpha) throws ParseException {
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        ArrayImg result = new ArrayImgFactory().create(dimensions, (NativeType)new FloatType());
        Cursor ic = img.cursor();
        Cursor rc = result.cursor();
        while (rc.hasNext()) {
            rc.fwd();
            ic.fwd();
            ((FloatType)rc.get()).set(this.evaluate((RealType)ic.get(), alpha));
        }
        return result;
    }

    public final <R extends RealType<R>> Img<FloatType> evaluate(R alpha, Img<R> img) throws ParseException {
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        ArrayImg result = new ArrayImgFactory().create(dimensions, (NativeType)new FloatType());
        Cursor ic = img.cursor();
        Cursor rc = result.cursor();
        while (rc.hasNext()) {
            rc.fwd();
            ic.fwd();
            ((FloatType)rc.get()).set(this.evaluate(alpha, (RealType)ic.get()));
        }
        return result;
    }

    public abstract <R extends RealType<R>> float evaluate(R var1, R var2) throws ParseException;
}

