/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel3D;
import mpicbg.models.Tile;
import mpicbg.pointdescriptor.LinkedPoint;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import mpicbg.spim.registration.detection.AbstractDetection;
import mpicbg.spim.registration.detection.DetectionIdentification;
import mpicbg.spim.registration.detection.DetectionView;
import mpicbg.util.TransformUtils;
import spim.vecmath.Matrix4d;
import spim.vecmath.Quat4d;
import spim.vecmath.Vector3d;

public class DetectionRegistration {
    public static synchronized <S extends DetectionIdentification<S, T>, T extends DetectionView<S, T>> void removeInconsistentCorrespondences(ArrayList<PointMatchGeneric<T>> correspondences) {
        int i;
        ArrayList<Integer> inconsistentCorrespondences = new ArrayList<Integer>();
        for (i = 0; i < correspondences.size(); ++i) {
            DetectionView detectionB;
            DetectionView detectionA = (DetectionView)((Object)correspondences.get(i).getPoint1());
            ArrayList<Integer> inconsistent = DetectionRegistration.getOccurences(detectionA, detectionB = (DetectionView)((Object)correspondences.get(i).getPoint2()), correspondences);
            if (inconsistent.size() <= 0) continue;
            for (int index : inconsistent) {
                if (inconsistentCorrespondences.contains(index)) continue;
                inconsistentCorrespondences.add(index);
            }
        }
        if (inconsistentCorrespondences.size() > 0) {
            Collections.sort(inconsistentCorrespondences);
            for (i = inconsistentCorrespondences.size() - 1; i >= 0; --i) {
                DetectionIdentification n;
                int j;
                PointMatchGeneric<T> pm = correspondences.get((Integer)inconsistentCorrespondences.get(i));
                DetectionView detectionA = (DetectionView)((Object)pm.getPoint1());
                DetectionView detectionB = (DetectionView)((Object)pm.getPoint2());
                boolean removed = false;
                for (j = 0; j < detectionA.getDescriptorCorrespondence().size(); ++j) {
                    n = (DetectionIdentification)detectionA.getDescriptorCorrespondence().get(j);
                    if (n.getDetectionID() != detectionB.getID() || n.getViewID() != detectionB.getViewID()) continue;
                    detectionA.getDescriptorCorrespondence().remove(j);
                    removed = true;
                    break;
                }
                if (!removed) {
                    IOFunctions.println("Error removing ambigous descriptor correspondence for detectionA: " + detectionA.getID() + " vs. " + detectionB.getID());
                }
                removed = false;
                for (j = 0; j < detectionB.getDescriptorCorrespondence().size(); ++j) {
                    n = (DetectionIdentification)detectionB.getDescriptorCorrespondence().get(j);
                    if (n.getDetectionID() != detectionA.getID() || n.getViewID() != detectionA.getViewID()) continue;
                    detectionB.getDescriptorCorrespondence().remove(j);
                    removed = true;
                    break;
                }
                if (!removed) {
                    IOFunctions.println("Error removing ambigous descriptor correspondence for detectionB: " + detectionB.getID() + " vs. " + detectionA.getID());
                }
                correspondences.remove((Integer)inconsistentCorrespondences.get(i));
            }
        }
    }

    protected static <S extends DetectionIdentification<S, T>, T extends DetectionView<S, T>> ArrayList<Integer> getOccurences(T detectionA, T detectionB, ArrayList<PointMatchGeneric<T>> list) {
        ArrayList<Integer> occurences = new ArrayList<Integer>();
        boolean differentOccurence = false;
        for (PointMatchGeneric<T> pm : list) {
            if (detectionB.equals((DetectionView)((Object)pm.getPoint2())) && !detectionA.equals((DetectionView)((Object)pm.getPoint1()))) {
                differentOccurence = true;
                break;
            }
            if (!detectionA.equals((DetectionView)((Object)pm.getPoint1())) || detectionB.equals((DetectionView)((Object)pm.getPoint2()))) continue;
            differentOccurence = true;
            break;
        }
        if (differentOccurence) {
            for (int i = 0; i < list.size(); ++i) {
                PointMatchGeneric<T> pm;
                pm = list.get(i);
                if (detectionB.equals((DetectionView)((Object)pm.getPoint2()))) {
                    occurences.add(i);
                }
                if (!detectionA.equals((DetectionView)((Object)pm.getPoint1()))) continue;
                occurences.add(i);
            }
        } else {
            boolean sameOccurence = false;
            for (int i = 0; i < list.size(); ++i) {
                PointMatchGeneric<T> pm = list.get(i);
                if (!detectionB.equals((DetectionView)((Object)pm.getPoint2()))) continue;
                if (sameOccurence) {
                    occurences.add(i);
                    continue;
                }
                sameOccurence = true;
            }
        }
        return occurences;
    }

    public static <S extends DetectionIdentification<S, T>, T extends DetectionView<S, T>> String computeRANSAC(ArrayList<PointMatchGeneric<T>> correspondenceCandidates, ArrayList<PointMatchGeneric<T>> inlierList, Model<?> model) {
        return DetectionRegistration.computeRANSAC(correspondenceCandidates, inlierList, model, 10.0f, 0.1f, 3.0f, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends DetectionIdentification<S, T>, T extends DetectionView<S, T>> String computeRANSAC(ArrayList<PointMatchGeneric<T>> correspondenceCandidates, ArrayList<PointMatchGeneric<T>> inlierList, Model<?> model, float maxEpsilon, float minInlierRatio, float minNumberInlierFactor, int numIterations) {
        int numCorrespondences = correspondenceCandidates.size();
        int minNumCorrespondences = Math.max(model.getMinNumMatches(), Math.round((float)model.getMinNumMatches() * minNumberInlierFactor));
        DetectionRegistration.removeInconsistentCorrespondences(correspondenceCandidates);
        if (numCorrespondences < minNumCorrespondences) {
            return "Not enough correspondences found " + numCorrespondences + ", should be at least " + minNumCorrespondences;
        }
        ArrayList<PointMatchGeneric<LinkedPoint<DetectionView>>> candidates = new ArrayList<PointMatchGeneric<LinkedPoint<DetectionView>>>();
        ArrayList inliers = new ArrayList();
        for (PointMatchGeneric<T> correspondence : correspondenceCandidates) {
            DetectionView detectionA = (DetectionView)((Object)correspondence.getPoint1());
            DetectionView detectionB = (DetectionView)((Object)correspondence.getPoint2());
            LinkedPoint<DetectionView> p1 = new LinkedPoint<DetectionView>(detectionA.getL(), detectionA.getW(), detectionA);
            LinkedPoint<DetectionView> p2 = new LinkedPoint<DetectionView>(detectionB.getL(), detectionB.getW(), detectionB);
            double weight = correspondence.getWeight();
            candidates.add(new PointMatchGeneric<LinkedPoint<DetectionView>>(p1, p2, weight));
        }
        boolean modelFound = false;
        try {
            modelFound = model.filterRansac(candidates, inliers, numIterations, (double)maxEpsilon, (double)minInlierRatio);
        }
        catch (NotEnoughDataPointsException e) {
            return e.toString();
        }
        NumberFormat nf = NumberFormat.getPercentInstance();
        float ratio = (float)inliers.size() / (float)candidates.size();
        if (modelFound && inliers.size() >= minNumCorrespondences) {
            for (PointMatch pointMatch : inliers) {
                PointMatchGeneric pm = (PointMatchGeneric)pointMatch;
                DetectionView detectionA = (DetectionView)((Object)((LinkedPoint)((Object)pm.getPoint1())).getLinkedObject());
                DetectionView detectionB = (DetectionView)((Object)((LinkedPoint)((Object)pm.getPoint2())).getLinkedObject());
                DetectionView detectionView = detectionA;
                synchronized (detectionView) {
                    detectionA.addRANSACCorrespondence(detectionB);
                }
                detectionView = detectionB;
                synchronized (detectionView) {
                    detectionB.addRANSACCorrespondence(detectionA);
                }
                inlierList.add(new PointMatchGeneric<DetectionView>(detectionA, detectionB));
            }
            return "Remaining inliers after RANSAC: " + inliers.size() + " of " + candidates.size() + " (" + nf.format(ratio) + ") with average error " + model.getCost();
        }
        if (modelFound) {
            return "Model found but not enough remaining inliers (" + inliers.size() + "/" + minNumCorrespondences + ") after RANSAC of " + candidates.size();
        }
        return "NO Model found after RANSAC of " + candidates.size();
    }

    protected static Quat4d getQuaternion(RigidModel3D model) {
        Matrix4d matrix = new Matrix4d();
        TransformUtils.getTransform3D(model).get(matrix);
        Quat4d quaternion = new Quat4d();
        quaternion.set(matrix);
        return quaternion;
    }

    public static double getApproximateRotationAngle(RigidModel3D model) {
        Quat4d qu = DetectionRegistration.getQuaternion(model);
        return Math.toDegrees(Math.acos(qu.getW()) * 2.0);
    }

    public static Vector3d getApproximateAxis(RigidModel3D model) {
        Quat4d qu = DetectionRegistration.getQuaternion(model);
        Vector3d n = new Vector3d(qu.getX(), qu.getY(), qu.getZ());
        n.normalize();
        return n;
    }

    public static synchronized <T extends AbstractDetection<T>> void addPointMatches(ArrayList<PointMatchGeneric<T>> correspondences, Tile<?> tileA, Tile<?> tileB) {
        ArrayList<PointMatchGeneric<T>> pm = new ArrayList<PointMatchGeneric<T>>();
        pm.addAll(correspondences);
        if (correspondences.size() > 0) {
            tileA.addMatches(pm);
            tileB.addMatches(PointMatch.flip(pm));
            tileA.addConnectedTile(tileB);
            tileB.addConnectedTile(tileA);
        }
    }
}

