/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.IntegerPattern;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.TimePointsPattern;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import spim.fiji.datasetmanager.MultiViewDatasetDefinition;
import spim.fiji.plugin.Apply_Transformation;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.NamePattern;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.imgloaders.StackImgLoader;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public abstract class StackList
implements MultiViewDatasetDefinition {
    public static final char TIMEPOINT_PATTERN = 't';
    public static final char CHANNEL_PATTERN = 'c';
    public static final char ILLUMINATION_PATTERN = 'i';
    public static final char ANGLE_PATTERN = 'a';
    protected String[] dimensionChoiceTimePointsTrue = new String[]{"NO (one time-point)", "YES (one file per time-point)", "YES (all time-points in one file)"};
    protected String[] dimensionChoiceTimePointsFalse = new String[]{this.dimensionChoiceTimePointsTrue[0], this.dimensionChoiceTimePointsTrue[1]};
    protected String[] dimensionChoiceChannelsTrue = new String[]{"NO (one channel)", "YES (one file per channel)", "YES (all channels in one file)"};
    protected String[] dimensionChoiceChannelsFalse = new String[]{this.dimensionChoiceChannelsTrue[0], this.dimensionChoiceChannelsTrue[1]};
    protected String[] dimensionChoiceIlluminationsTrue = new String[]{"NO (one illumination direction)", "YES (one file per illumination direction)", "YES (all illumination directions in one file)"};
    protected String[] dimensionChoiceIlluminationsFalse = new String[]{this.dimensionChoiceIlluminationsTrue[0], this.dimensionChoiceIlluminationsTrue[1]};
    protected String[] dimensionChoiceAnglesTrue = new String[]{"NO (one angle)", "YES (one file per angle)", "YES (all angles in one file)"};
    protected String[] dimensionChoiceAnglesFalse = new String[]{this.dimensionChoiceAnglesTrue[0], this.dimensionChoiceAnglesTrue[1]};
    protected int hasMultipleAngles;
    protected int hasMultipleTimePoints;
    protected int hasMultipleChannels;
    protected int hasMultipleIlluminations;
    public static boolean showDebugFileNames = true;
    public static String defaultTimepoints = "18,19,30";
    public static String defaultChannels = "1,2";
    public static String defaultIlluminations = "0,1";
    public static String defaultAngles = "0-315:45";
    protected String timepoints;
    protected String channels;
    protected String illuminations;
    protected String angles;
    protected ArrayList<String> timepointNameList;
    protected ArrayList<String> channelNameList;
    protected ArrayList<String> illuminationsNameList;
    protected ArrayList<String> angleNameList;
    protected String replaceTimepoints;
    protected String replaceChannels;
    protected String replaceIlluminations;
    protected String replaceAngles;
    protected int numDigitsTimepoints;
    protected int numDigitsChannels;
    protected int numDigitsIlluminations;
    protected int numDigitsAngles;
    protected ArrayList<int[]> exceptionIds;
    protected String[] calibrationChoice1 = new String[]{"Same voxel-size for all views", "Different voxel-sizes for each view"};
    protected String[] calibrationChoice2 = new String[]{"Load voxel-size(s) from file(s)", "Load voxel-size(s) from file(s) and display for verification", "User define voxel-size(s)"};
    public static String[] imglib2Container = new String[]{"ArrayImg (faster)", "CellImg (slower, larger files supported)"};
    public static int defaultContainer = 0;
    public ImgFactory<? extends NativeType<?>> imgFactory;
    public static int defaultCalibration1 = 0;
    public static int defaultCalibration2 = 1;
    public int calibration1;
    public int calibration2;
    protected HashMap<ViewSetupPrecursor, Calibration> calibrations = new HashMap();
    public static String defaultDirectory = "";
    public static String defaultFileNamePattern = null;
    protected String directory;
    protected String fileNamePattern;

    protected abstract int getDefaultMultipleAngles();

    protected abstract int getDefaultMultipleTimepoints();

    protected abstract int getDefaultMultipleChannels();

    protected abstract int getDefaultMultipleIlluminations();

    protected abstract void setDefaultMultipleAngles(int var1);

    protected abstract void setDefaultMultipleTimepoints(int var1);

    protected abstract void setDefaultMultipleChannels(int var1);

    protected abstract void setDefaultMultipleIlluminations(int var1);

    protected abstract boolean supportsMultipleTimepointsPerFile();

    protected abstract boolean supportsMultipleChannelsPerFile();

    protected abstract boolean supportsMultipleAnglesPerFile();

    protected abstract boolean supportsMultipleIlluminationsPerFile();

    protected boolean queryInformation() {
        try {
            if (!this.queryGeneralInformation()) {
                return false;
            }
            if (defaultFileNamePattern == null) {
                defaultFileNamePattern = this.assembleDefaultPattern();
            }
            if (!this.queryNames()) {
                return false;
            }
            if (showDebugFileNames && !this.debugShowFiles()) {
                return false;
            }
            if (this.calibration1 == 0 && this.calibration2 < 2 && !this.loadFirstCalibration() || this.calibration1 == 1 && this.calibration2 < 2 && !this.loadAllCalibrations()) {
                return false;
            }
            if (!this.queryDetails()) {
                return false;
            }
        }
        catch (ParseException e) {
            IOFunctions.println(e.toString());
            return false;
        }
        return true;
    }

    protected abstract StackImgLoader createAndInitImgLoader(String var1, File var2, ImgFactory<? extends NativeType<?>> var3, SequenceDescription var4);

    @Override
    public SpimData2 createDataset() {
        if (!this.queryInformation()) {
            return null;
        }
        TimePoints timepoints = this.createTimePoints();
        ArrayList<ViewSetup> setups = this.createViewSetups();
        MissingViews missingViews = this.createMissingViews();
        SequenceDescription sequenceDescription = new SequenceDescription(timepoints, setups, null, missingViews);
        StackImgLoader imgLoader = this.createAndInitImgLoader(".", new File(this.directory), this.imgFactory, sequenceDescription);
        sequenceDescription.setImgLoader((BasicImgLoader)imgLoader);
        double minResolution = Apply_Transformation.assembleAllMetaData(sequenceDescription, sequenceDescription.getViewDescriptions().values());
        IOFunctions.println("Minimal resolution in all dimensions over all views is: " + minResolution);
        IOFunctions.println("(The smallest resolution in any dimension; the distance between two pixels in the output image will be that wide)");
        ViewRegistrations viewRegistrations = StackList.createViewRegistrations(sequenceDescription.getViewDescriptions(), minResolution);
        ViewInterestPoints viewInterestPoints = new ViewInterestPoints();
        viewInterestPoints.createViewInterestPoints(sequenceDescription.getViewDescriptions());
        SpimData2 spimData = new SpimData2(new File(this.directory), sequenceDescription, viewRegistrations, viewInterestPoints, new BoundingBoxes());
        return spimData;
    }

    protected static ViewRegistrations createViewRegistrations(Map<ViewId, ViewDescription> viewDescriptionList, double minResolution) {
        HashMap<ViewRegistration, ViewRegistration> viewRegistrationList = new HashMap<ViewRegistration, ViewRegistration>();
        for (ViewDescription viewDescription : viewDescriptionList.values()) {
            if (!viewDescription.isPresent()) continue;
            ViewRegistration viewRegistration = new ViewRegistration(viewDescription.getTimePointId(), viewDescription.getViewSetupId());
            VoxelDimensions voxelSize = ((ViewSetup)viewDescription.getViewSetup()).getVoxelSize();
            double calX = voxelSize.dimension(0) / minResolution;
            double calY = voxelSize.dimension(1) / minResolution;
            double calZ = voxelSize.dimension(2) / minResolution;
            AffineTransform3D m = new AffineTransform3D();
            m.set(calX, 0.0, 0.0, 0.0, 0.0, calY, 0.0, 0.0, 0.0, 0.0, calZ, 0.0);
            ViewTransformAffine vt = new ViewTransformAffine("calibration", m);
            viewRegistration.preconcatenateTransform((ViewTransform)vt);
            viewRegistrationList.put(viewRegistration, viewRegistration);
        }
        return new ViewRegistrations(viewRegistrationList);
    }

    protected MissingViews createMissingViews() {
        if (this.exceptionIds.size() == 0) {
            return null;
        }
        ArrayList<ViewId> missingViews = new ArrayList<ViewId>();
        for (int t = 0; t < this.timepointNameList.size(); ++t) {
            ArrayList<int[]> tmp = new ArrayList<int[]>();
            for (int[] exceptions : this.exceptionIds) {
                if (exceptions[0] != t) continue;
                tmp.add(exceptions);
            }
            if (tmp.size() <= 0) continue;
            int setupId = 0;
            for (int c = 0; c < this.channelNameList.size(); ++c) {
                for (int i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (int a = 0; a < this.angleNameList.size(); ++a) {
                        for (int[] exceptions : tmp) {
                            if (exceptions[1] != c || exceptions[2] != i || exceptions[3] != a) continue;
                            missingViews.add(new ViewId(Integer.parseInt(this.timepointNameList.get(t)), setupId));
                            System.out.println("creating missing views t:" + Integer.parseInt(this.timepointNameList.get(t)) + " c:" + c + " i:" + i + " a:" + a + " setupid: " + setupId);
                        }
                        ++setupId;
                    }
                }
            }
        }
        return new MissingViews(missingViews);
    }

    protected ArrayList<ViewSetup> createViewSetups() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (int c = 0; c < this.channelNameList.size(); ++c) {
            channels.add(new Channel(c, this.channelNameList.get(c)));
        }
        ArrayList<Illumination> illuminations = new ArrayList<Illumination>();
        for (int i = 0; i < this.illuminationsNameList.size(); ++i) {
            illuminations.add(new Illumination(i, this.illuminationsNameList.get(i)));
        }
        ArrayList<Angle> angles = new ArrayList<Angle>();
        for (int a = 0; a < this.angleNameList.size(); ++a) {
            angles.add(new Angle(a, this.angleNameList.get(a)));
        }
        ArrayList<ViewSetup> viewSetups = new ArrayList<ViewSetup>();
        for (Channel c : channels) {
            for (Illumination i : illuminations) {
                for (Angle a : angles) {
                    Calibration cal = this.calibrations.get(new ViewSetupPrecursor(c.getId(), i.getId(), a.getId()));
                    FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(cal.calUnit, new double[]{cal.calX, cal.calY, cal.calZ});
                    viewSetups.add(new ViewSetup(viewSetups.size(), null, null, (VoxelDimensions)voxelSize, c, a, i));
                }
            }
        }
        return viewSetups;
    }

    protected TimePoints createTimePoints() {
        try {
            return new TimePointsPattern(this.timepoints);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean queryDetails() {
        block23: {
            Calibration cal;
            ViewSetupPrecursor vsp;
            int a;
            int i;
            int c;
            GenericDialog gd;
            block22: {
                gd = this.calibration2 == 0 ? null : new GenericDialog("Define dataset (3/3)");
                if (this.calibration1 != 0) break block22;
                Calibration cal2 = null;
                if (this.calibrations.values().size() != 1) {
                    cal2 = new Calibration();
                } else {
                    Iterator<Calibration> iterator = this.calibrations.values().iterator();
                    while (iterator.hasNext()) {
                        Calibration c2;
                        cal2 = c2 = iterator.next();
                    }
                }
                if (this.calibration2 > 0) {
                    gd.addMessage("Calibration (voxel size)", new Font("SansSerif", 1, 14));
                    if (this.calibration2 == 1) {
                        gd.addMessage("(read from file)", new Font("SansSerif", 2, 11));
                    }
                    gd.addMessage("");
                    gd.addNumericField("Pixel_distance_x", cal2.calX, 5);
                    gd.addNumericField("Pixel_distance_y", cal2.calY, 5);
                    gd.addNumericField("Pixel_distance_z", cal2.calZ, 5);
                    gd.addStringField("Pixel_unit", cal2.calUnit);
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return false;
                    }
                    cal2.calX = gd.getNextNumber();
                    cal2.calY = gd.getNextNumber();
                    cal2.calZ = gd.getNextNumber();
                    cal2.calUnit = gd.getNextString();
                } else {
                    IOFunctions.println("Calibration (voxel-size) read from file: x:" + cal2.calX + " y:" + cal2.calY + " z:" + cal2.calZ + " " + cal2.calUnit);
                }
                this.calibrations.clear();
                for (int c3 = 0; c3 < this.channelNameList.size(); ++c3) {
                    for (int i2 = 0; i2 < this.illuminationsNameList.size(); ++i2) {
                        for (int a2 = 0; a2 < this.angleNameList.size(); ++a2) {
                            this.calibrations.put(new ViewSetupPrecursor(c3, i2, a2), cal2);
                        }
                    }
                }
                break block23;
            }
            if (this.calibration2 > 0) {
                gd.addMessage("Calibrations", new Font("SansSerif", 1, 14));
                if (this.calibration2 == 1) {
                    gd.addMessage("(read from file)", new Font("SansSerif", 2, 11));
                }
                gd.addMessage("");
            }
            for (c = 0; c < this.channelNameList.size(); ++c) {
                for (i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (a = 0; a < this.angleNameList.size(); ++a) {
                        vsp = new ViewSetupPrecursor(c, i, a);
                        cal = this.calibrations.get(vsp);
                        if (cal == null) {
                            if (this.calibration2 < 2) {
                                IOFunctions.println("Could not read calibration for view: " + vsp);
                                IOFunctions.println("Replacing with uniform calibration.");
                            }
                            cal = new Calibration();
                            this.calibrations.put(vsp, cal);
                        }
                        if (this.calibration2 > 0) {
                            gd.addMessage("View [" + vsp + "]");
                            gd.addNumericField("Pixel_distance_x", cal.calX, 5);
                            gd.addNumericField("Pixel_distance_y", cal.calY, 5);
                            gd.addNumericField("Pixel_distance_z", cal.calZ, 5);
                            gd.addStringField("Pixel_unit", cal.calUnit);
                            gd.addMessage("");
                            continue;
                        }
                        IOFunctions.println("Calibration (voxel-size) read from file x:" + cal.calX + " y:" + cal.calY + " z:" + cal.calZ + " " + cal.calUnit + " for view " + vsp);
                    }
                }
            }
            if (this.calibration2 <= 0) break block23;
            GUIHelper.addScrollBars((Container)gd);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            for (c = 0; c < this.channelNameList.size(); ++c) {
                for (i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (a = 0; a < this.angleNameList.size(); ++a) {
                        vsp = new ViewSetupPrecursor(c, i, a);
                        cal = this.calibrations.get(vsp);
                        cal.calX = gd.getNextNumber();
                        cal.calY = gd.getNextNumber();
                        cal.calZ = gd.getNextNumber();
                        cal.calUnit = gd.getNextString();
                    }
                }
            }
        }
        return true;
    }

    protected boolean debugShowFiles() {
        int a;
        int i;
        int c;
        int t;
        GenericDialog gd = new GenericDialog("3d image stacks files");
        gd.addMessage("");
        gd.addMessage("Path: " + this.directory + "   ");
        gd.addMessage("Note: Not selected files will be treated as missing views (e.g. missing files).", GUIHelper.smallStatusFont);
        for (t = 0; t < this.timepointNameList.size(); ++t) {
            for (c = 0; c < this.channelNameList.size(); ++c) {
                for (i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (a = 0; a < this.angleNameList.size(); ++a) {
                        boolean select;
                        String fileName = this.getFileNameFor(t, c, i, a);
                        boolean fileExisits = new File(this.directory, fileName).exists();
                        String ext = "";
                        if (this.hasMultipleChannels > 0 && this.numDigitsChannels == 0) {
                            ext = ext + "c = " + this.channelNameList.get(c);
                        }
                        if (this.hasMultipleTimePoints > 0 && this.numDigitsTimepoints == 0) {
                            ext = ext.length() > 0 ? ext + ", t = " + this.timepointNameList.get(t) : ext + "t = " + this.timepointNameList.get(t);
                        }
                        if (this.hasMultipleIlluminations > 0 && this.numDigitsIlluminations == 0) {
                            ext = ext.length() > 0 ? ext + ", i = " + this.illuminationsNameList.get(i) : ext + "i = " + this.illuminationsNameList.get(i);
                        }
                        if (this.hasMultipleAngles > 0 && this.numDigitsAngles == 0) {
                            ext = ext.length() > 0 ? ext + ", a = " + this.angleNameList.get(a) : ext + "a = " + this.angleNameList.get(a);
                        }
                        if (ext.length() > 1) {
                            fileName = fileName + "   >> [" + ext + "]";
                        }
                        if (fileExisits) {
                            fileName = fileName + " (file found)";
                            select = true;
                        } else {
                            select = false;
                            fileName = fileName + " (file NOT found)";
                        }
                        gd.addCheckbox(fileName, select);
                        ((Checkbox)gd.getCheckboxes().lastElement()).setLabel(fileName);
                        if (fileExisits) continue;
                        ((Checkbox)gd.getCheckboxes().lastElement()).setBackground(GUIHelper.error);
                    }
                }
            }
        }
        GUIHelper.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.exceptionIds = new ArrayList();
        for (t = 0; t < this.timepointNameList.size(); ++t) {
            for (c = 0; c < this.channelNameList.size(); ++c) {
                for (i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (a = 0; a < this.angleNameList.size(); ++a) {
                        if (gd.getNextBoolean()) continue;
                        this.exceptionIds.add(new int[]{t, c, i, a});
                        System.out.println("adding missing views t:" + t + " c:" + c + " i:" + i + " a:" + a);
                    }
                }
            }
        }
        return true;
    }

    protected boolean queryNames() throws ParseException {
        GenericDialogPlus gd = new GenericDialogPlus("Define dataset (2/3)");
        gd.addDirectoryOrFileField("Image_File_directory", defaultDirectory, 40);
        gd.addStringField("Image_File_Pattern", defaultFileNamePattern, 40);
        if (this.hasMultipleTimePoints > 0) {
            gd.addStringField("Timepoints_", defaultTimepoints, 15);
        }
        if (this.hasMultipleChannels > 0) {
            gd.addStringField("Channels_", defaultChannels, 15);
        }
        if (this.hasMultipleIlluminations > 0) {
            gd.addStringField("Illumination_directions_", defaultIlluminations, 15);
        }
        if (this.hasMultipleAngles > 0) {
            gd.addStringField("Acquisition_angles_", defaultAngles, 15);
        }
        gd.addChoice("Calibration_Type", this.calibrationChoice1, this.calibrationChoice1[defaultCalibration1]);
        gd.addChoice("Calibration_Definition", this.calibrationChoice2, this.calibrationChoice2[defaultCalibration2]);
        gd.addChoice("ImgLib2_data_container", imglib2Container, imglib2Container[defaultContainer]);
        gd.addMessage("Use ArrayImg if -ALL- input views are smaller than ~2048x2048x500 px (2^31 px), or if the\nprogram throws an OutOfMemory exception while processing.  CellImg is slower, but more\nmemory efficient and supports much larger file sizes only limited by the RAM of the machine.", new Font("SansSerif", 2, 11));
        gd.addCheckbox("Show_list of filenames (to debug and it allows to deselect individual files)", showDebugFileNames);
        gd.addMessage("Note: this might take a few seconds if thousands of files are present", new Font("SansSerif", 2, 11));
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultDirectory = this.directory = gd.getNextString();
        defaultFileNamePattern = this.fileNamePattern = gd.getNextString();
        this.angles = null;
        this.illuminations = null;
        this.channels = null;
        this.timepoints = null;
        this.replaceAngles = null;
        this.replaceIlluminations = null;
        this.replaceChannels = null;
        this.replaceTimepoints = null;
        if (this.hasMultipleTimePoints > 0) {
            defaultTimepoints = this.timepoints = gd.getNextString();
            if (this.hasMultipleTimePoints == 1) {
                this.replaceTimepoints = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'t');
                if (this.replaceTimepoints == null) {
                    throw new ParseException("Pattern {t} not present in " + this.fileNamePattern + " although you indicated there would be several timepoints. Stopping.", 0);
                }
                this.numDigitsTimepoints = this.replaceTimepoints.length() - 2;
            } else {
                this.replaceTimepoints = null;
                this.numDigitsTimepoints = 0;
            }
        }
        if (this.hasMultipleChannels > 0) {
            defaultChannels = this.channels = gd.getNextString();
            if (this.hasMultipleChannels == 1) {
                this.replaceChannels = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'c');
                if (this.replaceChannels == null) {
                    throw new ParseException("Pattern {c} not present in " + this.fileNamePattern + " although you indicated there would be several channels. Stopping.", 0);
                }
                this.numDigitsChannels = this.replaceChannels.length() - 2;
            } else {
                this.replaceChannels = null;
                this.numDigitsChannels = 0;
            }
        }
        if (this.hasMultipleIlluminations > 0) {
            defaultIlluminations = this.illuminations = gd.getNextString();
            if (this.hasMultipleIlluminations == 1) {
                this.replaceIlluminations = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'i');
                if (this.replaceIlluminations == null) {
                    throw new ParseException("Pattern {i} not present in " + this.fileNamePattern + " although you indicated there would be several illumination directions. Stopping.", 0);
                }
                this.numDigitsIlluminations = this.replaceIlluminations.length() - 2;
            } else {
                this.replaceIlluminations = null;
                this.numDigitsIlluminations = 0;
            }
        }
        if (this.hasMultipleAngles > 0) {
            defaultAngles = this.angles = gd.getNextString();
            if (this.hasMultipleAngles == 1) {
                this.replaceAngles = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'a');
                if (this.replaceAngles == null) {
                    throw new ParseException("Pattern {a} not present in " + this.fileNamePattern + " although you indicated there would be several angles.", 0);
                }
                this.numDigitsAngles = this.replaceAngles.length() - 2;
            } else {
                this.replaceAngles = null;
                this.numDigitsAngles = 0;
            }
        }
        this.timepointNameList = NamePattern.parseNameString(this.timepoints, false);
        this.channelNameList = NamePattern.parseNameString(this.channels, true);
        this.illuminationsNameList = NamePattern.parseNameString(this.illuminations, true);
        this.angleNameList = NamePattern.parseNameString(this.angles, true);
        this.exceptionIds = new ArrayList();
        defaultCalibration1 = this.calibration1 = gd.getNextChoiceIndex();
        defaultCalibration2 = this.calibration2 = gd.getNextChoiceIndex();
        defaultContainer = gd.getNextChoiceIndex();
        this.imgFactory = defaultContainer == 0 ? new ArrayImgFactory() : new CellImgFactory(new int[]{256});
        showDebugFileNames = gd.getNextBoolean();
        return true;
    }

    public static ArrayList<String> convertIntegerList(List<Integer> list) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i : list) {
            stringList.add(Integer.toString(i));
        }
        return stringList;
    }

    protected String getFileNameFor(int tpID, int chID, int illID, int angleID) {
        return StackList.getFileNamesFor(this.fileNamePattern, this.replaceTimepoints, this.replaceChannels, this.replaceIlluminations, this.replaceAngles, this.timepointNameList.get(tpID), this.channelNameList.get(chID), this.illuminationsNameList.get(illID), this.angleNameList.get(angleID), this.numDigitsTimepoints, this.numDigitsChannels, this.numDigitsIlluminations, this.numDigitsAngles)[0];
    }

    public static String[] getFileNamesFor(String fileNames, String replaceTimepoints, String replaceChannels, String replaceIlluminations, String replaceAngles, String tpName, String chName, String illName, String angleName, int numDigitsTP, int numDigitsCh, int numDigitsIll, int numDigitsAngle) {
        String[] fileName = fileNames.split(";");
        for (int i = 0; i < fileName.length; ++i) {
            if (replaceTimepoints != null) {
                fileName[i] = fileName[i].replace(replaceTimepoints, StackList.leadingZeros(tpName, numDigitsTP));
            }
            if (replaceChannels != null) {
                fileName[i] = fileName[i].replace(replaceChannels, StackList.leadingZeros(chName, numDigitsCh));
            }
            if (replaceIlluminations != null) {
                fileName[i] = fileName[i].replace(replaceIlluminations, StackList.leadingZeros(illName, numDigitsIll));
            }
            if (replaceAngles == null) continue;
            fileName[i] = fileName[i].replace(replaceAngles, StackList.leadingZeros(angleName, numDigitsAngle));
        }
        return fileName;
    }

    public static String leadingZeros(String s, int numDigits) {
        while (s.length() < numDigits) {
            s = "0" + s;
        }
        return s;
    }

    protected boolean loadFirstCalibration() {
        for (int t = 0; t < this.timepointNameList.size(); ++t) {
            for (int c = 0; c < this.channelNameList.size(); ++c) {
                for (int i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (int a = 0; a < this.angleNameList.size(); ++a) {
                        if (this.exceptionIds.size() > 0 && this.exceptionIds.get(0)[0] == t && this.exceptionIds.get(0)[1] == c && this.exceptionIds.get(0)[2] == t && this.exceptionIds.get(0)[3] == a) continue;
                        Calibration cal = this.loadCalibration(new File(this.directory, this.getFileNameFor(t, c, i, a)));
                        if (cal == null) {
                            return false;
                        }
                        this.calibrations.put(new ViewSetupPrecursor(c, i, a), cal);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean loadAllCalibrations() {
        for (int t = 0; t < this.timepointNameList.size(); ++t) {
            for (int c = 0; c < this.channelNameList.size(); ++c) {
                for (int i = 0; i < this.illuminationsNameList.size(); ++i) {
                    for (int a = 0; a < this.angleNameList.size(); ++a) {
                        Calibration cal;
                        ViewSetupPrecursor vsp;
                        if (this.exceptionIds.size() > 0 && this.exceptionIds.get(0)[0] == t && this.exceptionIds.get(0)[1] == c && this.exceptionIds.get(0)[2] == t && this.exceptionIds.get(0)[3] == a || this.calibrations.get(vsp = new ViewSetupPrecursor(c, i, a)) != null || (cal = this.loadCalibration(new File(this.directory, this.getFileNameFor(t, c, i, a)))) == null) continue;
                        this.calibrations.put(vsp, cal);
                    }
                }
            }
        }
        return true;
    }

    protected abstract Calibration loadCalibration(File var1);

    protected String assembleDefaultPattern() {
        String pattern = "spim";
        if (this.hasMultipleTimePoints == 1) {
            pattern = pattern + "_TL{t}";
        }
        if (this.hasMultipleChannels == 1) {
            pattern = pattern + "_Channel{c}";
        }
        if (this.hasMultipleIlluminations == 1) {
            pattern = pattern + "_Illum{i}";
        }
        if (this.hasMultipleAngles == 1) {
            pattern = pattern + "_Angle{a}";
        }
        return pattern + ".tif";
    }

    protected boolean queryGeneralInformation() {
        GenericDialogPlus gd = new GenericDialogPlus("Define dataset (1/3)");
        Color green = new Color(0, 139, 14);
        Color red = Color.RED;
        gd.addMessage("File reader: " + this.getTitle(), new Font("SansSerif", 1, 14));
        gd.addMessage("");
        if (this.supportsMultipleTimepointsPerFile()) {
            if (this.getDefaultMultipleTimepoints() >= this.dimensionChoiceTimePointsTrue.length) {
                this.setDefaultMultipleTimepoints(0);
            }
            gd.addMessage("Supports multiple timepoints per file", new Font("SansSerif", 2, 11), green);
            gd.addChoice("Multiple_timepoints", this.dimensionChoiceTimePointsTrue, this.dimensionChoiceTimePointsTrue[this.getDefaultMultipleTimepoints()]);
        } else {
            if (this.getDefaultMultipleTimepoints() >= this.dimensionChoiceTimePointsFalse.length) {
                this.setDefaultMultipleTimepoints(0);
            }
            gd.addMessage("NO support for multiple timepoints per file", new Font("SansSerif", 2, 11), red);
            gd.addChoice("Multiple_timepoints", this.dimensionChoiceTimePointsFalse, this.dimensionChoiceTimePointsFalse[this.getDefaultMultipleTimepoints()]);
        }
        gd.addMessage("");
        if (this.supportsMultipleChannelsPerFile()) {
            if (this.getDefaultMultipleChannels() >= this.dimensionChoiceChannelsTrue.length) {
                this.setDefaultMultipleChannels(0);
            }
            gd.addMessage("Supports multiple channels per file", new Font("SansSerif", 2, 11), green);
            gd.addChoice("Multiple_channels", this.dimensionChoiceChannelsTrue, this.dimensionChoiceChannelsTrue[this.getDefaultMultipleChannels()]);
        } else {
            if (this.getDefaultMultipleChannels() >= this.dimensionChoiceChannelsFalse.length) {
                this.setDefaultMultipleChannels(0);
            }
            gd.addMessage("NO support for multiple channels per file", new Font("SansSerif", 2, 11), red);
            gd.addChoice("Multiple_channels", this.dimensionChoiceChannelsFalse, this.dimensionChoiceChannelsFalse[this.getDefaultMultipleChannels()]);
        }
        gd.addMessage("");
        if (this.supportsMultipleIlluminationsPerFile()) {
            if (this.getDefaultMultipleIlluminations() >= this.dimensionChoiceIlluminationsTrue.length) {
                this.setDefaultMultipleIlluminations(0);
            }
            gd.addMessage("Supports multiple illumination directions per file", new Font("SansSerif", 2, 11), green);
            gd.addChoice("_____Multiple_illumination_directions", this.dimensionChoiceIlluminationsTrue, this.dimensionChoiceIlluminationsTrue[this.getDefaultMultipleIlluminations()]);
        } else {
            if (this.getDefaultMultipleIlluminations() >= this.dimensionChoiceIlluminationsFalse.length) {
                this.setDefaultMultipleIlluminations(0);
            }
            gd.addMessage("NO support for multiple illumination directions per file", new Font("SansSerif", 2, 11), red);
            gd.addChoice("_____Multiple_illumination_directions", this.dimensionChoiceIlluminationsFalse, this.dimensionChoiceIlluminationsFalse[this.getDefaultMultipleIlluminations()]);
        }
        gd.addMessage("");
        if (this.supportsMultipleAnglesPerFile()) {
            if (this.getDefaultMultipleAngles() >= this.dimensionChoiceAnglesTrue.length) {
                this.setDefaultMultipleAngles(0);
            }
            gd.addMessage("Supports multiple angles per file", new Font("SansSerif", 2, 11), green);
            gd.addChoice("Multiple_angles", this.dimensionChoiceAnglesTrue, this.dimensionChoiceAnglesTrue[this.getDefaultMultipleAngles()]);
        } else {
            if (this.getDefaultMultipleAngles() >= this.dimensionChoiceAnglesFalse.length) {
                this.setDefaultMultipleAngles(0);
            }
            gd.addMessage("NO support for multiple angles per file", new Font("SansSerif", 2, 11), red);
            gd.addChoice("Multiple_angles", this.dimensionChoiceAnglesFalse, this.dimensionChoiceAnglesFalse[this.getDefaultMultipleAngles()]);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.hasMultipleTimePoints = gd.getNextChoiceIndex();
        this.hasMultipleChannels = gd.getNextChoiceIndex();
        this.hasMultipleIlluminations = gd.getNextChoiceIndex();
        this.hasMultipleAngles = gd.getNextChoiceIndex();
        this.setDefaultMultipleTimepoints(this.hasMultipleTimePoints);
        this.setDefaultMultipleChannels(this.hasMultipleChannels);
        this.setDefaultMultipleIlluminations(this.hasMultipleIlluminations);
        this.setDefaultMultipleAngles(this.hasMultipleAngles);
        return true;
    }

    protected class ViewSetupPrecursor {
        public final int c;
        public final int i;
        public final int a;

        public ViewSetupPrecursor(int c, int i, int a) {
            this.c = c;
            this.i = i;
            this.a = a;
        }

        public int hashCode() {
            return this.c * StackList.this.illuminationsNameList.size() * StackList.this.angleNameList.size() + this.i * StackList.this.angleNameList.size() + this.a;
        }

        public boolean equals(Object o) {
            if (o instanceof ViewSetupPrecursor) {
                return this.c == ((ViewSetupPrecursor)o).c && this.i == ((ViewSetupPrecursor)o).i && this.a == ((ViewSetupPrecursor)o).a;
            }
            return false;
        }

        public String toString() {
            return "channel=" + StackList.this.channelNameList.get(this.c) + ", ill.dir.=" + StackList.this.illuminationsNameList.get(this.i) + ", angle=" + StackList.this.angleNameList.get(this.a);
        }
    }

    protected class Calibration {
        public double calX;
        public double calY;
        public double calZ;
        public String calUnit;

        public Calibration(double calX, double calY, double calZ, String calUnit) {
            this.calX = 1.0;
            this.calY = 1.0;
            this.calZ = 1.0;
            this.calUnit = "um";
            this.calX = calX;
            this.calY = calY;
            this.calZ = calZ;
            this.calUnit = calUnit;
        }

        public Calibration(double calX, double calY, double calZ) {
            this.calX = 1.0;
            this.calY = 1.0;
            this.calZ = 1.0;
            this.calUnit = "um";
            this.calX = calX;
            this.calY = calY;
            this.calZ = calZ;
        }

        public Calibration() {
            this.calX = 1.0;
            this.calY = 1.0;
            this.calZ = 1.0;
            this.calUnit = "um";
        }
    }
}

