/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.boundingbox;

import ij.gui.GenericDialog;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.plugin.Visualize_Detections;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.ImgExport;
import spim.process.interestpointregistration.ChannelProcess;
import spim.vecmath.AxisAngle4d;
import spim.vecmath.Matrix4d;
import spim.vecmath.Point3d;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3d;

public class AutomaticReorientation
extends BoundingBoxGUI {
    public static String reorientationDescription = "Reorientation to minimize bounding box";
    public String[] reorientationChoice = new String[]{"Automatically reorientate the sample (and store transformation for all views in the XML)", "Automatically reorientate the sample (and store transformation only for fused views in the XML)", "Automatically reorientate the sample (just temporarily, do NOT store transformation in XML)", "Do NOT reorientate the sample"};
    public static int defaultReorientate = 0;
    public static boolean defaultSaveReorientation = true;
    public static int defaultDetections = 1;
    public static double defaultPercent = 10.0;
    int reorientate;
    List<ViewId> viewIdsToApply;

    public AutomaticReorientation(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
    }

    @Override
    public boolean cleanUp() {
        if (this.reorientate == 0 || this.reorientate == 1) {
            return true;
        }
        if (this.reorientate == 2) {
            if (this.viewIdsToApply == null) {
                IOFunctions.println("Something went wrong, the viewIdsToApply list is null.");
            } else {
                for (ViewId viewId : this.viewIdsToApply) {
                    ViewDescription vd = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(viewId);
                    if (!vd.isPresent()) continue;
                    ViewRegistration r = this.spimData.getViewRegistrations().getViewRegistration(viewId);
                    List vtl = r.getTransformList();
                    vtl.remove(0);
                    r.updateModel();
                }
            }
        }
        return this.changedSpimDataObject;
    }

    @Override
    public boolean queryParameters(Fusion fusion, ImgExport imgExport) {
        double[] maxF;
        double[] minF;
        GenericDialog gd = new GenericDialog("Bounding Box Definition");
        Pair<Integer, Integer> reorientated = this.numReorientated();
        String note = (Integer)reorientated.getA() == 0 ? "None" : (((Integer)reorientated.getA()).intValue() == ((Integer)reorientated.getB()).intValue() ? "All" : (Integer)reorientated.getA() + " of " + (Integer)reorientated.getB());
        gd.addMessage("Note: " + note + " of the views are already reorientated.", new Font("SansSerif", 1, 13));
        gd.addChoice("Reorientation", this.reorientationChoice, this.reorientationChoice[defaultReorientate]);
        gd.addMessage("");
        gd.addMessage("Note: The bounding box is estimated based on detections in the image, choose which ones to use.", new Font("SansSerif", 1, 13));
        ArrayList<Channel> channels = SpimData2.getAllChannelsSorted(this.spimData, this.viewIdsToProcess);
        boolean labelsWereReset = false;
        if (Interest_Point_Registration.defaultChannelLabels == null || Interest_Point_Registration.defaultChannelLabels.length != channels.size()) {
            Interest_Point_Registration.defaultChannelLabels = new int[channels.size()];
            labelsWereReset = true;
        }
        ArrayList<String[]> channelLabels = new ArrayList<String[]>();
        int j = 0;
        for (Channel channel : channels) {
            String[] labels = Interest_Point_Registration.getAllInterestPointLabelsForChannel(this.spimData, this.viewIdsToProcess, channel, "use any detections from");
            if (labels == null) {
                return false;
            }
            if (Interest_Point_Registration.defaultChannelLabels[j] >= labels.length) {
                Interest_Point_Registration.defaultChannelLabels[j] = 0;
            }
            if (labelsWereReset && labels[Interest_Point_Registration.defaultChannelLabels[j]].contains("bead")) {
                Interest_Point_Registration.defaultChannelLabels[j] = labels.length - 2;
            }
            if (Interest_Point_Registration.defaultChannelLabels[j] < labels.length) {
                Interest_Point_Registration.defaultChannelLabels[j] = 0;
            }
            String ch = channel.getName().replace(' ', '_');
            gd.addChoice("Interest_points_channel_" + ch, labels, labels[Interest_Point_Registration.defaultChannelLabels[j++]]);
            channelLabels.add(labels);
        }
        gd.addChoice("Use", Visualize_Detections.detectionsChoice, Visualize_Detections.detectionsChoice[defaultDetections]);
        gd.addMessage("");
        gd.addMessage("Note: The detections themselves should not lie on the edge of the bounding box, please define how\nmuch bigger [in percent of the largest dimension] the bounding box should be. If you want to define it\nin pixels, use the following dialog and put 0% here.", new Font("SansSerif", 1, 13));
        gd.addSlider("Additional_size [%]", 0.0, 100.0, defaultPercent);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.reorientate = defaultReorientate = gd.getNextChoiceIndex();
        ArrayList<ChannelProcess> channelsToUse = new ArrayList<ChannelProcess>();
        j = 0;
        for (Channel channel : channels) {
            Interest_Point_Registration.defaultChannelLabels[channel.getId()] = gd.getNextChoiceIndex();
            int channelChoice = Interest_Point_Registration.defaultChannelLabels[channel.getId()];
            if (channelChoice < ((String[])channelLabels.get(j)).length - 1) {
                Object label = ((String[])channelLabels.get(j))[channelChoice];
                if (((String)label).contains(" (WARNING: Only available for ")) {
                    label = ((String)label).substring(0, ((String)label).indexOf(" (WARNING: Only available for "));
                }
                channelsToUse.add(new ChannelProcess(channel, (String)label));
            }
            ++j;
        }
        if (channelsToUse.size() == 0) {
            IOFunctions.println("No channels selected. Quitting.");
            return false;
        }
        int n = defaultDetections = gd.getNextChoiceIndex();
        double percent = defaultPercent = gd.getNextNumber();
        for (ChannelProcess c : channelsToUse) {
            IOFunctions.println("using from channel: " + c.getChannel().getId() + " label: '" + c.getLabel() + "', " + (n == 0 ? "all detections." : "only corresponding detections."));
        }
        if (this.reorientate == 3) {
            Pair<double[], double[]> minmax = this.determineSizeSimple(channelsToUse, n);
            if (minmax == null) {
                return false;
            }
            minF = (double[])minmax.getA();
            maxF = (double[])minmax.getB();
        } else {
            Pair<AffineTransform3D, double[]> pair = this.determineOptimalBoundingBox(channelsToUse, n);
            if (pair == null) {
                return false;
            }
            IOFunctions.println("Final transformation model: " + pair.getA());
            if (this.reorientate == 0) {
                this.viewIdsToApply = SpimData2.getAllViewIdsSorted(this.spimData, ((SequenceDescription)this.spimData.getSequenceDescription()).getViewSetupsOrdered(), ((SequenceDescription)this.spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered());
                IOFunctions.println("Will be applied only to all views and remembered/saved to the XML.");
            } else {
                this.viewIdsToApply = this.viewIdsToProcess;
                if (this.reorientate == 1) {
                    IOFunctions.println("Will be applied only to fused views and remembered/saved to the XML.");
                } else {
                    IOFunctions.println("Will be temporarily applied only to fused views (NOT remembered in the XML).");
                }
            }
            for (ViewId viewId : this.viewIdsToApply) {
                ViewDescription vd = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(viewId);
                if (!vd.isPresent()) continue;
                ViewRegistration r = this.spimData.getViewRegistrations().getViewRegistration(viewId);
                r.preconcatenateTransform((ViewTransform)new ViewTransformAffine(reorientationDescription, (AffineTransform3D)pair.getA()));
                r.updateModel();
            }
            minF = new double[]{((double[])pair.getB())[0], ((double[])pair.getB())[1], ((double[])pair.getB())[2]};
            maxF = new double[]{((double[])pair.getB())[3], ((double[])pair.getB())[4], ((double[])pair.getB())[5]};
        }
        IOFunctions.println("Min (without addition): " + Util.printCoordinates((double[])minF));
        IOFunctions.println("Max (without addition): " + Util.printCoordinates((double[])maxF));
        this.min = new int[3];
        this.max = new int[3];
        double addX = (maxF[0] - minF[0]) * (percent / 100.0) / 2.0;
        double addY = (maxF[1] - minF[1]) * (percent / 100.0) / 2.0;
        double addZ = (maxF[2] - minF[2]) * (percent / 100.0) / 2.0;
        double add = Math.max(addX, Math.max(addY, addZ));
        this.min[0] = (int)Math.round(minF[0] - add);
        this.min[1] = (int)Math.round(minF[1] - add);
        this.min[2] = (int)Math.round(minF[2] - add);
        this.max[0] = (int)Math.round(maxF[0] + add);
        this.max[1] = (int)Math.round(maxF[1] + add);
        this.max[2] = (int)Math.round(maxF[2] + add);
        IOFunctions.println("Min (with addition): " + Util.printCoordinates((int[])this.min));
        IOFunctions.println("Max (with addition): " + Util.printCoordinates((int[])this.max));
        BoundingBoxGUI.defaultMin = (int[])this.min.clone();
        BoundingBoxGUI.defaultMax = (int[])this.max.clone();
        return super.queryParameters(fusion, imgExport);
    }

    protected Pair<AffineTransform3D, double[]> determineOptimalBoundingBox(ArrayList<ChannelProcess> channelsToUse, int detections) {
        List<double[]> points = this.getAllDetectionsInGlobalCoordinates(channelsToUse, detections);
        if (points.size() < 1) {
            IOFunctions.println("At least one point is required. Stopping");
            return null;
        }
        double[] p1 = points.get(0);
        double[] p2 = points.get(1);
        double maxDist = AutomaticReorientation.squareDistance(p1[0], p1[1], p1[2], p2[0], p2[1], p2[2]);
        for (int i = 0; i < points.size() - 1; ++i) {
            for (int j = i + 1; j < points.size(); ++j) {
                double[] b;
                double[] a = points.get(i);
                double d = AutomaticReorientation.squareDistance(a[0], a[1], a[2], (b = points.get(j))[0], b[1], b[2]);
                if (!(d > maxDist)) continue;
                maxDist = d;
                if (a[0] <= b[0]) {
                    p1 = a;
                    p2 = b;
                    continue;
                }
                p1 = b;
                p2 = a;
            }
        }
        Vector3d sv = new Vector3d(p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]);
        sv.normalize();
        IOFunctions.println("Maximum distance: " + Math.sqrt(maxDist) + "px between points " + Util.printCoordinates((double[])p1) + " and " + Util.printCoordinates((double[])p2) + ", vector=" + sv + ", volume=" + (Double)this.testAxis(sv, points).getA() / 1048576.0 + "MiPixels.");
        double[] vectorStep = new double[]{0.4, 0.2, 0.1, 0.05, 0.025, 0.01, 0.005, 0.001};
        double minVolume = Double.MAX_VALUE;
        double[] minBoundingBox = null;
        for (int stepIndex = 0; stepIndex < vectorStep.length; ++stepIndex) {
            double step = vectorStep[stepIndex];
            Vector3d bestSV = new Vector3d(sv);
            for (int zi = -1; zi <= 1; ++zi) {
                for (int yi = -1; yi <= 1; ++yi) {
                    for (int xi = -1; xi <= 1; ++xi) {
                        Vector3d v = new Vector3d(sv.x + (double)xi * step, sv.y + (double)yi * step, sv.z + (double)zi * step);
                        v.normalize();
                        Pair<Double, double[]> volume = this.testAxis(v, points);
                        if (!((Double)volume.getA() < minVolume)) continue;
                        minVolume = (Double)volume.getA();
                        minBoundingBox = (double[])volume.getB();
                        bestSV.set(v);
                        IOFunctions.println("Scale: " + step + " --- Min Volume: " + minVolume / 1048576.0 + "MiPixels, vector=" + bestSV);
                    }
                }
            }
            sv.set(bestSV);
        }
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        Matrix4d m = new Matrix4d();
        AutomaticReorientation.getRotation(sv, xAxis).get(m);
        AffineTransform3D a = new AffineTransform3D();
        a.set(m.m00, m.m01, m.m02, m.m03, m.m10, m.m11, m.m12, m.m13, m.m20, m.m21, m.m22, m.m23);
        return new ValuePair((Object)a, minBoundingBox);
    }

    protected Pair<Double, double[]> testAxis(Vector3d v, List<double[]> points) {
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        Transform3D t = AutomaticReorientation.getRotation(v, xAxis);
        Point3d tmp = new Point3d();
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (double[] p : points) {
            tmp.set(p[0], p[1], p[2]);
            t.transform(tmp);
            minX = Math.min(minX, tmp.x);
            minY = Math.min(minY, tmp.y);
            minZ = Math.min(minZ, tmp.z);
            maxX = Math.max(maxX, tmp.x);
            maxY = Math.max(maxY, tmp.y);
            maxZ = Math.max(maxZ, tmp.z);
        }
        return new ValuePair((Object)((maxX - minX) * (maxY - minY) * (maxZ - minZ)), (Object)new double[]{minX, minY, minZ, maxX, maxY, maxZ});
    }

    public static Transform3D getRotation(Vector3d v0, Vector3d v1) {
        Vector3d rotAxis = new Vector3d();
        rotAxis.cross(v0, v1);
        rotAxis.normalize();
        if (Double.isNaN(rotAxis.x)) {
            return new Transform3D();
        }
        double angle = v0.dot(v1);
        Transform3D t = new Transform3D();
        t.set(new AxisAngle4d(rotAxis, Math.acos(angle)));
        return t;
    }

    public static final double squareDistance(double p1x, double p1y, double p1z, double p2x, double p2y, double p2z) {
        double dx = p1x - p2x;
        double dy = p1y - p2y;
        double dz = p1z - p2z;
        return dx * dx + dy * dy + dz * dz;
    }

    protected Pair<double[], double[]> determineSizeSimple(ArrayList<ChannelProcess> channelsToUse, int detections) {
        List<double[]> points = this.getAllDetectionsInGlobalCoordinates(channelsToUse, detections);
        if (points.size() < 1) {
            IOFunctions.println("At least one point is required. Stopping");
            return null;
        }
        double[] min = (double[])points.get(0).clone();
        double[] max = (double[])min.clone();
        for (double[] p : points) {
            for (int d = 0; d < p.length; ++d) {
                min[d] = Math.min(min[d], p[d]);
                max[d] = Math.max(max[d], p[d]);
            }
        }
        IOFunctions.println("Min (direct): " + Util.printCoordinates((double[])min));
        IOFunctions.println("Max (direct): " + Util.printCoordinates((double[])max));
        return new ValuePair((Object)min, (Object)max);
    }

    protected List<double[]> getAllDetectionsInGlobalCoordinates(ArrayList<ChannelProcess> channelsToUse, int detections) {
        ArrayList<double[]> ipList = new ArrayList<double[]>();
        for (ChannelProcess c : channelsToUse) {
            for (ViewDescription vd : SpimData2.getAllViewIdsForChannelSorted(this.spimData, this.viewIdsToProcess, c.getChannel())) {
                if (!vd.isPresent()) continue;
                ViewRegistration r = this.spimData.getViewRegistrations().getViewRegistration((ViewId)vd);
                r.updateModel();
                AffineTransform3D transform = r.getModel();
                ViewInterestPointLists vipl = this.spimData.getViewInterestPoints().getViewInterestPointLists((ViewId)vd);
                InterestPointList ipl = vipl.getInterestPointList(c.getLabel());
                if (ipl.getInterestPoints() == null) {
                    ipl.loadInterestPoints();
                }
                List<InterestPoint> list = ipl.getInterestPoints();
                if (detections == 0) {
                    for (InterestPoint interestPoint : list) {
                        double[] source = interestPoint.getL();
                        double[] target = new double[source.length];
                        transform.apply(source, target);
                        ipList.add(target);
                    }
                    continue;
                }
                if (ipl.getCorrespondingInterestPoints() == null) {
                    ipl.loadCorrespondingInterestPoints();
                }
                HashMap<Integer, InterestPoint> map = new HashMap<Integer, InterestPoint>();
                for (InterestPoint ip : list) {
                    map.put(ip.getId(), ip);
                }
                List<CorrespondingInterestPoints> list2 = ipl.getCorrespondingInterestPoints();
                for (CorrespondingInterestPoints cp : list2) {
                    InterestPoint p3 = (InterestPoint)((Object)map.get(cp.getDetectionId()));
                    double[] source = p3.getL();
                    double[] target = new double[source.length];
                    transform.apply(source, target);
                    ipList.add(target);
                }
            }
        }
        return ipList;
    }

    protected Pair<Integer, Integer> numReorientated() {
        ViewRegistrations vrs = this.spimData.getViewRegistrations();
        int isReorientated = 0;
        int sumViews = 0;
        for (ViewId viewId : this.viewIdsToProcess) {
            ViewDescription vd = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent()) continue;
            ViewRegistration vr = vrs.getViewRegistration(viewId);
            ViewTransform vt = (ViewTransform)vr.getTransformList().get(0);
            ++sumViews;
            if (!vt.hasName() || !vt.getName().startsWith(reorientationDescription)) continue;
            ++isReorientated;
        }
        return new ValuePair((Object)isReorientated, (Object)sumViews);
    }

    @Override
    public AutomaticReorientation newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new AutomaticReorientation(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Automatically reorientate and estimate based on sample features";
    }

    public static enum Reorientation {
        NONE,
        PARTLY,
        ALL;

    }
}

