/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.imagej.Dataset;
import net.imagej.ImageJService;
import net.imagej.axis.Axes;
import net.imagej.display.DatasetView;
import net.imagej.notebook.Images;
import net.imagej.notebook.NotebookTable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.table.Table;
import org.scijava.table.Tables;

public interface NotebookService
extends ImageJService {
    public Object display(Object var1);

    default public Object display(Map<?, ?> map) {
        return this.display(map, null);
    }

    default public <T> Object display(Map<?, T> map, String colHeader) {
        Table table = Tables.wrap(map, (String)colHeader);
        return this.display(table);
    }

    default public Object display(List<?> list) {
        return this.display(list, null, null);
    }

    default public Object display(List<?> list, String colHeader) {
        return this.display(list, colHeader, null);
    }

    default public Object display(List<?> list, List<String> rowHeaders) {
        return this.display(list, null, rowHeaders);
    }

    default public <T> Object display(List<T> list, String colHeader, List<String> rowHeaders) {
        Object table;
        if (list.isEmpty()) {
            table = Tables.wrap(list, (String)colHeader, rowHeaders);
        } else if (list.get(0) instanceof List) {
            List<T> data = list;
            ArrayList<Object> tables = new ArrayList<Object>(data.size());
            for (List item : data) {
                Object renderedItem = this.display(item, colHeader, rowHeaders);
                tables.add(renderedItem);
            }
            table = tables;
        } else if (list.get(0) instanceof Map) {
            List<T> data = list;
            table = Tables.wrap(data, rowHeaders);
        } else {
            table = Tables.wrap(list, (String)colHeader, rowHeaders);
        }
        return this.display(table);
    }

    default public Object display(Dataset source) {
        return Images.bufferedImage(source);
    }

    default public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> source) {
        return Images.bufferedImage(source);
    }

    default public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> source, double min, double max) {
        return Images.bufferedImage(source, min, max);
    }

    default public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> source, double[] min, double[] max) {
        return Images.bufferedImage(source, min, max);
    }

    default public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> source, int xAxis, int yAxis, int cAxis, ValueScaling scaling, long ... pos) {
        return Images.bufferedImage(source, xAxis, yAxis, cAxis, scaling, pos);
    }

    default public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> source, int xAxis, int yAxis, int cAxis, double[] min, double[] max, long ... pos) {
        return Images.bufferedImage(source, xAxis, yAxis, cAxis, min, max, pos);
    }

    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> mosaic(int[] var1, RandomAccessibleInterval<T> ... var2);

    default public NotebookTable methods(Object o) {
        if (o == null) {
            return null;
        }
        return this.methods(o.getClass());
    }

    default public NotebookTable methods(Object o, String prefix) {
        if (o == null) {
            return null;
        }
        return this.methods(o.getClass(), prefix);
    }

    default public NotebookTable methods(Class<?> type) {
        return this.methods(type, "");
    }

    public NotebookTable methods(Class<?> var1, String var2);

    default public DatasetView view(RandomAccessibleInterval<?> source) {
        Object element = Util.getTypeFromInterval(source);
        if (element instanceof ARGBType) {
            return this.viewRealType(Converters.argbChannels(source, (int[])new int[]{1, 2, 3}));
        }
        if (element instanceof RealType) {
            return this.viewRealType(source);
        }
        throw new IllegalArgumentException("Unsupported image type: " + element.getClass().getName());
    }

    default public DatasetView view(RandomAccessibleInterval<?> source, double min, double max) {
        DatasetView output = this.view(source);
        output.setChannelRanges(min, max);
        output.rebuild();
        return output;
    }

    default public DatasetView view(RandomAccessibleInterval<?> source, double[] min, double[] max) {
        if (min.length < source.numDimensions() || max.length < source.numDimensions()) {
            throw new IllegalArgumentException("Channel maximum and minimum arrays do not match image dimensions!");
        }
        DatasetView output = this.view(source);
        int c = 0;
        while ((long)c < output.getData().dimension(Axes.CHANNEL)) {
            output.setChannelRange(c, min[c], max[c]);
            ++c;
        }
        output.rebuild();
        return output;
    }

    public <T extends RealType<T>> DatasetView viewRealType(RandomAccessibleInterval<T> var1);

    public static enum ValueScaling {
        AUTO,
        FULL,
        DATA;

    }
}

