/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.scijava.util.ColorRGB;

public class ChannelCollection {
    private List<Double> channelInfos = new LinkedList<Double>();
    private boolean areInteger;

    public ChannelCollection() {
        this(new LinkedList<Double>());
    }

    public ChannelCollection(List<Double> values) {
        this.channelInfos.addAll(values);
        if (this.channelInfos.size() == 0) {
            this.channelInfos.add(0.0);
        }
        this.areInteger = true;
        for (Double value : this.channelInfos) {
            this.areInteger &= value == Math.floor(value);
        }
    }

    public ChannelCollection(ColorRGB color) {
        this(Arrays.asList(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public long getChannelCount() {
        return this.channelInfos.size();
    }

    public double getChannelValue(long chan) {
        if (chan > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("too many channels: " + chan);
        }
        if (chan >= (long)this.channelInfos.size()) {
            return 0.0;
        }
        return this.channelInfos.get((int)chan);
    }

    public boolean areInteger() {
        return this.areInteger;
    }
}

