/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imagej.types.DataTypeService;
import net.imglib2.type.numeric.NumericType;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultDataTypeService
extends AbstractSingletonService<DataType<?>>
implements DataTypeService {
    private Map<String, DataType<?>> typesByName;
    private Map<Class<?>, DataType<?>> typesByClass;
    private List<DataType<?>> sortedInstances;

    public void initialize() {
        super.initialize();
        this.typesByName = new HashMap();
        this.typesByClass = new HashMap();
        for (DataType type : super.getInstances()) {
            this.typesByName.put(type.longName(), type);
            this.typesByClass.put(type.getType().getClass(), type);
        }
        this.sortedInstances = new ArrayList();
        this.sortedInstances.addAll(super.getInstances());
        Collections.sort(this.sortedInstances, new Comparator<DataType<?>>(){

            @Override
            public int compare(DataType<?> o1, DataType<?> o2) {
                return o1.longName().compareTo(o2.longName());
            }
        });
        this.sortedInstances = Collections.unmodifiableList(this.sortedInstances);
    }

    @Override
    public List<DataType<?>> getInstances() {
        return this.sortedInstances;
    }

    public Class<DataType<?>> getPluginType() {
        return DataType.class;
    }

    @Override
    public DataType<?> getTypeByName(String typeName) {
        return this.typesByName.get(typeName);
    }

    @Override
    public DataType<?> getTypeByClass(Class<?> typeClass) {
        return this.typesByClass.get(typeClass);
    }

    @Override
    public DataType<?> getTypeByAttributes(int bitCount, boolean bounded, boolean complex, boolean floating, boolean signed) {
        for (DataType<?> dataType : this.sortedInstances) {
            if (bitCount != dataType.bitCount() || bounded != dataType.isBounded() || complex != dataType.isComplex() || floating != dataType.isFloat() || signed != dataType.isSigned()) continue;
            return dataType;
        }
        return null;
    }

    @Override
    public <U extends NumericType<U>, V extends NumericType<V>> void cast(DataType<U> inputType, U input, DataType<V> outputType, V output) {
        this.cast(inputType, input, outputType, output, null);
    }

    @Override
    public <U extends NumericType<U>, V extends NumericType<V>> void cast(DataType<U> inputType, U input, DataType<V> outputType, V output, BigComplex tmp) {
        if (inputType.hasLongRepresentation() && outputType.hasLongRepresentation()) {
            long val = inputType.asLong(input);
            outputType.setLong(output, val);
        } else if (inputType.hasDoubleRepresentation() && outputType.hasDoubleRepresentation()) {
            double val = inputType.asDouble(input);
            outputType.setDouble(output, val);
        } else if (inputType.hasLongRepresentation() && outputType.hasDoubleRepresentation()) {
            long val = inputType.asLong(input);
            outputType.setDouble(output, val);
        } else if (inputType.hasDoubleRepresentation() && outputType.hasLongRepresentation()) {
            double val = inputType.asDouble(input);
            outputType.setLong(output, (long)val);
        }
        if (tmp == null) {
            throw new IllegalArgumentException("Could not find a suitable cast. Pass a temporary to the alternate version of cast().");
        }
        inputType.cast(input, tmp);
        outputType.cast(tmp, output);
    }
}

