/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.Arrays;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.DefaultDatasetAxisMetadata;

public class DefaultDatasetAxisMetadataParser
implements N5MetadataParser<DefaultDatasetAxisMetadata> {
    @Override
    public Optional<DefaultDatasetAxisMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        try {
            String path = node.getPath();
            DatasetAttributes attrs = n5.getDatasetAttributes(path);
            if (attrs == null) {
                return Optional.empty();
            }
            String[] axisLabels = (String[])n5.getAttribute(path, "axes", String[].class);
            if (axisLabels == null) {
                return Optional.empty();
            }
            String[] types = (String[])Arrays.stream(axisLabels).map(l -> AxisUtils.defaultAxisTypes.get((String)l)).toArray(String[]::new);
            Object[] units = (String[])n5.getAttribute(path, "units", String[].class);
            if (units == null) {
                units = new String[n5.getDatasetAttributes(path).getNumDimensions()];
                Arrays.fill(units, "pixel");
            }
            return Optional.of(new DefaultDatasetAxisMetadata(path, axisLabels, types, (String[])units, attrs));
        }
        catch (N5Exception e) {
            return Optional.empty();
        }
    }
}

