/*
 * Decompiled with CFR 0.152.
 */
import color.CIELAB;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Average_Color
implements PlugInFilter {
    protected ImagePlus image;
    protected int w;
    protected int h;
    protected int[] pixels;

    public void test() {
        GenericDialog gd = new GenericDialog("L*");
        gd.addNumericField("L*", 75.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float l = (float)gd.getNextNumber();
        float[] lab = new float[3];
        float[] rgb = new float[3];
        int[] rgbi = new int[3];
        this.h = 257;
        this.w = 257;
        this.pixels = new int[this.w * this.h];
        for (int a = -128; a <= 128; ++a) {
            for (int b = -128; b <= 128; ++b) {
                lab[0] = l;
                lab[1] = a;
                lab[2] = b;
                CIELAB.CIELAB2sRGB((float[])lab, (float[])rgb);
                rgbi[0] = CIELAB.unnorm((float)rgb[0]);
                rgbi[1] = CIELAB.unnorm((float)rgb[1]);
                rgbi[2] = CIELAB.unnorm((float)rgb[2]);
                this.pixels[a + 128 + (b + 128) * this.w] = rgbi[0] << 16 | rgbi[1] << 8 | rgbi[2];
            }
        }
        ColorProcessor p = new ColorProcessor(this.w, this.h, this.pixels);
        new ImagePlus("Colors", (ImageProcessor)p).show();
    }

    public void run(ImageProcessor ip) {
        Roi roi = this.image.getRoi();
        if (roi == null) {
            IJ.error((String)"Need a ROI");
            return;
        }
        boolean haveShapeRoi = roi instanceof ShapeRoi;
        GenericDialog gd = new GenericDialog("Average Color");
        gd.addCheckbox("CIELab averaging", true);
        if (haveShapeRoi) {
            gd.addCheckbox("Split roi", true);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean cielab = gd.getNextBoolean();
        boolean splitRoi = haveShapeRoi ? gd.getNextBoolean() : false;
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.pixels = (int[])this.image.getProcessor().getPixels();
        if (splitRoi) {
            ShapeRoi shape = (ShapeRoi)roi;
            Roi[] rois = shape.getRois();
            for (int i = 0; i < rois.length; ++i) {
                this.averageColorInRoi(rois[i], cielab);
            }
        } else {
            this.averageColorInRoi(roi, cielab);
        }
        this.image.updateAndDraw();
    }

    final float[] getAverageColor(Roi roi, boolean cielab) {
        Rectangle r = roi.getBounds();
        float[] rgb = new float[3];
        float[] lab = new float[3];
        float[] cumul = new float[3];
        int count = 0;
        for (int y = r.y; y < r.y + r.height; ++y) {
            for (int x = r.x; x < r.x + r.width; ++x) {
                if (!roi.contains(x, y)) continue;
                int v = this.pixels[x + this.w * y];
                rgb[0] = CIELAB.norm((float)(v >> 16 & 0xFF));
                rgb[1] = CIELAB.norm((float)(v >> 8 & 0xFF));
                rgb[2] = CIELAB.norm((float)(v & 0xFF));
                if (cielab) {
                    CIELAB.sRGB2CIELAB((float[])rgb, (float[])lab);
                    cumul[0] = cumul[0] + lab[0];
                    cumul[1] = cumul[1] + lab[1];
                    cumul[2] = cumul[2] + lab[2];
                } else {
                    cumul[0] = cumul[0] + rgb[0];
                    cumul[1] = cumul[1] + rgb[1];
                    cumul[2] = cumul[2] + rgb[2];
                }
                ++count;
            }
        }
        cumul[0] = cumul[0] / (float)count;
        cumul[1] = cumul[1] / (float)count;
        cumul[2] = cumul[2] / (float)count;
        return cumul;
    }

    private void averageColorInRoi(Roi roi, boolean cielab) {
        Rectangle r = roi.getBounds();
        float[] cumul = this.getAverageColor(roi, cielab);
        float[] rgb = new float[3];
        int[] rgbi = new int[3];
        if (cielab) {
            CIELAB.CIELAB2sRGB((float[])cumul, (float[])rgb);
            rgbi[0] = CIELAB.unnorm((float)rgb[0]);
            rgbi[1] = CIELAB.unnorm((float)rgb[1]);
            rgbi[2] = CIELAB.unnorm((float)rgb[2]);
        } else {
            rgbi[0] = CIELAB.unnorm((float)cumul[0]);
            rgbi[1] = CIELAB.unnorm((float)cumul[1]);
            rgbi[2] = CIELAB.unnorm((float)cumul[2]);
        }
        int v = rgbi[0] << 16 | rgbi[1] << 8 | rgbi[2];
        for (int y = r.y; y < r.y + r.height; ++y) {
            for (int x = r.x; x < r.x + r.width; ++x) {
                if (!roi.contains(x, y)) continue;
                this.pixels[x + this.w * y] = v;
            }
        }
    }

    public int setup(String args, ImagePlus imp) {
        this.image = imp;
        return 16;
    }

    public static String getAverageCIELAB() {
        Average_Color t = new Average_Color();
        try {
            t.image = WindowManager.getCurrentImage();
            t.pixels = (int[])t.image.getProcessor().getPixels();
            t.w = t.image.getWidth();
            t.h = t.image.getHeight();
            Roi roi = t.image.getRoi();
            if (roi == null) {
                roi = new Roi(0, 0, t.w, t.h);
            }
            float[] result = t.getAverageColor(roi, true);
            return "" + result[0] + " " + result[1] + " " + result[2];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String setColorCIELAB(String L, String a, String b) {
        try {
            float[] lab = new float[]{Float.parseFloat(L), Float.parseFloat(a), Float.parseFloat(b)};
            float[] rgb = new float[3];
            CIELAB.CIELAB2sRGB((float[])lab, (float[])rgb);
            int red = CIELAB.unnorm((float)rgb[0]);
            int green = CIELAB.unnorm((float)rgb[1]);
            int blue = CIELAB.unnorm((float)rgb[2]);
            IJ.setForegroundColor((int)red, (int)green, (int)blue);
            return "" + red + " " + green + " " + blue;
        }
        catch (Exception e) {
            return "";
        }
    }
}

