/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij3d.Image3DUniverse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import math3d.NormalEstimator;
import math3d.Point3d;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.scijava.util.DoubleArray;
import org.scijava.util.IntArray;
import vib.InterpolatedImage;

public class Extract_Surface
implements PlugInFilter {
    ImagePlus image;
    InterpolatedImage ii;
    Calibration calib;
    Map surfaceVoxels = new TreeMap();
    Vector vertices = new Vector();
    Set vertexCandidates;
    double maxDev2;
    Point3f[] normals;
    Map edges;
    static int lineMeshCount = 0;
    Vector connected;
    Map triangles;
    int triangleCount = 0;
    Image3DUniverse universe;
    int pointCount = 0;
    boolean verbose = true;
    int lowerThreshold;
    int upperThreshold;

    public void run(ImageProcessor ip) {
        this.calib = this.image.getCalibration();
        GenericDialog gd = new GenericDialog("Transform Parameters");
        gd.addNumericField("LowerThreshold", 1.0, 0);
        gd.addNumericField("UpperThreshold", 255.0, 0);
        gd.addNumericField("CullRadius", 6.0, 0);
        gd.addStringField("outputFileName", "");
        gd.addStringField("outputVRMLFileName", "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.lowerThreshold = (int)gd.getNextNumber();
        this.upperThreshold = (int)gd.getNextNumber();
        double cullRadius = gd.getNextNumber();
        String fileName = gd.getNextString();
        String wrlFileName = gd.getNextString();
        this.maxDev2 = cullRadius * cullRadius;
        this.ii = new InterpolatedImage(this.image);
        IJ.showProgress((int)0, (int)6);
        IJ.showStatus((String)"find vertices");
        this.getAllVertices();
        IJ.showProgress((int)1, (int)6);
        IJ.showStatus((String)"reassociate vertices");
        this.reassociateVertices();
        IJ.showProgress((int)3, (int)6);
        IJ.showStatus((String)"get edges");
        this.getEdges();
        IJ.showProgress((int)4, (int)6);
        IJ.showStatus((String)"get triangles");
        this.getTriangles();
        IJ.showProgress((int)5, (int)6);
        IJ.showStatus((String)"show triangles");
        this.showTriangles(0xFF0000);
        IJ.showProgress((int)6, (int)6);
        if (!wrlFileName.equals("")) {
            this.saveWRL(wrlFileName);
        }
        if (!fileName.equals("")) {
            this.saveAsText(fileName);
        }
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 131;
    }

    public SurfaceVoxel getVertex(int index) {
        return (SurfaceVoxel)this.vertices.get(index);
    }

    public SurfaceVoxel getVoxel(int i, int j, int k) {
        SurfaceVoxel voxel = new SurfaceVoxel(i, j, k);
        SurfaceVoxel voxel2 = (SurfaceVoxel)this.surfaceVoxels.get(voxel);
        if (voxel2 != null) {
            return voxel2;
        }
        this.surfaceVoxels.put(voxel, voxel);
        return voxel;
    }

    public SurfaceVoxel getFirstPoint() {
        InterpolatedImage.Iterator iter = this.ii.iterator();
        while (iter.next() != null) {
            if (!this.testVoxel(iter.i, iter.j, iter.k)) continue;
            SurfaceVoxel voxel = this.getVoxel(iter.i, iter.j, iter.k);
            this.surfaceVoxels.put(voxel, voxel);
            return voxel;
        }
        return null;
    }

    public void addVertex(SurfaceVoxel vertex) {
        int vertexIndex = this.vertices.size();
        this.vertices.addElement(vertex);
        NeighbourQueue queue = new NeighbourQueue(vertex);
        while (queue.getDistance() < this.maxDev2) {
            SurfaceVoxel voxel = queue.pop();
            if (voxel.vertexIndex >= 0) continue;
            voxel.setVertex(vertexIndex);
        }
        Iterator iter = queue.iterator();
        while (iter.hasNext()) {
            this.vertexCandidates.add(iter.next());
        }
    }

    public void getAllVertices() {
        this.vertexCandidates = new TreeSet();
        SurfaceVoxel first = this.getFirstPoint();
        if (first == null) {
            throw new RuntimeException("Empty material!");
        }
        this.vertexCandidates.add(first);
        block0: while (this.vertexCandidates.size() > 0) {
            Iterator iter = this.vertexCandidates.iterator();
            while (iter.hasNext()) {
                SurfaceVoxel voxel = (SurfaceVoxel)iter.next();
                if (voxel.vertexIndex < 0) {
                    this.addVertex(voxel);
                    continue block0;
                }
                iter.remove();
            }
        }
    }

    void showAllPoints() {
        this.showAllPoints(false);
    }

    Color3f makeColor(int v) {
        return new Color3f((float)(v >> 16 & 0xFF) / 255.0f, (float)(v >> 8 & 0xFF) / 255.0f, (float)(v & 0xFF) / 255.0f);
    }

    void showAllPoints(boolean clearObjects) {
        this.showPoints(this.surfaceVoxels.keySet().iterator(), 0xFF0000);
    }

    void reassociateVertices() {
        for (int i = 0; i < this.vertices.size(); ++i) {
            SurfaceVoxel vertex = (SurfaceVoxel)this.vertices.get(i);
            NeighbourQueue queue = new NeighbourQueue(vertex, false);
            while (queue.size() > 0) {
                SurfaceVoxel voxel = queue.pop();
                if (voxel.vertexIndex != i) {
                    double d = voxel.distance2(vertex);
                    if (d > voxel.distance) continue;
                    voxel.setVertex(i);
                }
                SurfaceVoxel.NeighbourIterator iter = voxel.iterator();
                while (iter.hasNext()) {
                    SurfaceVoxel neighbour = (SurfaceVoxel)iter.next();
                    queue.push(neighbour);
                }
            }
        }
    }

    static Point3f Point3d2Point3f(Point3d p) {
        return new Point3f((float)p.x, (float)p.y, (float)p.z);
    }

    void getNormals() {
        this.normals = new Point3f[this.vertices.size()];
        for (int i = 0; i < this.normals.length; ++i) {
            SurfaceVoxel vertex = this.getVertex(i);
            NeighbourQueue queue = new NeighbourQueue(vertex);
            NormalEstimator est = new NormalEstimator();
            while (queue.getDistance() < this.maxDev2) {
                SurfaceVoxel voxel = queue.pop();
                est.add(voxel.getPoint3d());
            }
            this.normals[i] = Extract_Surface.Point3d2Point3f(est.getNormal());
        }
    }

    void getEdges() {
        this.edges = new TreeMap();
        for (SurfaceVoxel voxel : this.surfaceVoxels.keySet()) {
            SurfaceVoxel.NeighbourIterator iter2 = voxel.iterator();
            while (iter2.hasNext()) {
                SurfaceVoxel voxel2 = (SurfaceVoxel)iter2.next();
                if (voxel.vertexIndex == voxel2.vertexIndex) continue;
                Edge e = new Edge(voxel.vertexIndex, voxel2.vertexIndex);
                this.edges.put(e, e);
            }
        }
    }

    void showEdges(int color) {
        this.getUniverse();
        ArrayList<Point3f> lineMesh = new ArrayList<Point3f>();
        for (Edge e : this.edges.keySet()) {
            e.addLineTo(lineMesh);
        }
        this.universe.addLineMesh(lineMesh, this.makeColor(color), "line" + lineMeshCount++, false);
    }

    void getTriangles() {
        IntArray a;
        this.connected = new Vector();
        this.connected.setSize(this.vertices.size());
        for (Edge e : this.edges.keySet()) {
            a = (IntArray)this.connected.get(e.a);
            if (a == null) {
                a = new IntArray();
                this.connected.set(e.a, a);
            }
            if (!a.contains(e.b)) {
                a.add((Object)e.b);
            }
            if ((a = (IntArray)this.connected.get(e.b)) == null) {
                a = new IntArray();
                this.connected.set(e.b, a);
            }
            if (a.contains(e.a)) continue;
            a.add((Object)e.a);
        }
        this.triangles = new TreeMap();
        for (Edge e : this.edges.keySet()) {
            a = (IntArray)this.connected.get(e.a);
            IntArray b = (IntArray)this.connected.get(e.b);
            for (int j = 0; j < a.size(); ++j) {
                int c = a.get(j);
                if (!b.contains(c)) continue;
                Triangle t = new Triangle(e.a, e.b, c);
                this.triangles.put(t, t);
            }
        }
    }

    void showTriangles(int color) {
        this.getUniverse();
        ArrayList<Point3f> mesh = new ArrayList<Point3f>();
        for (Triangle t : this.triangles.keySet()) {
            t.addTriangleTo(mesh);
        }
        this.universe.addTriangleMesh(mesh, this.makeColor(color), "mesh" + this.triangleCount++);
    }

    void getUniverse() {
        if (this.universe != null) {
            return;
        }
        this.universe = new Image3DUniverse();
        this.universe.show();
    }

    void showPoints(Iterator iter, int color) {
        this.getUniverse();
        ArrayList<Point3f> mesh = new ArrayList<Point3f>();
        while (iter.hasNext()) {
            Object next = iter.next();
            Point3d p = null;
            p = next instanceof SurfaceVoxel ? ((SurfaceVoxel)next).getPoint3d() : (Point3d)next;
            float radius = (this.ii.w + this.ii.h + this.ii.d) / 6;
            Point3f p1 = new Point3f((float)p.x, (float)p.y, (float)p.z - radius);
            Point3f p2 = new Point3f((float)p.x - 0.5f * radius, (float)p.y + 0.8f * radius, (float)p.z + 0.3f * radius);
            Point3f p3 = new Point3f((float)p.x - 0.5f * radius, (float)p.y - 0.8f * radius, (float)p.z + 0.3f * radius);
            Point3f p4 = new Point3f((float)p.x + 0.8f * radius, (float)p.y, (float)p.z + 0.3f * radius);
            mesh.add(p1);
            mesh.add(p2);
            mesh.add(p3);
            mesh.add(p4);
            mesh.add(p2);
            mesh.add(p3);
            mesh.add(p1);
            mesh.add(p2);
            mesh.add(p4);
            mesh.add(p1);
            mesh.add(p3);
            mesh.add(p4);
        }
        this.universe.addTriangleMesh(mesh, this.makeColor(color), "point" + this.pointCount++);
    }

    public void showSurfaceVoxels() {
        this.getUniverse();
        this.showPoints(this.surfaceVoxels.values().iterator(), -1);
    }

    boolean isWithinThresholds(int i, int j, int k) {
        int v = this.ii.getNoInterpol(i, j, k);
        return v < this.lowerThreshold || v > this.upperThreshold;
    }

    boolean testVoxel(int i, int j, int k) {
        if (!this.isWithinThresholds(i, j, k)) {
            return false;
        }
        for (int z = -1; z <= 1; ++z) {
            for (int y = -1; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    if (this.isWithinThresholds(i + x, j + y, k + z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void saveWRL(String filename) {
        try {
            FileWriter w = new FileWriter(new File(filename));
            PrintWriter pw = new PrintWriter(new BufferedWriter(w));
            pw.println("#VRML V2.0 utf8\n\nTransform { children [ Shape {\n   appearance Appearance { material Material { diffuseColor 0.57 0.57 0.57 } }\n   geometry IndexedFaceSet { coord Coordinate { point [");
            for (SurfaceVoxel v : this.vertices) {
                pw.println("    " + v.getPoint3d());
            }
            pw.println("  ] } coordIndex [");
            for (Triangle t : this.triangles.keySet()) {
                pw.println("    " + t.a + ", " + t.b + ", " + t.c + ", -1,");
                pw.println("    " + t.c + ", " + t.b + ", " + t.a + ", -1,");
            }
            if (this.normals != null) {
                pw.println("  ],\n  normal Normal {\n  vector [\n");
                for (int i = 0; i < this.normals.length; ++i) {
                    pw.println("    " + this.normals[i]);
                }
                pw.println("  ] } normalIndex [");
                for (Triangle t : this.triangles.keySet()) {
                    pw.println("    " + t.a + ", " + t.b + ", " + t.c + ", -1,");
                    pw.println("    " + t.c + ", " + t.b + ", " + t.a + ", -1,");
                }
            }
            pw.println("  ]\n  } }\n] }");
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void saveAsText(String filename) {
        try {
            SurfaceVoxel v;
            int i;
            DecimalFormat f = new DecimalFormat("0.###");
            FileWriter w = new FileWriter(new File(filename));
            PrintWriter pw = new PrintWriter(new BufferedWriter(w));
            pw.println("# vertices");
            pw.println("" + this.vertices.size());
            for (i = 0; i < this.vertices.size(); ++i) {
                v = (SurfaceVoxel)this.vertices.get(i);
                pw.println(v.getPoint3d());
            }
            pw.println("# normals");
            pw.println("" + this.normals.length);
            for (i = 0; i < this.normals.length; ++i) {
                v = this.normals[i];
                pw.println(f.format(((Point3f)v).x) + " " + f.format(((Point3f)v).y) + " " + f.format(((Point3f)v).z));
            }
            pw.println("# triangles");
            pw.println("" + this.triangles.size());
            Iterator iter = this.triangles.keySet().iterator();
            while (iter.hasNext()) {
                pw.println(iter.next());
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class Triangle
    implements Comparable {
        int a;
        int b;
        int c;

        public Triangle(int a, int b, int c) {
            int d;
            if (a > b) {
                d = a;
                a = b;
                b = d;
            }
            if (b > c) {
                d = b;
                b = c;
                c = d;
            }
            if (a > b) {
                d = a;
                a = b;
                b = d;
            }
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public boolean equals(Object other) {
            Triangle o = (Triangle)other;
            return this.a == o.a && this.b == o.b && this.c == o.c;
        }

        public int compareTo(Object other) {
            Triangle o = (Triangle)other;
            int diff = this.a - o.a;
            if (diff == 0 && (diff = this.b - o.b) == 0) {
                diff = this.c - o.c;
            }
            return diff;
        }

        public String toString() {
            return "" + this.a + " " + this.b + " " + this.c;
        }

        public void addTriangleTo(List out) {
            out.add(Extract_Surface.this.getVertex(this.a).getPoint3f());
            out.add(Extract_Surface.this.getVertex(this.b).getPoint3f());
            out.add(Extract_Surface.this.getVertex(this.c).getPoint3f());
            out.add(Extract_Surface.this.getVertex(this.c).getPoint3f());
            out.add(Extract_Surface.this.getVertex(this.b).getPoint3f());
            out.add(Extract_Surface.this.getVertex(this.a).getPoint3f());
        }
    }

    class Edge
    implements Comparable {
        int a;
        int b;

        public Edge(int a, int b) {
            if (a < b) {
                this.a = a;
                this.b = b;
            } else {
                if (a == b) {
                    throw new RuntimeException("illegal edge " + a + " " + b + "!");
                }
                this.a = b;
                this.b = a;
            }
        }

        public boolean equals(Object o) {
            Edge e = (Edge)o;
            return this.a == e.a && this.b == e.b;
        }

        public int compareTo(Object o) {
            Edge e = (Edge)o;
            int diff = this.a - e.a;
            if (diff == 0) {
                diff = this.b - e.b;
            }
            return diff;
        }

        public String toString() {
            return "" + this.a + " " + this.b;
        }

        public void addLineTo(List out) {
            out.add(Extract_Surface.this.getVertex(this.a).getPoint3f());
            out.add(Extract_Surface.this.getVertex(this.b).getPoint3f());
        }
    }

    static class NeighbourQueue {
        Point3d center;
        Vector queue;
        Set done;
        DoubleArray distances;
        boolean pushNeighboursAutomatically;

        public NeighbourQueue(SurfaceVoxel center) {
            this(center, true);
        }

        public NeighbourQueue(SurfaceVoxel center, boolean autoGrow) {
            this.pushNeighboursAutomatically = autoGrow;
            this.center = center.getPoint3d();
            this.queue = new Vector();
            this.distances = new DoubleArray();
            this.done = new TreeSet();
            this.push(center);
        }

        public SurfaceVoxel pop() {
            int newSize = this.queue.size() - 1;
            SurfaceVoxel result = (SurfaceVoxel)this.queue.get(newSize);
            this.queue.setSize(newSize);
            this.distances.setSize(newSize);
            if (this.pushNeighboursAutomatically) {
                SurfaceVoxel.NeighbourIterator iter = result.iterator();
                while (iter.hasNext()) {
                    this.push((SurfaceVoxel)iter.next());
                }
            }
            return result;
        }

        public void push(SurfaceVoxel voxel) {
            int i;
            if (this.done.contains(voxel)) {
                return;
            }
            double distance = this.center.distance2(voxel.getPoint3d());
            for (i = 0; i < this.distances.size() && distance < this.distances.get(i); ++i) {
            }
            this.distances.addValue(i, distance);
            this.queue.add(i, voxel);
            this.done.add(voxel);
        }

        public boolean contains(SurfaceVoxel v) {
            return this.queue.contains(v);
        }

        public Iterator iterator() {
            return this.queue.iterator();
        }

        public int size() {
            return this.queue.size();
        }

        public double getDistance() {
            int index = this.size() - 1;
            if (index < 0) {
                return Double.MAX_VALUE;
            }
            return this.distances.get(index);
        }
    }

    class SurfaceVoxel
    implements Comparable {
        int i;
        int j;
        int k;
        int vertexIndex;
        double distance;
        Vector neighbours;

        public SurfaceVoxel(int i, int j, int k) {
            this.i = i;
            this.j = j;
            this.k = k;
            this.vertexIndex = -1;
        }

        public int hashCodeOld() {
            return this.i | this.j << 11 | this.k << 22;
        }

        public boolean equals(Object o) {
            SurfaceVoxel other = (SurfaceVoxel)o;
            return this.i == other.i && this.j == other.j && this.k == other.k;
        }

        public int compareTo(Object o) {
            SurfaceVoxel other = (SurfaceVoxel)o;
            int diff = this.i - other.i;
            if (diff == 0 && (diff = this.j - other.j) == 0) {
                diff = this.k - other.k;
            }
            return diff;
        }

        public String toString() {
            return "" + this.i + " " + this.j + " " + this.k;
        }

        public Point3d getPoint3d() {
            return new Point3d(Extract_Surface.this.calib.xOrigin + (double)this.i * Extract_Surface.this.calib.pixelWidth, Extract_Surface.this.calib.yOrigin + (double)this.j * Extract_Surface.this.calib.pixelHeight, Extract_Surface.this.calib.zOrigin + (double)this.k * Extract_Surface.this.calib.pixelDepth);
        }

        public Point3f getPoint3f() {
            return new Point3f((float)(Extract_Surface.this.calib.xOrigin + (double)this.i * Extract_Surface.this.calib.pixelWidth), (float)(Extract_Surface.this.calib.yOrigin + (double)this.j * Extract_Surface.this.calib.pixelHeight), (float)(Extract_Surface.this.calib.zOrigin + (double)this.k * Extract_Surface.this.calib.pixelDepth));
        }

        public double distance2(SurfaceVoxel other) {
            return this.getPoint3d().distance2(other.getPoint3d());
        }

        public SurfaceVoxel getVertex() {
            if (this.vertexIndex < 0) {
                return null;
            }
            return (SurfaceVoxel)Extract_Surface.this.vertices.get(this.vertexIndex);
        }

        public void setVertex(int index) {
            this.vertexIndex = index;
            this.distance = this.distance2(this.getVertex());
        }

        public NeighbourIterator iterator() {
            return new NeighbourIterator();
        }

        public class NeighbourIterator
        implements Iterator {
            Iterator iter;

            NeighbourIterator() {
                if (SurfaceVoxel.this.neighbours == null) {
                    this.getNeighbours();
                }
                this.iter = SurfaceVoxel.this.neighbours.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final void getNeighbours() {
                SurfaceVoxel.this.neighbours = new Vector();
                for (int z = SurfaceVoxel.this.k - 1; z <= SurfaceVoxel.this.k + 1; ++z) {
                    for (int y = SurfaceVoxel.this.j - 1; y <= SurfaceVoxel.this.j + 1; ++y) {
                        for (int x = SurfaceVoxel.this.i - 1; x <= SurfaceVoxel.this.i + 1; ++x) {
                            this.getNeighbour(x, y, z);
                        }
                    }
                }
            }

            private final void getNeighbour(int x, int y, int z) {
                if (z == SurfaceVoxel.this.k && y == SurfaceVoxel.this.j && x == SurfaceVoxel.this.i) {
                    return;
                }
                if (!Extract_Surface.this.testVoxel(x, y, z)) {
                    return;
                }
                SurfaceVoxel.this.neighbours.add(Extract_Surface.this.getVoxel(x, y, z));
            }
        }
    }
}

