/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import jnr.constants.platform.Errno;
import jnr.posix.util.Platform;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.imp;

public class errno
implements ClassDictInit {
    public static final PyString __doc__ = Py.newString("This module makes available standard errno system symbols.\n\nThe value of each symbol is the corresponding integer value,\ne.g., on most systems, errno.ENOENT equals the integer 2.\n\nThe dictionary errno.errorcode maps numeric codes to symbol names,\ne.g., errno.errorcode[2] could be the string 'ENOENT'.\n\nSymbols that are not relevant to the underlying system are not defined.\n\nTo map error codes to error messages, use the function os.strerror(),\ne.g. os.strerror(2) could return 'No such file or directory'.");
    public static final PyObject errorcode = new PyDictionary();

    public static void classDictInit(PyObject dict) {
        if (Platform.IS_WINDOWS) {
            errno.initWindows(dict);
        } else {
            errno.initPosix(dict);
        }
        errno.addCode(dict, "ESOCKISBLOCKING", 20000, "Socket is in blocking mode");
        errno.addCode(dict, "EGETADDRINFOFAILED", 20001, "getaddrinfo failed");
        dict.__setitem__("classDictInit", null);
    }

    private static void initWindows(PyObject dict) {
        ConstantSet winErrnos = ConstantSet.getConstantSet((String)"Errno");
        ConstantSet lastErrors = ConstantSet.getConstantSet((String)"LastError");
        for (Errno errno2 : Errno.values()) {
            String errnoName = errno2.name();
            Constant constant = winErrnos.getConstant(errnoName);
            if (constant == null && (constant = lastErrors.getConstant("WSA" + errnoName)) == null) continue;
            errno.addCode(dict, errnoName, constant.intValue(), constant.toString());
        }
        for (Constant lastError : lastErrors) {
            if (!lastError.name().startsWith("WSA")) continue;
            errno.addCode(dict, lastError.name(), lastError.intValue(), lastError.toString());
        }
    }

    private static void initPosix(PyObject dict) {
        for (Constant constant : ConstantSet.getConstantSet((String)"Errno")) {
            errno.addCode(dict, constant.name(), constant.intValue(), constant.toString());
        }
    }

    private static void addCode(PyObject dict, String name, int code2, String message2) {
        PyString nameObj = Py.newString(name);
        PyInteger codeObj = Py.newInteger(code2);
        dict.__setitem__(nameObj, (PyObject)codeObj);
        errorcode.__setitem__(codeObj, (PyObject)nameObj);
    }

    @Deprecated
    public static PyObject strerror(PyObject code2) {
        Py.warning(Py.DeprecationWarning, "The errno.strerror function is deprecated, use os.strerror.");
        return imp.load("os").__getattr__("strerror").__call__(code2);
    }
}

