/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class DiffusionMask
implements PlugIn {
    public static void run(ImageProcessor ip, FloatProcessor mask, int n) {
        int w = Math.min(ip.getWidth(), mask.getWidth());
        int h = Math.min(ip.getHeight(), mask.getHeight());
        int wh = w * h;
        ImageProcessor ipTarget = ip.duplicate();
        FloatProcessor maskTarget = (FloatProcessor)mask.duplicate();
        int numSaturatedPixels = n;
        do {
            int ri0 = 0;
            int ri1 = w;
            for (int ri2 = 2 * w; ri2 < wh; ri2 += w) {
                int i00 = ri0;
                int i01 = ri0 + 1;
                int i02 = ri0 + 2;
                int i10 = ri1;
                int i11 = ri1 + 1;
                int i12 = ri1 + 2;
                int i20 = ri2;
                int i21 = ri2 + 1;
                int i22 = ri2 + 2;
                while (i02 < ri1) {
                    float m22;
                    float mm22;
                    float m21;
                    float mm21;
                    float m20;
                    float mm20;
                    float m12;
                    float mm12;
                    float mm10;
                    float mm02;
                    float mm01;
                    float m00 = mask.getf(i00);
                    float m01 = mask.getf(i01);
                    float m02 = mask.getf(i02);
                    float m10 = mask.getf(i10);
                    float m11 = mask.getf(i11);
                    float mm11 = 1.0f - m11;
                    float mm00 = mm11 * m00 * 0.25f;
                    float s = mm00 + (mm01 = mm11 * m01 * 0.5f) + (mm02 = mm11 * m02 * 0.25f) + (mm10 = mm11 * m10 * 0.5f) + mm11 + (mm12 = mm11 * (m12 = mask.getf(i12)) * 0.5f) + (mm20 = mm11 * (m20 = mask.getf(i20)) * 0.25f) + (mm21 = mm11 * (m21 = mask.getf(i21)) * 0.5f) + (mm22 = mm11 * (m22 = mask.getf(i22)) * 0.25f);
                    if (s != 0.0f) {
                        ipTarget.setf(i11, (ip.getf(i00) * mm00 + ip.getf(i01) * mm01 + ip.getf(i02) * mm02 + ip.getf(i10) * mm10 + ip.getf(i11) * mm11 + ip.getf(i12) * mm12 + ip.getf(i20) * mm20 + ip.getf(i21) * mm21 + ip.getf(i22) * mm22) / s);
                        maskTarget.setf(i11, (m00 * mm00 + m01 * mm01 + m02 * mm02 + m10 * mm10 + m11 * mm11 + m12 * mm12 + m20 * mm20 + m21 * mm21 + m22 * mm22) / s);
                    }
                    ++i00;
                    ++i01;
                    ++i02;
                    ++i10;
                    ++i11;
                    ++i12;
                    ++i20;
                    ++i21;
                    ++i22;
                }
                IJ.log((String)("row: " + ri1 / w));
                ri0 += w;
                ri1 += w;
            }
            IJ.log((String)("" + ri1 / w));
            System.arraycopy(ipTarget.getPixels(), 0, ip.getPixels(), 0, wh);
            System.arraycopy(maskTarget.getPixels(), 0, mask.getPixels(), 0, wh);
        } while (--numSaturatedPixels > 0);
    }

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        DiffusionMask.run(IJ.getImage().getProcessor(), (FloatProcessor)IJ.getImage().getProcessor().convertToFloat(), 5);
        imp.updateAndDraw();
    }
}

