/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.LoopContext;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.Symbol;

public class BreakTranslator
extends FunctionCallTranslator {
    @Override
    public Symbol getName() {
        return Symbol.get("break");
    }

    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        this.addStatement(builder, context, call2);
        return new Constant(Null.INSTANCE);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        if (!(context instanceof LoopContext)) {
            throw new InvalidSyntaxException("`break` cannot be used outside of a loop");
        }
        LoopContext loopContext = (LoopContext)context;
        builder.addStatement(new GotoStatement(loopContext.getExitLabel()));
    }
}

