/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.primitives.subset.Subscript;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;

public class LogicalSubscript
extends Subscript {
    private int count = 0;
    private int[] indices;

    public LogicalSubscript(int dimLength, LogicalVector subscript) {
        if (subscript.length() == 0) {
            this.indices = new int[0];
        } else {
            this.indices = new int[dimLength];
            for (int i = 0; i != this.indices.length; ++i) {
                int subscriptIndex = i % subscript.length();
                int value = subscript.getElementAsRawLogical(subscriptIndex);
                if (value == 1) {
                    this.indices[this.count++] = i;
                    continue;
                }
                if (!IntVector.isNA(value)) continue;
                this.indices[this.count++] = Integer.MIN_VALUE;
            }
        }
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getAt(int i) {
        return this.indices[i];
    }
}

