/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.picking;

import org.jogamp.java3d.PickPoint;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class Intersect {
    public static boolean rayAndQuad(PickRay ray, Point3d[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect0"));
        }
        Point3d[] pnts = new Point3d[4];
        for (int i = 0; i < 4; ++i) {
            pnts[i] = coordinates[index + i];
        }
        return Intersect.rayAndPoly(pnts, ray, dist);
    }

    public static boolean rayAndTriangle(PickRay ray, Point3d[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect1"));
        }
        Point3d[] pnts = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            pnts[i] = coordinates[index + i];
        }
        return Intersect.rayAndPoly(pnts, ray, dist);
    }

    public static boolean rayAndTriangle(PickRay ray, Point3f[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect1"));
        }
        Point3d[] pnts = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            pnts[i] = new Point3d(coordinates[index + i]);
        }
        return Intersect.rayAndPoly(pnts, ray, dist);
    }

    public static boolean segmentAndQuad(PickSegment segment, Point3d[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect3"));
        }
        Point3d[] pnts = new Point3d[4];
        for (int i = 0; i < 4; ++i) {
            pnts[i] = coordinates[index + i];
        }
        return Intersect.segmentAndPoly(pnts, segment, dist);
    }

    public static boolean segmentAndQuad(PickSegment segment, Point3f[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect3"));
        }
        Point3d[] pnts = new Point3d[4];
        for (int i = 0; i < 4; ++i) {
            pnts[i] = new Point3d(coordinates[index + i]);
        }
        return Intersect.segmentAndPoly(pnts, segment, dist);
    }

    public static boolean segmentAndTriangle(PickSegment segment, Point3d[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect5"));
        }
        Point3d[] pnts = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            pnts[i] = coordinates[index + i];
        }
        return Intersect.segmentAndPoly(pnts, segment, dist);
    }

    public static boolean segmentAndTriangle(PickSegment segment, Point3f[] coordinates, int index, double[] dist) {
        if (coordinates.length - index < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect6"));
        }
        Point3d[] pnts = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            pnts[i] = new Point3d(coordinates[index + i]);
        }
        return Intersect.segmentAndPoly(pnts, segment, dist);
    }

    private static boolean pointAndQuad(PickPoint point, Point3d[] coordinates, int index) {
        if (coordinates.length - index < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect7"));
        }
        Point3d[] pnts = new Point3d[4];
        for (int i = 0; i < 4; ++i) {
            pnts[i] = coordinates[index + i];
        }
        return Intersect.pointAndPoly(pnts, point);
    }

    private static boolean pointAndQuad(PickPoint point, Point3f[] coordinates, int index) {
        if (coordinates.length - index < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect7"));
        }
        Point3d[] pnts = new Point3d[4];
        for (int i = 0; i < 4; ++i) {
            pnts[i] = new Point3d(coordinates[index + i]);
        }
        return Intersect.pointAndPoly(pnts, point);
    }

    private static boolean pointAndTriangle(PickPoint point, Point3d[] coordinates, int index) {
        if (coordinates.length - index < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect9"));
        }
        Point3d[] pnts = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            pnts[i] = coordinates[index + i];
        }
        return Intersect.pointAndPoly(pnts, point);
    }

    private static boolean pointAndTriangle(PickPoint point, Point3f[] coordinates, int index) {
        if (coordinates.length - index < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect10"));
        }
        Point3d[] pnts = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            pnts[i] = new Point3d(coordinates[index + i]);
        }
        return Intersect.pointAndPoly(pnts, point);
    }

    public static boolean rayAndPoint(PickRay ray, Point3d pnt, double[] dist) {
        Point3d origin = new Point3d();
        Vector3d direction = new Vector3d();
        ray.get(origin, direction);
        return Intersect.rayAndPoint(pnt, origin, direction, dist);
    }

    public static boolean rayAndPoint(PickRay ray, Point3f pnt, double[] dist) {
        Point3d origin = new Point3d();
        Vector3d direction = new Vector3d();
        ray.get(origin, direction);
        return Intersect.rayAndPoint(new Point3d(pnt), origin, direction, dist);
    }

    public static boolean segmentAndPoint(PickSegment segment, Point3d pnt, double[] dist) {
        Point3d start = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        segment.get(start, end);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        return Intersect.rayAndPoint(pnt, start, direction, dist) && dist[0] <= 1.0;
    }

    public static boolean segmentAndPoint(PickSegment segment, Point3f pnt, double[] dist) {
        Point3d start = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        segment.get(start, end);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        return Intersect.rayAndPoint(new Point3d(pnt), start, direction, dist) && dist[0] <= 1.0;
    }

    public static boolean pointAndPoint(PickPoint point, Point3d pnt) {
        Point3d location = new Point3d();
        point.get(location);
        return location.x == pnt.x && location.y == pnt.y && location.z == pnt.z;
    }

    public static boolean pointAndPoint(PickPoint point, Point3f pnt) {
        Point3d location = new Point3d();
        point.get(location);
        return (float)location.x == pnt.x && (float)location.y == pnt.y && (float)location.z == pnt.z;
    }

    public static boolean rayAndLine(PickRay ray, Point3d[] coordinates, int index, double[] dist) {
        Point3d origin = new Point3d();
        Vector3d direction = new Vector3d();
        if (coordinates.length - index < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect11"));
        }
        ray.get(origin, direction);
        Point3d start = coordinates[index++];
        Point3d end = coordinates[index];
        return Intersect.lineAndRay(start, end, origin, direction, dist);
    }

    public static boolean rayAndLine(PickRay ray, Point3f[] coordinates, int index, double[] dist) {
        Point3d origin = new Point3d();
        Vector3d direction = new Vector3d();
        if (coordinates.length - index < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect11"));
        }
        ray.get(origin, direction);
        Point3d start = new Point3d(coordinates[index++]);
        Point3d end = new Point3d(coordinates[index]);
        return Intersect.lineAndRay(start, end, origin, direction, dist);
    }

    public static boolean segmentAndLine(PickSegment segment, Point3d[] coordinates, int index, double[] dist) {
        Point3d start = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        if (coordinates.length - index < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        segment.get(start, end);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        Point3d startpnt = coordinates[index++];
        Point3d endpnt = coordinates[index];
        return Intersect.lineAndRay(startpnt, endpnt, start, direction, dist) && dist[0] <= 1.0;
    }

    public static boolean segmentAndLine(PickSegment segment, Point3f[] coordinates, int index, double[] dist) {
        Point3d start = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        if (coordinates.length - index < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        segment.get(start, end);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        Point3d startpnt = new Point3d(coordinates[index++]);
        Point3d endpnt = new Point3d(coordinates[index]);
        return Intersect.lineAndRay(startpnt, endpnt, start, direction, dist) && dist[0] <= 1.0;
    }

    public static boolean pointAndLine(PickPoint point, Point3d[] coordinates, int index) {
        if (coordinates.length - index < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        double[] dist = new double[1];
        Point3d start = coordinates[index++];
        Point3d end = coordinates[index];
        Point3d location = new Point3d();
        Vector3d direction = new Vector3d();
        point.get(location);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        return Intersect.rayAndPoint(location, start, direction, dist) && dist[0] <= 1.0;
    }

    public static boolean pointAndLine(PickPoint point, Point3f[] coordinates, int index) {
        if (coordinates.length - index < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        double[] dist = new double[1];
        Point3d start = new Point3d(coordinates[index++]);
        Point3d end = new Point3d(coordinates[index]);
        Point3d location = new Point3d();
        Vector3d direction = new Vector3d();
        point.get(location);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        return Intersect.rayAndPoint(location, start, direction, dist) && dist[0] <= 1.0;
    }

    private static boolean pointAndPoly(Point3d[] coordinates, PickPoint point) {
        int j;
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        Vector3d tempV3d = new Vector3d();
        double pNrmDotrDir = 0.0;
        int i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (!(vec0.length() > 0.0)) continue;
        }
        for (j = i; j < coordinates.length - 1; ++j) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        if (pNrm.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        Point3d location = new Point3d();
        point.get(location);
        tempV3d.set((Tuple3d)location);
        return pD - pNrm.dot(tempV3d) == 0.0;
    }

    private static boolean lineAndRay(Point3d start, Point3d end, Point3d ori, Vector3d dir, double[] dist) {
        Vector3d lDir = new Vector3d(end.x - start.x, end.y - start.y, end.z - start.z);
        double m00 = lDir.x;
        double m11 = -dir.y;
        double m10 = lDir.y;
        double m01 = -dir.x;
        double dmt = m00 * m11 - m10 * m01;
        if (dmt == 0.0) {
            return false;
        }
        double tmp1 = 1.0 / dmt;
        double mInv00 = tmp1 * m11;
        double mInv01 = tmp1 * -m01;
        double mInv10 = tmp1 * -m10;
        double mInv11 = tmp1 * m00;
        tmp1 = ori.x - start.x;
        double tmp2 = ori.y - start.y;
        double t = mInv00 * tmp1 + mInv01 * tmp2;
        double s = mInv10 * tmp1 + mInv11 * tmp2;
        if (s < 0.0) {
            return false;
        }
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        tmp1 = ori.z + s * dir.z;
        tmp2 = start.z + t * lDir.z;
        if (tmp1 < tmp2 - Double.MIN_VALUE || tmp1 > tmp2 + Double.MIN_VALUE) {
            return false;
        }
        dist[0] = s;
        return true;
    }

    private static boolean rayAndPoint(Point3d pnt, Point3d ori, Vector3d dir, double[] dist) {
        double temp;
        int flag = 0;
        if (dir.x != 0.0) {
            flag = 0;
            dist[0] = (pnt.x - ori.x) / dir.x;
        } else if (dir.y != 0.0) {
            if (pnt.x != ori.x) {
                return false;
            }
            flag = 1;
            dist[0] = (pnt.y - ori.y) / dir.y;
        } else if (dir.z != 0.0) {
            if (pnt.x != ori.x || pnt.y != ori.y) {
                return false;
            }
            flag = 2;
            dist[0] = (pnt.z - ori.z) / dir.z;
        } else {
            return false;
        }
        if (dist[0] < 0.0) {
            return false;
        }
        if (flag == 0 && (pnt.y < (temp = ori.y + dist[0] * dir.y) - Double.MIN_VALUE || pnt.y > temp + Double.MIN_VALUE)) {
            return false;
        }
        return flag >= 2 || !(pnt.z < (temp = ori.z + dist[0] * dir.z) - Double.MIN_VALUE) && !(pnt.z > temp + Double.MIN_VALUE);
    }

    private static boolean rayAndPoly(Point3d[] coordinates, PickRay ray, double[] dist) {
        int j;
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        Vector3d tempV3d = new Vector3d();
        double pNrmDotrDir = 0.0;
        Point3d origin = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt = new Point3d();
        double[] uCoor = new double[4];
        double[] vCoor = new double[4];
        int i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (!(vec0.length() > 0.0)) continue;
        }
        for (j = i; j < coordinates.length - 1; ++j) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        if (pNrm.length() == 0.0) {
            return false;
        }
        ray.get(origin, direction);
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        pNrmDotrDir = pNrm.dot(direction);
        if (pNrmDotrDir == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)origin);
        dist[0] = (pD - pNrm.dot(tempV3d)) / pNrmDotrDir;
        if (dist[0] < 0.0) {
            return false;
        }
        iPnt.x = origin.x + direction.x * dist[0];
        iPnt.y = origin.y + direction.y * dist[0];
        iPnt.z = origin.z + direction.z * dist[0];
        double absNrmX = Math.abs(pNrm.x);
        double absNrmY = Math.abs(pNrm.y);
        double absNrmZ = Math.abs(pNrm.z);
        int axis = absNrmX > absNrmY ? 0 : 1;
        if (axis == 0) {
            if (absNrmX < absNrmZ) {
                axis = 2;
            }
        } else if (axis == 1 && absNrmY < absNrmZ) {
            axis = 2;
        }
        block7: for (i = 0; i < coordinates.length; ++i) {
            switch (axis) {
                case 0: {
                    uCoor[i] = coordinates[i].y - iPnt.y;
                    vCoor[i] = coordinates[i].z - iPnt.z;
                    continue block7;
                }
                case 1: {
                    uCoor[i] = coordinates[i].x - iPnt.x;
                    vCoor[i] = coordinates[i].z - iPnt.z;
                    continue block7;
                }
                case 2: {
                    uCoor[i] = coordinates[i].x - iPnt.x;
                    vCoor[i] = coordinates[i].y - iPnt.y;
                }
            }
        }
        int nc = 0;
        int sh = vCoor[0] < 0.0 ? -1 : 1;
        for (i = 0; i < coordinates.length; ++i) {
            double tempD;
            int nsh;
            j = i + 1;
            if (j == coordinates.length) {
                j = 0;
            }
            if (sh == (nsh = vCoor[j] < 0.0 ? -1 : 1)) continue;
            if (uCoor[i] > 0.0 && uCoor[j] > 0.0) {
                ++nc;
            } else if ((uCoor[i] > 0.0 || uCoor[j] > 0.0) && (tempD = uCoor[i] - vCoor[i] * (uCoor[j] - uCoor[i]) / (vCoor[j] - vCoor[i])) > 0.0) {
                ++nc;
            }
            sh = nsh;
        }
        if (nc % 2 == 1) {
            dist[0] = dist[0] * direction.length();
            return true;
        }
        return false;
    }

    private static boolean segmentAndPoly(Point3d[] coordinates, PickSegment segment, double[] dist) {
        int j;
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        Vector3d tempV3d = new Vector3d();
        Vector3d direction = new Vector3d();
        double pNrmDotrDir = 0.0;
        Point3d start = new Point3d();
        Point3d end = new Point3d();
        Point3d iPnt = new Point3d();
        double[] uCoor = new double[4];
        double[] vCoor = new double[4];
        int i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (!(vec0.length() > 0.0)) continue;
        }
        for (j = i; j < coordinates.length - 1; ++j) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        if (pNrm.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        segment.get(start, end);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        pNrmDotrDir = pNrm.dot(direction);
        if (pNrmDotrDir == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)start);
        dist[0] = (pD - pNrm.dot(tempV3d)) / pNrmDotrDir;
        if (dist[0] < 0.0 || dist[0] > 1.0) {
            return false;
        }
        iPnt.x = start.x + direction.x * dist[0];
        iPnt.y = start.y + direction.y * dist[0];
        iPnt.z = start.z + direction.z * dist[0];
        double absNrmX = Math.abs(pNrm.x);
        double absNrmY = Math.abs(pNrm.y);
        double absNrmZ = Math.abs(pNrm.z);
        int axis = absNrmX > absNrmY ? 0 : 1;
        if (axis == 0) {
            if (absNrmX < absNrmZ) {
                axis = 2;
            }
        } else if (axis == 1 && absNrmY < absNrmZ) {
            axis = 2;
        }
        block7: for (i = 0; i < coordinates.length; ++i) {
            switch (axis) {
                case 0: {
                    uCoor[i] = coordinates[i].y - iPnt.y;
                    vCoor[i] = coordinates[i].z - iPnt.z;
                    continue block7;
                }
                case 1: {
                    uCoor[i] = coordinates[i].x - iPnt.x;
                    vCoor[i] = coordinates[i].z - iPnt.z;
                    continue block7;
                }
                case 2: {
                    uCoor[i] = coordinates[i].x - iPnt.x;
                    vCoor[i] = coordinates[i].y - iPnt.y;
                }
            }
        }
        int nc = 0;
        int sh = vCoor[0] < 0.0 ? -1 : 1;
        for (i = 0; i < coordinates.length; ++i) {
            double tempD;
            int nsh;
            j = i + 1;
            if (j == coordinates.length) {
                j = 0;
            }
            if (sh == (nsh = vCoor[j] < 0.0 ? -1 : 1)) continue;
            if (uCoor[i] > 0.0 && uCoor[j] > 0.0) {
                ++nc;
            } else if ((uCoor[i] > 0.0 || uCoor[j] > 0.0) && (tempD = uCoor[i] - vCoor[i] * (uCoor[j] - uCoor[i]) / (vCoor[j] - vCoor[i])) > 0.0) {
                ++nc;
            }
            sh = nsh;
        }
        if (nc % 2 == 1) {
            dist[0] = dist[0] * direction.length();
            return true;
        }
        return false;
    }
}

